/**
 * @file vtrecv.c
 * @author CuBeatSystems
 * @author Shinichiro Nakamura
 * @copyright
 * ===============================================================
 * Natural Tiny Shell (NT-Shell) Version 0.3.1
 * ===============================================================
 * Copyright (c) 2010-2016 Shinichiro Nakamura
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or
 * sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*
 * @note
 * An implementation of Paul Williams' DEC compatible state machine parser.
 * This code is in the public domain.
 *
 * @author Joshua Haberman <joshua@reverberate.org>
 * @author Shinichiro Nakamura : Modified for Natural Tiny Shell (NT-Shell)
 */

#include "vtrecv.h"

static state_change_t GET_STATE_TABLE(const int state, const int ch);
static vtrecv_action_t GET_ENTRY_ACTIONS(const int state);
static vtrecv_action_t GET_EXIT_ACTIONS(const int state);

#if (USE_ORIGINAL_LUT==1)
static const state_change_t STATE_TABLE[14][256] = {
  {  /* VTRECV_STATE_CSI_ENTRY = 0 */
    /*0  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*1  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*2  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*3  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*4  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*5  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*6  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*7  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*8  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*9  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*10 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*11 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*12 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*13 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*14 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*15 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*16 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*17 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*18 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*19 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*20 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*21 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*22 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*23 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*29 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*30 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*31 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*48 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*49 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*50 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*51 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*52 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*53 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*54 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*55 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*56 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*57 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*58 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*59 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_CSI_PARAM           << 4),
    /*60 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_PARAM           << 4),
    /*61 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_PARAM           << 4),
    /*62 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_PARAM           << 4),
    /*63 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_PARAM           << 4),
    /*64 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*65 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*66 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*67 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*68 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*69 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*70 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*71 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*72 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*73 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*74 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*75 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*76 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*77 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*78 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*79 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*80 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*81 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*82 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*83 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*84 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*85 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*86 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*87 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*88 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*89 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*90 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*91 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*92 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*93 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*94 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*95 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*96 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*97 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*98 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*99 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*100*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*101*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*102*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*103*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*104*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*105*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*106*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*107*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*108*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*109*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*110*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*111*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*112*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*113*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*114*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*115*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*116*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*117*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*118*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*119*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*120*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*121*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*122*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*123*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*124*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*125*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*126*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_CSI_IGNORE = 1 */
    /*0  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*1  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*2  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*3  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*4  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*5  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*6  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*7  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*8  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*9  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*10 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*11 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*12 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*13 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*14 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*15 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*16 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*17 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*18 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*19 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*20 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*21 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*22 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*23 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*29 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*30 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*31 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*32 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*33 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*34 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*35 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*36 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*37 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*38 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*39 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*40 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*41 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*42 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*43 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*44 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*45 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*46 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*47 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*48 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*49 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*50 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*51 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*52 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*53 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*54 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*55 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*56 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*57 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*58 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*59 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*60 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*61 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*62 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*63 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*64 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*65 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*66 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*67 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*68 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*69 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*70 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*71 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*72 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*73 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*74 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*75 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*76 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*77 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*78 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*79 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*80 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*81 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*82 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*83 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*84 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*85 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*86 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*87 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*88 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*89 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*90 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*91 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*92 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*93 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*94 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*95 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*96 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*97 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*98 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*99 */  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*100*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*101*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*102*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*103*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*104*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*105*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*106*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*107*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*108*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*109*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*110*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*111*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*112*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*113*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*114*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*115*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*116*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*117*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*118*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*119*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*120*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*121*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*122*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*123*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*124*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*125*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*126*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_CSI_INTERMEDIATE = 2 */
    /*0  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*1  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*2  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*3  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*4  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*5  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*6  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*7  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*8  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*9  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*10 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*11 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*12 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*13 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*14 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*15 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*16 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*17 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*18 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*19 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*20 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*21 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*22 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*23 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*29 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*30 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*31 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*48 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*49 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*50 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*51 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*52 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*53 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*54 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*55 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*56 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*57 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*58 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*59 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*60 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*61 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*62 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*63 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*64 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*65 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*66 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*67 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*68 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*69 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*70 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*71 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*72 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*73 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*74 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*75 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*76 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*77 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*78 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*79 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*80 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*81 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*82 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*83 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*84 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*85 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*86 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*87 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*88 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*89 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*90 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*91 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*92 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*93 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*94 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*95 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*96 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*97 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*98 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*99 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*100*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*101*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*102*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*103*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*104*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*105*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*106*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*107*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*108*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*109*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*110*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*111*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*112*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*113*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*114*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*115*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*116*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*117*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*118*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*119*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*120*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*121*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*122*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*123*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*124*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*125*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*126*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_CSI_PARAM = 3 */
    /*0  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*1  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*2  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*3  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*4  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*5  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*6  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*7  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*8  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*9  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*10 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*11 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*12 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*13 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*14 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*15 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*16 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*17 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*18 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*19 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*20 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*21 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*22 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*23 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*29 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*30 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*31 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_CSI_INTERMEDIATE    << 4),
    /*48 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*49 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*50 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*51 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*52 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*53 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*54 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*55 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*56 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*57 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*58 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*59 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*60 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*61 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*62 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*63 */  0                                 | (VTRECV_STATE_CSI_IGNORE          << 4),
    /*64 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*65 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*66 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*67 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*68 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*69 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*70 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*71 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*72 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*73 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*74 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*75 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*76 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*77 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*78 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*79 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*80 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*81 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*82 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*83 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*84 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*85 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*86 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*87 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*88 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*89 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*90 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*91 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*92 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*93 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*94 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*95 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*96 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*97 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*98 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*99 */  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*100*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*101*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*102*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*103*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*104*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*105*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*106*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*107*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*108*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*109*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*110*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*111*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*112*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*113*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*114*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*115*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*116*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*117*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*118*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*119*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*120*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*121*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*122*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*123*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*124*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*125*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*126*/  VTRECV_ACTION_CSI_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_DCS_ENTRY = 4 */
    /*0  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*1  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*2  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*3  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*4  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*5  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*6  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*7  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*8  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*9  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*10 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*11 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*12 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*13 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*14 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*15 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*16 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*17 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*18 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*19 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*20 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*21 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*22 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*23 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*29 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*30 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*31 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*48 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*49 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*50 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*51 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*52 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*53 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*54 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*55 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*56 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*57 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*58 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*59 */  VTRECV_ACTION_PARAM              | (VTRECV_STATE_DCS_PARAM           << 4),
    /*60 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_PARAM           << 4),
    /*61 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_PARAM           << 4),
    /*62 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_PARAM           << 4),
    /*63 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_PARAM           << 4),
    /*64 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*65 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*66 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*67 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*68 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*69 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*70 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*71 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*72 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*73 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*74 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*75 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*76 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*77 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*78 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*79 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*80 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*81 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*82 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*83 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*84 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*85 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*86 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*87 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*88 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*89 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*90 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*91 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*92 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*93 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*94 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*95 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*96 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*97 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*98 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*99 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*100*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*101*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*102*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*103*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*104*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*105*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*106*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*107*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*108*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*109*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*110*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*111*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*112*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*113*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*114*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*115*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*116*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*117*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*118*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*119*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*120*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*121*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*122*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*123*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*124*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*125*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*126*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_DCS_IGNORE = 5 */
    /*0  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*1  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*2  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*3  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*4  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*5  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*6  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*7  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*8  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*9  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*10 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*11 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*12 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*13 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*14 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*15 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*16 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*17 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*18 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*19 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*20 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*21 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*22 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*23 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*29 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*30 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*31 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*32 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*33 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*34 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*35 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*36 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*37 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*38 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*39 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*40 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*41 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*42 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*43 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*44 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*45 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*46 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*47 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*48 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*49 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*50 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*51 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*52 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*53 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*54 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*55 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*56 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*57 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*58 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*59 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*60 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*61 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*62 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*63 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*64 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*65 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*66 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*67 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*68 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*69 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*70 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*71 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*72 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*73 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*74 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*75 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*76 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*77 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*78 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*79 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*80 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*81 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*82 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*83 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*84 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*85 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*86 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*87 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*88 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*89 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*90 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*91 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*92 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*93 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*94 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*95 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*96 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*97 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*98 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*99 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*100*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*101*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*102*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*103*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*104*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*105*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*106*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*107*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*108*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*109*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*110*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*111*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*112*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*113*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*114*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*115*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*116*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*117*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*118*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*119*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*120*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*121*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*122*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*123*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*124*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*125*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*126*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_DCS_INTERMEDIATE = 6 */
    /*0  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*1  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*2  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*3  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*4  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*5  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*6  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*7  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*8  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*9  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*10 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*11 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*12 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*13 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*14 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*15 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*16 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*17 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*18 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*19 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*20 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*21 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*22 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*23 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*29 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*30 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*31 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*48 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*49 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*50 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*51 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*52 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*53 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*54 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*55 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*56 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*57 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*58 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*59 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*60 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*61 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*62 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*63 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*64 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*65 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*66 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*67 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*68 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*69 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*70 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*71 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*72 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*73 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*74 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*75 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*76 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*77 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*78 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*79 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*80 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*81 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*82 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*83 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*84 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*85 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*86 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*87 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*88 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*89 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*90 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*91 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*92 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*93 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*94 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*95 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*96 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*97 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*98 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*99 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*100*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*101*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*102*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*103*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*104*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*105*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*106*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*107*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*108*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*109*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*110*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*111*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*112*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*113*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*114*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*115*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*116*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*117*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*118*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*119*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*120*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*121*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*122*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*123*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*124*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*125*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*126*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_DCS_PARAM = 7 */
    /*0  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*1  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*2  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*3  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*4  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*5  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*6  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*7  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*8  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*9  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*10 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*11 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*12 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*13 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*14 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*15 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*16 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*17 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*18 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*19 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*20 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*21 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*22 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*23 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*29 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*30 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*31 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4),
    /*48 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*49 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*50 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*51 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*52 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*53 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*54 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*55 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*56 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*57 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*58 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*59 */  VTRECV_ACTION_PARAM              | (0                                 << 4),
    /*60 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*61 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*62 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*63 */  0                                 | (VTRECV_STATE_DCS_IGNORE          << 4),
    /*64 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*65 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*66 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*67 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*68 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*69 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*70 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*71 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*72 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*73 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*74 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*75 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*76 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*77 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*78 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*79 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*80 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*81 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*82 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*83 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*84 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*85 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*86 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*87 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*88 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*89 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*90 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*91 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*92 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*93 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*94 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*95 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*96 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*97 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*98 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*99 */  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*100*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*101*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*102*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*103*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*104*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*105*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*106*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*107*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*108*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*109*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*110*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*111*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*112*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*113*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*114*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*115*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*116*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*117*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*118*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*119*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*120*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*121*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*122*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*123*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*124*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*125*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*126*/  0                                 | (VTRECV_STATE_DCS_PASSTHROUGH     << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_DCS_PASSTHROUGH = 8 */
    /*0  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*1  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*2  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*3  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*4  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*5  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*6  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*7  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*8  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*9  */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*10 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*11 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*12 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*13 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*14 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*15 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*16 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*17 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*18 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*19 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*20 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*21 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*22 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*23 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*29 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*30 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*31 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*32 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*33 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*34 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*35 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*36 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*37 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*38 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*39 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*40 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*41 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*42 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*43 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*44 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*45 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*46 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*47 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*48 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*49 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*50 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*51 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*52 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*53 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*54 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*55 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*56 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*57 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*58 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*59 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*60 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*61 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*62 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*63 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*64 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*65 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*66 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*67 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*68 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*69 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*70 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*71 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*72 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*73 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*74 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*75 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*76 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*77 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*78 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*79 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*80 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*81 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*82 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*83 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*84 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*85 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*86 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*87 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*88 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*89 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*90 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*91 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*92 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*93 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*94 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*95 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*96 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*97 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*98 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*99 */  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*100*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*101*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*102*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*103*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*104*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*105*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*106*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*107*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*108*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*109*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*110*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*111*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*112*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*113*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*114*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*115*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*116*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*117*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*118*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*119*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*120*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*121*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*122*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*123*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*124*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*125*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*126*/  VTRECV_ACTION_PUT                | (0                                 << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_ESCAPE = 9 */
    /*0  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*1  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*2  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*3  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*4  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*5  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*6  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*7  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*8  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*9  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*10 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*11 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*12 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*13 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*14 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*15 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*16 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*17 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*18 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*19 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*20 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*21 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*22 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*23 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*29 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*30 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*31 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4),
    /*48 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*49 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*50 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*51 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*52 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*53 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*54 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*55 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*56 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*57 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*58 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*59 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*60 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*61 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*62 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*63 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*64 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*65 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*66 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*67 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*68 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*69 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*70 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*71 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*72 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*73 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*74 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*75 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*76 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*77 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*78 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*79 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*80 */  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*81 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*82 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*83 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*84 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*85 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*86 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*87 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*88 */  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*89 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*90 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*91 */  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*92 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*93 */  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*94 */  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*95 */  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*96 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*97 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*98 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*99 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*100*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*101*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*102*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*103*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*104*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*105*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*106*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*107*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*108*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*109*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*110*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*111*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*112*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*113*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*114*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*115*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*116*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*117*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*118*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*119*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*120*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*121*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*122*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*123*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*124*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*125*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*126*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_ESCAPE_INTERMEDIATE = 10 */
    /*0  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*1  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*2  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*3  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*4  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*5  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*6  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*7  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*8  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*9  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*10 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*11 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*12 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*13 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*14 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*15 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*16 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*17 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*18 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*19 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*20 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*21 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*22 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*23 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*29 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*30 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*31 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*32 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*33 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*34 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*35 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*36 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*37 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*38 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*39 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*40 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*41 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*42 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*43 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*44 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*45 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*46 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*47 */  VTRECV_ACTION_COLLECT            | (0                                 << 4),
    /*48 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*49 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*50 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*51 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*52 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*53 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*54 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*55 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*56 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*57 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*58 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*59 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*60 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*61 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*62 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*63 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*64 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*65 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*66 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*67 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*68 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*69 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*70 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*71 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*72 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*73 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*74 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*75 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*76 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*77 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*78 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*79 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*80 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*81 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*82 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*83 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*84 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*85 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*86 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*87 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*88 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*89 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*90 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*91 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*92 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*93 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*94 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*95 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*96 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*97 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*98 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*99 */  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*100*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*101*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*102*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*103*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*104*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*105*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*106*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*107*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*108*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*109*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*110*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*111*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*112*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*113*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*114*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*115*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*116*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*117*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*118*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*119*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*120*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*121*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*122*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*123*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*124*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*125*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*126*/  VTRECV_ACTION_ESC_DISPATCH       | (VTRECV_STATE_GROUND              << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_GROUND = 11 */
    /*0  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*1  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*2  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*3  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*4  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*5  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*6  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*7  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*8  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*9  */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*10 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*11 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*12 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*13 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*14 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*15 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*16 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*17 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*18 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*19 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*20 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*21 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*22 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*23 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*29 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*30 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*31 */  VTRECV_ACTION_EXECUTE            | (0                                 << 4),
    /*32 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*33 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*34 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*35 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*36 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*37 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*38 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*39 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*40 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*41 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*42 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*43 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*44 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*45 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*46 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*47 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*48 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*49 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*50 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*51 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*52 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*53 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*54 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*55 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*56 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*57 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*58 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*59 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*60 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*61 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*62 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*63 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*64 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*65 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*66 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*67 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*68 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*69 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*70 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*71 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*72 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*73 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*74 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*75 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*76 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*77 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*78 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*79 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*80 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*81 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*82 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*83 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*84 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*85 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*86 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*87 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*88 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*89 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*90 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*91 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*92 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*93 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*94 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*95 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*96 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*97 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*98 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*99 */  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*100*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*101*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*102*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*103*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*104*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*105*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*106*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*107*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*108*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*109*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*110*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*111*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*112*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*113*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*114*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*115*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*116*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*117*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*118*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*119*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*120*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*121*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*122*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*123*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*124*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*125*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*126*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*127*/  VTRECV_ACTION_PRINT              | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_OSC_STRING = 12 */
    /*0  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*1  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*2  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*3  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*4  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*5  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*6  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*7  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*8  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*9  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*10 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*11 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*12 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*13 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*14 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*15 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*16 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*17 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*18 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*19 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*20 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*21 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*22 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*23 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*29 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*30 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*31 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*32 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*33 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*34 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*35 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*36 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*37 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*38 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*39 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*40 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*41 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*42 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*43 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*44 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*45 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*46 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*47 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*48 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*49 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*50 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*51 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*52 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*53 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*54 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*55 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*56 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*57 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*58 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*59 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*60 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*61 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*62 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*63 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*64 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*65 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*66 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*67 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*68 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*69 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*70 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*71 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*72 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*73 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*74 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*75 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*76 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*77 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*78 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*79 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*80 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*81 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*82 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*83 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*84 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*85 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*86 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*87 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*88 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*89 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*90 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*91 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*92 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*93 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*94 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*95 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*96 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*97 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*98 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*99 */  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*100*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*101*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*102*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*103*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*104*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*105*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*106*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*107*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*108*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*109*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*110*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*111*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*112*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*113*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*114*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*115*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*116*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*117*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*118*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*119*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*120*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*121*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*122*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*123*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*124*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*125*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*126*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*127*/  VTRECV_ACTION_OSC_PUT            | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
  {  /* VTRECV_STATE_SOS_PM_APC_STRING = 13 */
    /*0  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*1  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*2  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*3  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*4  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*5  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*6  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*7  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*8  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*9  */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*10 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*11 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*12 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*13 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*14 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*15 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*16 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*17 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*18 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*19 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*20 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*21 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*22 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*23 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*24 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*25 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*26 */  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*27 */  0                                 | (VTRECV_STATE_ESCAPE              << 4),
    /*28 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*29 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*30 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*31 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*32 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*33 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*34 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*35 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*36 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*37 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*38 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*39 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*40 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*41 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*42 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*43 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*44 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*45 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*46 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*47 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*48 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*49 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*50 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*51 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*52 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*53 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*54 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*55 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*56 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*57 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*58 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*59 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*60 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*61 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*62 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*63 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*64 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*65 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*66 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*67 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*68 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*69 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*70 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*71 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*72 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*73 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*74 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*75 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*76 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*77 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*78 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*79 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*80 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*81 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*82 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*83 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*84 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*85 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*86 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*87 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*88 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*89 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*90 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*91 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*92 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*93 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*94 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*95 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*96 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*97 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*98 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*99 */  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*100*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*101*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*102*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*103*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*104*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*105*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*106*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*107*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*108*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*109*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*110*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*111*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*112*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*113*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*114*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*115*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*116*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*117*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*118*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*119*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*120*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*121*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*122*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*123*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*124*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*125*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*126*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*127*/  VTRECV_ACTION_IGNORE             | (0                                 << 4),
    /*128*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*129*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*130*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*131*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*132*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*133*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*134*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*135*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*136*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*137*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*138*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*139*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*140*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*141*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*142*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*143*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*144*/  0                                 | (VTRECV_STATE_DCS_ENTRY           << 4),
    /*145*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*146*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*147*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*148*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*149*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*150*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*151*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*152*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*153*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*154*/  VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4),
    /*155*/  0                                 | (VTRECV_STATE_CSI_ENTRY           << 4),
    /*156*/  0                                 | (VTRECV_STATE_GROUND              << 4),
    /*157*/  0                                 | (VTRECV_STATE_OSC_STRING          << 4),
    /*158*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
    /*159*/  0                                 | (VTRECV_STATE_SOS_PM_APC_STRING   << 4),
  },
};
#else
typedef struct {
    int state;
    unsigned char code_start;
    unsigned char code_end;
    state_change_t state_change;
} state_table_t;

static const state_table_t table[] = {
  /*
   */
  {  VTRECV_STATE_CSI_ENTRY,   0,  23, VTRECV_ACTION_EXECUTE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  24,  24, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  25,  25, VTRECV_ACTION_EXECUTE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  26,  26, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  27,  27, 0                            | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  28,  31, VTRECV_ACTION_EXECUTE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  32,  47, VTRECV_ACTION_COLLECT        | (VTRECV_STATE_CSI_INTERMEDIATE    << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  48,  57, VTRECV_ACTION_PARAM          | (VTRECV_STATE_CSI_PARAM           << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  58,  58, 0                            | (VTRECV_STATE_CSI_IGNORE          << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  59,  59, VTRECV_ACTION_PARAM          | (VTRECV_STATE_CSI_PARAM           << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  60,  63, VTRECV_ACTION_COLLECT        | (VTRECV_STATE_CSI_PARAM           << 4) },
  {  VTRECV_STATE_CSI_ENTRY,  64, 126, VTRECV_ACTION_CSI_DISPATCH   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 127, 127, VTRECV_ACTION_IGNORE         | (0                                << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 128, 143, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 144, 144, 0                            | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 145, 151, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 152, 152, 0                            | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 153, 154, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 155, 155, 0                            | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 156, 156, 0                            | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 157, 157, 0                            | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_CSI_ENTRY, 158, 159, 0                            | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_CSI_IGNORE,   0,  23, VTRECV_ACTION_EXECUTE       | (0                                << 4) },
  {  VTRECV_STATE_CSI_IGNORE,  24,  24, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_IGNORE,  25,  25, VTRECV_ACTION_EXECUTE       | (0                                << 4) },
  {  VTRECV_STATE_CSI_IGNORE,  26,  26, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_IGNORE,  27,  27, 0                           | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_CSI_IGNORE,  28,  31, VTRECV_ACTION_EXECUTE       | (0                                << 4) },
  {  VTRECV_STATE_CSI_IGNORE,  32,  63, VTRECV_ACTION_IGNORE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_IGNORE,  64, 126, 0                           | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 127, 127, VTRECV_ACTION_IGNORE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 128, 143, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 144, 144, 0                           | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 145, 151, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 152, 152, 0                           | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 153, 154, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 155, 155, 0                           | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 156, 156, 0                           | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 157, 157, 0                           | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_CSI_IGNORE, 158, 159, 0                           | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_CSI_INTERMEDIATE,   0,  23, VTRECV_ACTION_EXECUTE         | (0                                << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  24,  24, VTRECV_ACTION_EXECUTE         | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  25,  25, VTRECV_ACTION_EXECUTE         | (0                                << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  26,  26, VTRECV_ACTION_EXECUTE         | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  27,  27, 0                             | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  28,  31, VTRECV_ACTION_EXECUTE         | (0                                << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  32,  47, VTRECV_ACTION_COLLECT         | (0                                << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  48,  63, 0                             | (VTRECV_STATE_CSI_IGNORE          << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE,  64, 126, VTRECV_ACTION_CSI_DISPATCH    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 127, 127, VTRECV_ACTION_IGNORE          | (0                                << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 128, 143, VTRECV_ACTION_EXECUTE         | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 144, 144, 0                             | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 145, 151, VTRECV_ACTION_EXECUTE         | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 152, 152, 0                             | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 153, 154, VTRECV_ACTION_EXECUTE         | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 155, 155, 0                             | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 156, 156, 0                             | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 157, 157, 0                             | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_CSI_INTERMEDIATE, 158, 159, 0                             | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_CSI_PARAM,   0,  23, VTRECV_ACTION_EXECUTE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_PARAM,  24,  24, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_PARAM,  25,  25, VTRECV_ACTION_EXECUTE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_PARAM,  26,  26, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_PARAM,  27,  27, 0                            | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_CSI_PARAM,  28,  31, VTRECV_ACTION_EXECUTE        | (0                                << 4) },
  {  VTRECV_STATE_CSI_PARAM,  32,  47, VTRECV_ACTION_COLLECT        | (VTRECV_STATE_CSI_INTERMEDIATE    << 4) },
  {  VTRECV_STATE_CSI_PARAM,  48,  57, VTRECV_ACTION_PARAM          | (0                                << 4) },
  {  VTRECV_STATE_CSI_PARAM,  58,  58, 0                            | (VTRECV_STATE_CSI_IGNORE          << 4) },
  {  VTRECV_STATE_CSI_PARAM,  59,  59, VTRECV_ACTION_PARAM          | (0                                << 4) },
  {  VTRECV_STATE_CSI_PARAM,  60,  63, 0                            | (VTRECV_STATE_CSI_IGNORE          << 4) },
  {  VTRECV_STATE_CSI_PARAM,  64, 126, VTRECV_ACTION_CSI_DISPATCH   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_PARAM, 127, 127, VTRECV_ACTION_IGNORE         | (0                                << 4) },
  {  VTRECV_STATE_CSI_PARAM, 128, 143, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_PARAM, 144, 144, 0                            | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_PARAM, 145, 151, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_PARAM, 152, 152, 0                            | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_CSI_PARAM, 153, 154, VTRECV_ACTION_EXECUTE        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_PARAM, 155, 155, 0                            | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_CSI_PARAM, 156, 156, 0                            | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_CSI_PARAM, 157, 157, 0                            | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_CSI_PARAM, 158, 159, 0                            | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_DCS_ENTRY,   0,  23, VTRECV_ACTION_IGNORE     | (0                                << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  24,  24, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  25,  25, VTRECV_ACTION_IGNORE     | (0                                << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  26,  26, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  27,  27, 0                        | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  28,  31, VTRECV_ACTION_IGNORE     | (0                                << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  32,  47, VTRECV_ACTION_COLLECT    | (VTRECV_STATE_DCS_INTERMEDIATE    << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  48,  57, VTRECV_ACTION_PARAM      | (VTRECV_STATE_DCS_PARAM           << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  58,  58, 0                        | (VTRECV_STATE_DCS_IGNORE          << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  59,  59, VTRECV_ACTION_PARAM      | (VTRECV_STATE_DCS_PARAM           << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  60,  63, VTRECV_ACTION_COLLECT    | (VTRECV_STATE_DCS_PARAM           << 4) },
  {  VTRECV_STATE_DCS_ENTRY,  64, 126, 0                        | (VTRECV_STATE_DCS_PASSTHROUGH     << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 127, 127, VTRECV_ACTION_IGNORE     | (0                                << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 128, 143, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 144, 144, 0                        | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 145, 151, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 152, 152, 0                        | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 153, 154, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 155, 155, 0                        | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 156, 156, 0                        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 157, 157, 0                        | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_DCS_ENTRY, 158, 159, 0                        | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_DCS_IGNORE,   0,  23, VTRECV_ACTION_IGNORE    | (0                                << 4) },
  {  VTRECV_STATE_DCS_IGNORE,  24,  24, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_IGNORE,  25,  25, VTRECV_ACTION_IGNORE    | (0                                << 4) },
  {  VTRECV_STATE_DCS_IGNORE,  26,  26, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_IGNORE,  27,  27, 0                       | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_DCS_IGNORE,  28, 127, VTRECV_ACTION_IGNORE    | (0                                << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 128, 143, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 144, 144, 0                       | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 145, 151, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 152, 152, 0                       | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 153, 154, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 155, 155, 0                       | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 156, 156, 0                       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 157, 157, 0                       | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_DCS_IGNORE, 158, 159, 0                       | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_DCS_INTERMEDIATE,   0,  23, VTRECV_ACTION_IGNORE      | (0                                << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  24,  24, VTRECV_ACTION_EXECUTE     | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  25,  25, VTRECV_ACTION_IGNORE      | (0                                << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  26,  26, VTRECV_ACTION_EXECUTE     | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  27,  27, 0                         | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  28,  31, VTRECV_ACTION_IGNORE      | (0                                << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  32,  47, VTRECV_ACTION_COLLECT     | (0                                << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  48,  63, 0                         | (VTRECV_STATE_DCS_IGNORE          << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE,  64, 126, 0                         | (VTRECV_STATE_DCS_PASSTHROUGH     << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 127, 127, VTRECV_ACTION_IGNORE      | (0                                << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 128, 143, VTRECV_ACTION_EXECUTE     | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 144, 144, 0                         | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 145, 151, VTRECV_ACTION_EXECUTE     | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 152, 152, 0                         | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 153, 154, VTRECV_ACTION_EXECUTE     | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 155, 155, 0                         | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 156, 156, 0                         | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 157, 157, 0                         | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_DCS_INTERMEDIATE, 158, 159, 0                         | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_DCS_PARAM,   0,  23, VTRECV_ACTION_IGNORE             | (0                                << 4) },
  {  VTRECV_STATE_DCS_PARAM,  24,  24, VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PARAM,  25,  25, VTRECV_ACTION_IGNORE             | (0                                << 4) },
  {  VTRECV_STATE_DCS_PARAM,  26,  26, VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PARAM,  27,  27, 0                                | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_DCS_PARAM,  28,  31, VTRECV_ACTION_IGNORE             | (0                                << 4) },
  {  VTRECV_STATE_DCS_PARAM,  32,  47, VTRECV_ACTION_COLLECT            | (VTRECV_STATE_DCS_INTERMEDIATE    << 4) },
  {  VTRECV_STATE_DCS_PARAM,  48,  57, VTRECV_ACTION_PARAM              | (0                                << 4) },
  {  VTRECV_STATE_DCS_PARAM,  58,  58, 0                                | (VTRECV_STATE_DCS_IGNORE          << 4) },
  {  VTRECV_STATE_DCS_PARAM,  59,  59, VTRECV_ACTION_PARAM              | (0                                << 4) },
  {  VTRECV_STATE_DCS_PARAM,  60,  63, 0                                | (VTRECV_STATE_DCS_IGNORE          << 4) },
  {  VTRECV_STATE_DCS_PARAM,  64, 126, 0                                | (VTRECV_STATE_DCS_PASSTHROUGH     << 4) },
  {  VTRECV_STATE_DCS_PARAM, 127, 127, VTRECV_ACTION_IGNORE             | (0                                << 4) },
  {  VTRECV_STATE_DCS_PARAM, 128, 143, VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PARAM, 144, 144, 0                                | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_PARAM, 145, 151, VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PARAM, 152, 152, 0                                | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_DCS_PARAM, 153, 154, VTRECV_ACTION_EXECUTE            | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PARAM, 155, 155, 0                                | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_PARAM, 156, 156, 0                                | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PARAM, 157, 157, 0                                | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_DCS_PARAM, 158, 159, 0                                | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_DCS_PASSTHROUGH,   0,  23, VTRECV_ACTION_PUT          | (0                                << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH,  24,  24, VTRECV_ACTION_EXECUTE      | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH,  25,  25, VTRECV_ACTION_PUT          | (0                                << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH,  26,  26, VTRECV_ACTION_EXECUTE      | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH,  27,  27, 0                          | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH,  28, 126, VTRECV_ACTION_PUT          | (0                                << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 127, 127, VTRECV_ACTION_IGNORE       | (0                                << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 128, 143, VTRECV_ACTION_EXECUTE      | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 144, 144, 0                          | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 145, 151, VTRECV_ACTION_EXECUTE      | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 152, 152, 0                          | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 153, 154, VTRECV_ACTION_EXECUTE      | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 155, 155, 0                          | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 156, 156, 0                          | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 157, 157, 0                          | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_DCS_PASSTHROUGH, 158, 159, 0                          | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_ESCAPE,   0,  23, VTRECV_ACTION_EXECUTE       | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE,  24,  24, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE,  25,  25, VTRECV_ACTION_EXECUTE       | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE,  26,  26, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE,  27,  27, 0                           | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_ESCAPE,  28,  31, VTRECV_ACTION_EXECUTE       | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE,  32,  47, VTRECV_ACTION_COLLECT       | (VTRECV_STATE_ESCAPE_INTERMEDIATE << 4) },
  {  VTRECV_STATE_ESCAPE,  48,  79, VTRECV_ACTION_ESC_DISPATCH  | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE,  80,  80, 0                           | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_ESCAPE,  81,  87, VTRECV_ACTION_ESC_DISPATCH  | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE,  88,  88, 0                           | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_ESCAPE,  89,  90, VTRECV_ACTION_ESC_DISPATCH  | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE,  91,  91, 0                           | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_ESCAPE,  92,  92, VTRECV_ACTION_ESC_DISPATCH  | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE,  93,  93, 0                           | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_ESCAPE,  94,  95, 0                           | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_ESCAPE,  96, 126, VTRECV_ACTION_ESC_DISPATCH  | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE, 127, 127, VTRECV_ACTION_IGNORE        | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE, 128, 143, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE, 144, 144, 0                           | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_ESCAPE, 145, 151, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE, 152, 152, 0                           | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_ESCAPE, 153, 154, VTRECV_ACTION_EXECUTE       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE, 155, 155, 0                           | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_ESCAPE, 156, 156, 0                           | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE, 157, 157, 0                           | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_ESCAPE, 158, 159, 0                           | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,   0,  23, VTRECV_ACTION_EXECUTE          | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,  24,  24, VTRECV_ACTION_EXECUTE          | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,  25,  25, VTRECV_ACTION_EXECUTE          | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,  26,  26, VTRECV_ACTION_EXECUTE          | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,  27,  27, 0                              | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,  28,  31, VTRECV_ACTION_EXECUTE          | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,  32,  47, VTRECV_ACTION_COLLECT          | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE,  48, 126, VTRECV_ACTION_ESC_DISPATCH     | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 127, 127, VTRECV_ACTION_IGNORE           | (0                                << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 128, 143, VTRECV_ACTION_EXECUTE          | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 144, 144, 0                              | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 145, 151, VTRECV_ACTION_EXECUTE          | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 152, 152, 0                              | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 153, 154, VTRECV_ACTION_EXECUTE          | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 155, 155, 0                              | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 156, 156, 0                              | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 157, 157, 0                              | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_ESCAPE_INTERMEDIATE, 158, 159, 0                              | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_GROUND,   0,  23, VTRECV_ACTION_EXECUTE   | (0                                << 4) },
  {  VTRECV_STATE_GROUND,  24,  24, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_GROUND,  25,  25, VTRECV_ACTION_EXECUTE   | (0                                << 4) },
  {  VTRECV_STATE_GROUND,  26,  26, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_GROUND,  27,  27, 0                       | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_GROUND,  28,  31, VTRECV_ACTION_EXECUTE   | (0                                << 4) },
  {  VTRECV_STATE_GROUND,  32, 127, VTRECV_ACTION_PRINT     | (0                                << 4) },
  {  VTRECV_STATE_GROUND, 128, 143, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_GROUND, 144, 144, 0                       | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_GROUND, 145, 151, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_GROUND, 152, 152, 0                       | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_GROUND, 153, 154, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_GROUND, 155, 155, 0                       | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_GROUND, 156, 156, 0                       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_GROUND, 157, 157, 0                       | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_GROUND, 158, 159, 0                       | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_OSC_STRING,   0,  23, VTRECV_ACTION_IGNORE    | (0                                << 4) },
  {  VTRECV_STATE_OSC_STRING,  24,  24, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_OSC_STRING,  25,  25, VTRECV_ACTION_IGNORE    | (0                                << 4) },
  {  VTRECV_STATE_OSC_STRING,  26,  26, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_OSC_STRING,  27,  27, 0                       | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_OSC_STRING,  28,  31, VTRECV_ACTION_IGNORE    | (0                                << 4) },
  {  VTRECV_STATE_OSC_STRING,  32, 127, VTRECV_ACTION_OSC_PUT   | (0                                << 4) },
  {  VTRECV_STATE_OSC_STRING, 128, 143, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_OSC_STRING, 144, 144, 0                       | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_OSC_STRING, 145, 151, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_OSC_STRING, 152, 152, 0                       | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_OSC_STRING, 153, 154, VTRECV_ACTION_EXECUTE   | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_OSC_STRING, 155, 155, 0                       | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_OSC_STRING, 156, 156, 0                       | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_OSC_STRING, 157, 157, 0                       | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_OSC_STRING, 158, 159, 0                       | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  /*
   */
  {  VTRECV_STATE_SOS_PM_APC_STRING,   0,  23, VTRECV_ACTION_IGNORE     | (0                                << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING,  24,  24, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING,  25,  25, VTRECV_ACTION_IGNORE     | (0                                << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING,  26,  26, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING,  27,  27, 0                        | (VTRECV_STATE_ESCAPE              << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING,  28, 127, VTRECV_ACTION_IGNORE     | (0                                << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 128, 143, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 144, 144, 0                        | (VTRECV_STATE_DCS_ENTRY           << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 145, 151, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 152, 152, 0                        | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 153, 154, VTRECV_ACTION_EXECUTE    | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 155, 155, 0                        | (VTRECV_STATE_CSI_ENTRY           << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 156, 156, 0                        | (VTRECV_STATE_GROUND              << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 157, 157, 0                        | (VTRECV_STATE_OSC_STRING          << 4) },
  {  VTRECV_STATE_SOS_PM_APC_STRING, 158, 159, 0                        | (VTRECV_STATE_SOS_PM_APC_STRING   << 4) },
};
#endif

static const vtrecv_action_t ENTRY_ACTIONS[] = {
   VTRECV_ACTION_CLEAR, /* CSI_ENTRY */
   0  /* none for CSI_IGNORE */,
   0  /* none for CSI_INTERMEDIATE */,
   0  /* none for CSI_PARAM */,
   VTRECV_ACTION_CLEAR, /* DCS_ENTRY */
   0  /* none for DCS_IGNORE */,
   0  /* none for DCS_INTERMEDIATE */,
   0  /* none for DCS_PARAM */,
   VTRECV_ACTION_HOOK, /* DCS_PASSTHROUGH */
   VTRECV_ACTION_CLEAR, /* ESCAPE */
   0  /* none for ESCAPE_INTERMEDIATE */,
   0  /* none for GROUND */,
   VTRECV_ACTION_OSC_START, /* OSC_STRING */
   0  /* none for SOS_PM_APC_STRING */,
};

static const vtrecv_action_t EXIT_ACTIONS[] = {
   0  /* none for CSI_ENTRY */,
   0  /* none for CSI_IGNORE */,
   0  /* none for CSI_INTERMEDIATE */,
   0  /* none for CSI_PARAM */,
   0  /* none for DCS_ENTRY */,
   0  /* none for DCS_IGNORE */,
   0  /* none for DCS_INTERMEDIATE */,
   0  /* none for DCS_PARAM */,
   VTRECV_ACTION_UNHOOK, /* DCS_PASSTHROUGH */
   0  /* none for ESCAPE */,
   0  /* none for ESCAPE_INTERMEDIATE */,
   0  /* none for GROUND */,
   VTRECV_ACTION_OSC_END, /* OSC_STRING */
   0  /* none for SOS_PM_APC_STRING */,
};

state_change_t GET_STATE_TABLE(const int state, const int ch)
{
#if (USE_ORIGINAL_LUT==1)
    /*
     * テーブル参照による実現。
     * 固定時間で動作するが、コードサイズは比較的大きい。
     */
    return STATE_TABLE[state - 1][ch];
#else
    /*
     * プログラムによる線形探索バージョン。
     * テーブルの後方にあるデータになるほど動作は遅い。
     * コードサイズはテーブル参照よりも小さい。
     */
    const int N = sizeof(table) / sizeof(table[0]);
    const state_table_t *tp = &table[0];
    int i;
    for (i = 0; i < N; i++) {
        if (tp->state == state) {
            if ((tp->code_start <= ch) && (ch <= tp->code_end)) {
                return tp->state_change;
            }
        }
        tp++;
    }
    return 0;
#endif
}

vtrecv_action_t GET_ENTRY_ACTIONS(const int state)
{
    return ENTRY_ACTIONS[state];
}

vtrecv_action_t GET_EXIT_ACTIONS(const int state)
{
    return EXIT_ACTIONS[state];
}

void vtrecv_init(vtrecv_t *parser, vtrecv_callback_t cb)
{
    parser->state                  = VTRECV_STATE_GROUND;
    parser->num_intermediate_chars = 0;
    parser->num_params             = 0;
    parser->ignore_flagged         = 0;
    parser->cb                     = cb;
}

static void do_action(vtrecv_t *parser, vtrecv_action_t action, char ch)
{
    /* Some actions we handle internally (like parsing parameters), others
     * we hand to our client for processing */

    switch (action) {
        case VTRECV_ACTION_PRINT:
        case VTRECV_ACTION_EXECUTE:
        case VTRECV_ACTION_HOOK:
        case VTRECV_ACTION_PUT:
        case VTRECV_ACTION_OSC_START:
        case VTRECV_ACTION_OSC_PUT:
        case VTRECV_ACTION_OSC_END:
        case VTRECV_ACTION_UNHOOK:
        case VTRECV_ACTION_CSI_DISPATCH:
        case VTRECV_ACTION_ESC_DISPATCH:
            parser->cb(parser, action, ch);
            break;

        case VTRECV_ACTION_IGNORE:
            /* do nothing */
            break;

        case VTRECV_ACTION_COLLECT:
        {
            /* Append the character to the intermediate params */
            if (parser->num_intermediate_chars + 1 > MAX_INTERMEDIATE_CHARS) {
                parser->ignore_flagged = 1;
            } else {
                parser->intermediate_chars[parser->num_intermediate_chars++] = ch;
            }

            break;
        }

        case VTRECV_ACTION_PARAM:
        {
            /* process the param character */
            if (ch == ';') {
                parser->num_params += 1;
                parser->params[parser->num_params-1] = 0;
            } else {
                /* the character is a digit */
                int current_param;

                if (parser->num_params == 0) {
                    parser->num_params = 1;
                    parser->params[0]  = 0;
                }

                current_param = parser->num_params - 1;
                parser->params[current_param] *= 10;
                parser->params[current_param] += (ch - '0');
            }

            break;
        }

        case VTRECV_ACTION_CLEAR:
            parser->num_intermediate_chars = 0;
            parser->num_params             = 0;
            parser->ignore_flagged         = 0;
            break;

        default:
            parser->cb(parser, VTRECV_ACTION_ERROR, 0);
            break;
    }
}

static void do_state_change(vtrecv_t *parser, state_change_t change, char ch)
{
    /* A state change is an action and/or a new state to transition to. */

    vtrecv_state_t new_state = STATE(change);
    vtrecv_action_t action = ACTION(change);

    if (new_state) {
        /*
         * Perform up to three actions:
         *   1. the exit action of the old state
         *   2. the action associated with the transition
         *   3. the entry action of the new state
         */

        vtrecv_action_t exit_action = GET_EXIT_ACTIONS(parser->state - 1);
        vtrecv_action_t entry_action = GET_ENTRY_ACTIONS(new_state - 1);

        if (exit_action) {
            do_action(parser, exit_action, 0);
        }

        if (action) {
            do_action(parser, action, ch);
        }

        if (entry_action) {
            do_action(parser, entry_action, 0);
        }

        parser->state = new_state;
    } else {
        do_action(parser, action, ch);
    }
}

void vtrecv_execute(vtrecv_t *parser, unsigned char *data, int len)
{
    int i;
    for (i = 0; i < len; i++) {
        unsigned char ch = data[i];
        state_change_t change = GET_STATE_TABLE(parser->state, ch);
        do_state_change(parser, change, ch);
    }
}

