/*
 * Copyright (c) 2013 - 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"

#include "pin_mux.h"
#include "clock_config.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/
int value;

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
/*!
 * @brief Main function
 */
int main(void)
{
    char ch;

    /* Init board hardware. */
    /* attach main clock divide to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(BOARD_DEBUG_UART_CLK_ATTACH);

    BOARD_InitPins();
    BOARD_BootClockPLL150M();
    BOARD_InitDebugConsole();

    PRINTF("hello world.\r\n");
    
    PRINTF("the value after configure the PRINCE enable by blhost .\r\n");
    value = *(int *)0xF000;//read the value decrypted by PRINCE located at 0xF000.
    PRINTF("the value of address 0xF000 is :%x\r\n",value);
    PRINCE->SR_ENABLE0 = 0x7F;//disable prince to the rang from 0xE000 to 0xFFFF
    PRINTF("the value after PRINCE disable in the app code.\r\n");
    value = *(int *)0xF000;//read the true flash value located at 0xF000.
    PRINTF("the value of address 0xF000 is :%x\r\n",value);
    
    while (1)
    {
        ch = GETCHAR();
        PUTCHAR(ch);
    }
}
