/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */



/*=========================================================================

Public type definitions

===========================================================================*/
#define TRUE                        1
#define FALSE                       0

/* FSCI protocol attributes */
#define LENGTH_FIELD_SIZE           2  /* size in bytes of FSCI length field */
#define CRC_FIELD_SIZE              1  /* size in bytes of FSCI CRC field */
#define VIF                         0  /* do not use FSCI virtual interfaces */
#define INVALID_HANDLE				NULL
/* HR Report Intervals*/
#define HRS_BATTERY_LEVEL_REPORT_INTERVAL 10    /* battery level report interval in seconds */
#define HRS_HEART_RATE_REPORT_INTERVAL    1		/* heart rate report interval in seconds  */
/* BLE operation groups and codes*/
#define FSCI_REQ_OG						0xA3 	/* FSCI command Request */
#define FSCI_RSP_IND_CNF_OG				0xA4 	/* FSCI command Response/Indication/Confirm */
#define L2CAP_OG						0x41 	/* L2CAP command Request */
#define GATT_OG							0x44 	/* GATT command Request */
#define GATTDB_OG						0x45 	/* GATTDB command Request */
#define GAP_OG							0x47 	/* GAP command Request */

#define CPU_RESET_OC							0x08
#define CONFIRMATION_OC							0x80 	/* Generic Confirmation Event */
#define GAP_INIT_COMPLETE_OC					0X89 	/* Generic event initialization complete indication */
#define ADD_PSD_REQ_OC							0x0A 	/* Add Primary Service Declaration Request */
#define ADD_PSD_IND_OC							0x86	/* Add Primary Service Declaration Indication */
#define ADD_CDV_REQ_OC							0x0D	/* Add Characteristic Declaration and Value Request */
#define ADD_CDV_IND_OC							0x89	/* Add Characteristic Declaration and Value Indication */
#define ADD_CCCD_REQ_OC							0x0F	/* Add Client Characteristic Configuration Descriptor Request */
#define ADD_CCCD_IND_OC							0x8B	/* Add Client Characteristic Configuration Descriptor Indication */
#define ADD_CD_REQ_OC 							0x0E	/* Add Characteristic Descriptor Request */
#define ADD_CD_IND_OC 							0x8A	/* Add Characteristic Descriptor Indication */
#define READ_PUBLIC_DEVICE_ADDR_REQ_OC			0x25 	/* Reads the device's public address from the controler (Request) */
#define READ_PUBLIC_DEVICE_ADDR_IND_OC			0x94 	/* Reads the device's public address from the controler (Indication) */
#define REGISTER_DEVICE_SECURITY_REQ_OC	 		0x02 	/* Registers the device security requirements */
#define SET_LOCAL_PASSKEY_OC					0x19 	/* Set the SMP passkey for this device */
#define SET_ADV_DATA							0x04 	/* Sets the advertising and scan response data */
#define SEND_NOTIFICATION_REQUEST				0x19    /* Sends a notification to a peer GATT Client.*/
#define ADV_DATA_SETUP_COMPLETE_OC				0x8D 	/* GAP generic event advertising data setup complete */
#define SERVER_REGISTER_HANDLE_WRT_NOT_OC 		0x17	/* Registers the attribute handles that will be notified through the GATT Server callback when a GATT Client attempts to modify the attribute's values */
#define SERVER_REGISTER_CALLBACK				0x16 	/* Installs an application callback for the GATT Server module */
#define FIND_CHAR_VALUE_HANDLE_SERVICE_REQ_OC	0x05 	/* Finds the handle of a Characteristic Value with a given UUID inside a service */
#define FindServiceHandleIndication_FSCI_ID		0x82
#define GATTDB_FIND_SERVICE_HANDLE				0x04 	/* Finds the handle of a Service Declaration with a given UUID inside the database */
#define FIND_CHAR_VALUE_HANDLE_SERVICE_IND_OC	0x83
#define WRITE_ATT_OC							0x02 	/* Writes an attribute from the application level */
#define FIND_CCCD_HANDLE_FOR_CHAR_HANDLE_REQ_OC	0x06 	/* Finds the handle of the Cccd of a given characteristic's value handle (Request) */
#define FIND_CCCD_HANDLE_FOR_CHAR_HANDLE_IND_OC	0x84 	/* Finds the handle of the Cccd of a given characteristic's value handle (Indication) */
#define CHECK_NOTIFICATION_STATUS_REQ_OC		0x09 	/* Retreives the notification status for a given client and a given Cccd handle */
#define CHECK_NOTIFICATION_STATUS_IND_OC		0x81 	/* Returns the notification status for a given client and a given Cccd handle */
#define SET_ADV_PARAM_OC						0x03 	/* Sets the advertising parameters */
#define ADV_PARAM_SETUP_COMPLETE_OC				0x8C	/* Advertising parameters setup completed */
#define ADV_SETUP_FAILED_OC						0x8B	/* GAP Advertising Setup Failed */
#define START_ADV_OC							0x05 	/* Commands the controller to start advertising */
#define ADV_STATE_CHANGED_OC					0x98 	/*  */
#define ADV_CMD_FAILED_OC						0x99	/* Start advertising failed */
#define Connection_Event_Connected_Indication   0x9D    /* A connection has been established */
#define Connection_Event_Pairing_Request        0x9E    /* A pairing request has been received from the peer master */
#define Connection_Event_Disconnected			0xAA    /* A connection is terminated */
#define GATT_SERVER_ERROR						0x96    /* Identify active conection failed*/	

/* UUID Type */
#define Uuid16Bits						0x01
#define Uuid128Bits						0x02
#define Uuid32Bits						0x03

/* Security Mode Level */
#define gMode1Level1_c 					0x10 	/* Mode 1 Level 1 - No Security */
#define gMode1Level2_c 					0x11 	/* Mode 1 Level 2 - Encryption without authentication */
#define gMode1Level3_c 					0x12 	/* Mode 1 Level 3 - Encryption with authentication */
#define gMode1Level4_c 					0x13 	/* Mode 1 Level 4 - Encryption with LE Secure Connections pairing (BLE 4.2 only) */
#define gMode2Level1_c 					0x21 	/* Mode 2 Level 1 - Data Signing without authentication */
#define gMode2Level2_c 					0x22 	/* Mode 2 Level 2 - Data Signing with authentication */

/* UUID Services & Characteristics */
#define gBleSig_GenericAccessProfile_d 				0x1800		/* GAP Service UUID */
#define gBleSig_GenericAttributeProfile_d			0x1801		/* GATT Service UUID */
#define gBleSig_ImmediateAlertService_d				0x1802 		/* Immediate Alert Service UUID */
#define gBleSig_LinkLossService_d					0x1803		/* Link Loss Service UUID */
#define gBleSig_TxPowerService_d					0x1804		/* Tx Power Service UUID */
#define gBleSig_GlucoseService_d					0x1808		/* Glucose Service UUID */
#define gBleSig_HealthThermometerService_d			0x1809		/* Health Thermometer Service UUID */
#define gBleSig_DeviceInformationService_d			0x180A		/* Device Information Service UUID */
#define gBleSig_HeartRateService_d					0x180D		/* Heart Rate Service UUID */
#define gBleSig_BatteryService_d					0x180F		/* Battery Service UUID */
#define gBleSig_BloodPressureService_d				0x1810 		/* Blood Pressure Service UUID */
#define gBleSig_AlertNotificationService_d			0x1811 		/* Alert Notification Service UUID */
#define gBleSig_HidService_d						0x1812		/* HID Service UUID */
#define gBleSig_RunningSpeedAndCadenceService_d		0x1814		/* Running Speed And Cadence Service UUID */
#define gBleSig_CyclingSpeedAndCadenceService_d		0x1816		/* Cycling Speed And Cadence Service UUID */
#define gBleSig_CyclingPowerService_d				0x1818		/* Cycling Power Service UUID */
#define gBleSig_IpsService_d 						0x1820 		/* Internet Protocol Support Service UUID */
#define gBleSig_PulseOximeterService_d 				0x1822		/* Pulse Oximeter Service UUID */

#define gBleSig_PrimaryService_d 					0x2800		/* Primary Service declaration UUID */
#define gBleSig_SecondaryService_d					0x2801		/* Secondary Service declaration UUID */
#define gBleSig_Include_d							0x2802		/* Include declaration UUID */
#define gBleSig_Characteristic_d					0x2803		/* Characteristic declaration UUID */
#define gBleSig_CCCD_d								0x2902		/* Client Characteristic Configuration Descriptor declaration UUID */
#define gBleSig_SCCD_d 								0x2903		/* Server Characteristic Configuration Descriptor declaration UUID */
#define gBleSig_CharPresFormatDescriptor_d 			0x2904		/* Characteristic Presentation Format declaration UUID */
#define gBleSig_ValidRangeDescriptor_d				0x2906		/* Valid Range Descriptor declaration UUID */

#define gBleSig_GapDeviceName_d						0x2A00		/* GAP Device Name Characteristic UUID */
#define gBleSig_GapAppearance_d 					0x2A01		/* GAP Appearance Characteristic UUID */
#define gBleSig_GapPpcp_d							0x2A04		/* GAP Peripheral Preferred Connection Parameters Characteristic UUID */
#define gBleSig_GattServiceChanged_d 				0x2A05		/* GATT Service Changed Characteristic UUID */
#define gBleSig_AlertLevel_d 						0x2A06 		/* Alert Level Characteristic UUID */
#define gBleSig_TxPower_d 							0x2A07 		/* TX Power Characteristic UUID */
#define gBleSig_GlucoseMeasurement_d 				0x2A18 		/* Glucose Measurement Characteristic UUID */
#define gBleSig_BatteryLevel_d 						0x2A19 		/* Battery Level Characteristic UUID */
#define gBleSig_TemperatureMeasurement_d 			0x2A1C 		/* Temperature Measurement Characteristic UUID */
#define gBleSig_TemperatureType_d 					0x2A1D 		/* Temperature Type Characteristic UUID */
#define gBleSig_IntermediateTemperature_d 			0x2A1E 		/* Intermediate Temperature Characteristic UUID */
#define gBleSig_MeasurementInterval_d 				0x2A21 		/* Measurement Interval Characteristic UUID */
#define gBleSig_SystemId_d 							0x2A23 		/* System ID Characteristic UUID */
#define gBleSig_ModelNumberString_d 				0x2A24 		/* Model Number String Characteristic UUID */
#define gBleSig_SerialNumberString_d		 		0x2A25 		/* Serial Number String Characteristic UUID */
#define gBleSig_FirmwareRevisionString_d 			0x2A26 		/* Firmware Revision String Characteristic UUID */
#define gBleSig_HardwareRevisionString_d 			0x2A27 		/* Hardware Revision String Characteristic UUID */
#define gBleSig_SoftwareRevisionString_d 			0x2A28 		/* Software Revision String Characteristic UUID */
#define gBleSig_ManufacturerNameString_d 			0x2A29 		/* Manufacturer Name String Characteristic UUID */
#define gBleSig_IeeeRcdl_d 							0x2A2A 		/* IEEE 11073-20601 Regulatory Certification Data List Characteristic UUID */
#define gBleSig_BootKeyboardInputReport_d 			0x2A22 		/* Boot Keyboard Input Report UUID*/
#define gBleSig_BootKeyboardOutputReport_d 			0x2A32 		/* Boot Keyboard output Report UUID*/
#define gBleSig_BootMouseInputReport_d 				0x2A33		/* Boot Mouse Input Report UUID */
#define gBleSig_GlucoseMeasurementContext_d 		0x2A34		/* Glucose Measurement Context Characteristic UUID */
#define gBleSig_BpMeasurement_d 					0x2A35		/* Blood Pressure Measurement UUID */
#define gBleSig_IntermediateCuffPressure_d 			0x2A36		/* Intermediate Cuff Pressure UUID */
#define gBleSig_HrMeasurement_d 					0x2A37		/* Heart Rate Measurement UUID*/
#define gBleSig_BodySensorLocation_d 				0x2A38		/* Body Sensor Location UUID */
#define gBleSig_HrControlPoint_d 					0x2A39		/* Heart Rate Control Point UUID */
#define gBleSig_AlertNotifControlPoint_d 			0x2A44		/* Alert Notif Control Point UUID */
#define gBleSig_UnreadAlertStatus_d 				0x2A45		/* Unread Alert Status UUID */
#define gBleSig_NewAlert_d 							0x2A46		/* New Alert UUID*/
#define gBleSig_SupportedNewAlertCategory_d 		0x2A47		/* Supported New Alert Category UUID */
#define gBleSig_SupportedUnreadAlertCategory_d 		0x2A48		/* Supported Unread Alert Category UUID */
#define gBleSig_BloodPressureFeature_d 				0x2A49		/* Blood Pressure Feature UUID */
#define gBleSig_HidInformation_d 					0x2A4A		/* HID Information UUID */
#define gBleSig_HidCtrlPoint_d 						0x2A4C		/* HID Control Point UUID */
#define gBleSig_Report_d 							0x2A4D		/* Report UUID */
#define gBleSig_ProtocolMode_d 						0x2A4E		/* Protocol Mode UUID */
#define gBleSig_ScanIntervalWindow_d 				0x2A4F		/* Scan Interval Window UUID */
#define gBleSig_PnpId_d 							0x2A50		/* PnP Id UUID */
#define gBleSig_GlucoseFeature_d		 			0x2A51		/* Glucose Feature Characteristic UUID */
#define gBleSig_RaCtrlPoint_d 						0x2A52 		/* Record Access Ctrl Point Characteristic UUID */
#define gBleSig_RscMeasurement_d 					0x2A53 		/* RSC Measurement UUID */
#define gBleSig_RscFeature_d 						0x2A54 		/* RSC Feature UUID */
#define gBleSig_ScControlPoint_d 					0x2A55 		/* SC Control Point UUID */
#define gBleSig_CscMeasurement_d 					0x2A5B 		/* CSC Measurement Characteristic UUID */
#define gBleSig_CscFeature_d 						0x2A5C 		/* CSC Feature Characteristic UUID */
#define gBleSig_SensorLocation_d 					0x2A5D 		/* Sensor Location Characteristic UUID */
#define gBleSig_PlxSCMeasurement_d 					0x2A5E 		/* PLX Spot-Check Measurement Characteristic UUID */
#define gBleSig_PlxContMeasurement_d				0x2A5F 		/* PLX Continuous Measurement Characteristic UUID */
#define gBleSig_PulseOximeterFeature_d 				0x2A60 		/* PLX Feature Characteristic UUID */
#define gBleSig_CpMeasurement_d 					0x2A63 		/* CP Measurement Characteristic UUID */
#define gBleSig_CpVector_d 							0x2A64 		/* CP Measurement Vector UUID */
#define gBleSig_CpFeature_d 						0x2A65 		/* CP Feature CharacteristicUUID */
#define gBleSig_CpControlPoint_d					0x2A66 		/* CP Control Point UUID */
#define gBleSig_Temperature_d 						0x2A6E 		/* Temperature Characteristic UUID */

/* Properties */
#define gNone_c										0x00 		/* No properties selected */
#define gBroadcast_c								0x01 		/* Characteristic can be broadcast */
#define gRead_c										0x02 		/* Characteristic can be read */
#define gWriteWithoutRsp_c							0x04 		/* Characteristic can be written without response */
#define gWrite_c									0x08 		/* Characteristic can be written with response */
#define gNotify_c									0x10 		/* Characteristic can be notified */
#define gIndicate_c									0x20 		/* Characteristic can be indicated */
#define gAuthSignedWrites_c							0x40 		/* Characteristic can be written with signed data */
#define gExtendedProperties_c						0x80 		/* Extended characteristic properties */

/* Permissions */
#define gPermissionNone_c							0x00 		/* No permissions selected */
#define gPermissionFlagReadable_c					0x01 		/* Attribute can be read */
#define gPermissionFlagReadWithEncryption_c			0x02 		/* Attribute may be read only if link is encrypted */
#define gPermissionFlagReadWithAuthentication_c		0x04 		/* Attribute may be read only by authenticated peers */
#define gPermissionFlagReadWithAuthorization_c		0x08 		/* Attribute may be read only by authorized peers */
#define gPermissionFlagWritable_c					0x10 		/* Attribute can be written */
#define gPermissionFlagWriteWithEncryption_c		0x20 		/* Attribute may be written only if link is encrypted */
#define gPermissionFlagWriteWithAuthentication_c	0x40 		/* Attribute may be written only by authenticated peers */
#define gPermissionFlagWriteWithAuthorization_c		0x80 		/* Attribute may be written only by authorized peers */    

/* Heart Rate Service - Heart Rate Format */ 
#define gHrs_8BitHeartRateFormat_c 			0x00
#define gHrs_16BitHeartRateFormat_c 		0x01

/* Heart Rate Service - Sensor Contact detected status */
#define gHrs_SensorContactNotDetected_c 	0x00
#define gHrs_SensorContactDetected_c 		0x02

/* Heart Rate Service - Sensor Contact supported status */
#define gHrs_SensorContactNotSupported_c 	0x00
#define gHrs_SensorContactSupported_c 		0x04

/* Heart Rate Service - Energy expended status */
#define gHrs_EnergyExpendedDisabled_c 		0x00
#define gHrs_EnergyExpendedEnabled_c 		0x08

/* Heart Rate Service - RR Intervals status */
#define gHrs_RrIntervalsDisabled_c 			0x00
#define gHrs_RrIntervalsEnabled_c 			0x10

/* Heart Rate Service - Body Sensor Location */
#define gHrs_BodySensorLocOther_c 			0x00
#define gHrs_BodySensorLocChest_c 			0x01
#define gHrs_BodySensorLocWrist_c 			0x02
#define gHrs_BodySensorLocFinger_c 			0x03
#define gHrs_BodySensorLocHand_c 			0x04
#define gHrs_BodySensorLocEarLobe_c 		0x05
#define gHrs_BodySensorLocFoot_c 			0x06

#define gFastConnMinAdvInterval_c 			0x20  /* 20 ms */
#define gFastConnMaxAdvInterval_c 			0x30  /* 30 ms */

/* Advertising Type */
#define gAdvConnectableUndirected_c 		0x00  /* Answers to both connect and scan requests. */
#define gAdvDirectedHighDutyCycle_c 		0x01  /* Answers only to connect requests; smaller advertising interval for quicker connection. */
#define gAdvScannable_c 					0x02  /* Answers only to scan requests. */
#define gAdvNonConnectable_c 				0x03  /* Does not answer to connect nor scan requests. */
#define gAdvDirectedLowDutyCycle_c 			0x04  /* Answers only to connect requests; larger advertising interval. */

/* Advertising Data Type - Defined by the Bluetooth SIG*/
#define gAdFlags_c 							0x01
#define gAdIncomplete16bitServiceList_c 	0x02
#define gAdComplete16bitServiceList_c 		0x03
#define gAdIncomplete32bitServiceList_c 	0x04
#define gAdComplete32bitServiceList_c 		0x05
#define gAdIncomplete128bitServiceList_c 	0x06
#define gAdComplete128bitServiceList_c 		0x07
#define gAdShortenedLocalName_c 			0x08
#define gAdCompleteLocalName_c 				0x09
#define gAdTxPowerLevel_c 					0x0A
#define gAdClassOfDevice_c 					0x0D
#define gAdSimplePairingHashC192_c 			0x0E
#define gAdSimplePairingRandomizerR192_c 	0x0F
#define gAdSecurityManagerTkValue_c 		0x10
#define gAdSecurityManagerOobFlags_c 		0x11
#define gAdSlaveConnectionIntervalRange_c 	0x12
#define gAdServiceSolicitationList16bit_c 	0x14
#define gAdServiceSolicitationList128bit_c 	0x15
#define gAdServiceData16bit_c 				0x16
#define gAdPublicTargetAddress_c 			0x17
#define gAdRandomTargetAddress_c 			0x18
#define gAdAppearance_c 					0x19
#define gAdAdvertisingInterval_c 			0x1A
#define gAdLeDeviceAddress_c 				0x1B
#define gAdLeRole_c 						0x1C
#define gAdSimplePairingHashC256_c 			0x1D
#define gAdSimplePairingRandomizerR256_c 	0x1E
#define gAdServiceSolicitationList32bit_c 	0x1F
#define gAdServiceData32bit_c 				0x20
#define gAdServiceData128bit_c 				0x21
#define gAd3dInformationData_c 				0x3D
#define gAdManufacturerSpecificData_c 		0xFF

#define gAdDataIncluded_c					0x01
#define gSecurityRequirementsIncluded_c		0x01

/* Bluetooth Device Address Types */
#define gBleAddrTypePublic_c 				0x00  /* Public Device Address - fixed into the Controller by the manufacturer. */
#define gBleAddrTypeRandom_c 				0x01  /* Random Device Address - set by the Host into the Controller for privacy reasons. */

#define gAdvChanMapFlag37_c 				0x01  /* Bit for channel 37. */
#define gAdvChanMapFlag38_c 				0x02  /* Bit for channel 38. */
#define gAdvChanMapFlag39_c 				0x04  /* Bit for channel 39. */
#define gGapAdvertisingChannelMapDefault_c  (gAdvChanMapFlag37_c | gAdvChanMapFlag38_c | gAdvChanMapFlag39_c)

/* Advertising Filter Policy values */
#define gProcessAll_c 						0x00  /* Default value: accept all connect and scan requests. */
#define gProcessConnAllScanWL_c 			0x01  /* Accept all connect requests, but scan requests only from devices in White List. */
#define gProcessScanAllConnWL_c 			0x02  /* Accept all scan requests, but connect requests only from devices in White List. */
#define gProcessWhiteListOnly_c 			0x03  /* Accept connect and scan requests only from devices in White List. */

#define gDeviceId_c 						0x00