/*!
* @file    app_inc.h
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   汇总应用工程中所有的头文件，便于被C文件引用
*/

#ifndef __APP_INC_H__
#define __APP_INC_H__

#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"
#include "pin_mux.h"

#include "fsl_gpio.h"
#include "fsl_ctimer.h" /* CT0/1/2用于产生PWM控制电机，CT3/4用于捕获编码器速度脉冲 */
#include "fsl_pint.h" /* 引脚中断，捕获编码器方向信号 */
//#include "fsl_mrt.h" /* MRT模块产生周期中断，读取当前速度值。同RIT不同，MRT可以支持多通道定时器 */
#include "hal_dma.h"
#include "fsl_inputmux.h"
#include "hal_sct.h"

#include "oled_12864.h"
#include "oled_12864_print.h"
#include "tick_timer.h"
#include "button.h"
#include "camera_ov7620.h"
#include "image.h"
#include "servo.h"
#include "motor.h"

#endif /* __APP_INC_H__ */

