/*!
* @file    image.h
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   汇总图像处理功能函数API
*/

#ifndef __IMAGE_H__
#define __IMAGE_H__

#include <stdint.h>
#include <stdbool.h>

/* 原始的灰度图像 */
typedef struct
{
    uint8_t *Pixels;
    uint32_t LineMax;
    uint32_t RowMax;
} Image_GrayImageHandle_T;

/* 使用32位数压缩后的图像 */
typedef struct
{
    uint32_t *Pixels; /* 压缩后的二值化像素点 */
    uint32_t LineMax;
    uint32_t RowMax;
} Image_BinaryImageHandle_T;

/* 像素点信息 */
typedef struct
{
    uint8_t  Value; /* 亮度信息 */
    uint32_t LineIdx;
    uint32_t RowIdx;
} Image_PointInfo_T;

/* 最大类间距法求动态阈值，可用于在对灰度图像进行二值化过程中选取合适的阈值 */
uint8_t Image_GetThreshold_OTSU(uint8_t *pixels, uint32_t pixelCount);

/* 从每行中提取道路边界 */
bool Image_GetEdgePixels(uint8_t *pixels, uint32_t lineLen, uint32_t *leftPos, uint32_t *rightPos);

#endif /* __IMAGE_H__ */

