/*!
* @file    motor.h
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   实现对小车后驱直流电机的驱动及编码器测速功能
*/

#ifndef __MOTOR_H__
#define __MOTOR_H__

#include <stdint.h>

/* 驱动电机 */
#define MOTOR_L_SPEED_PWM_FREQ       10000  /* 电机驱动PWM频率，10KHz */
#define MOTOR_L_SPEED_PWM_DUTY_MAX   100    /* 有效占空比的控制区间 */
#define MOTOR_L_SPEED_PWM_DUTY_LIMIT 20     /* 限速，保护电机和驱动不至发热过快 */

#define MOTOR_R_SPEED_PWM_FREQ       10000  /* 电机驱动PWM频率，10KHz */
#define MOTOR_R_SPEED_PWM_DUTY_MAX   100    /* 有效占空比的控制区间 */
#define MOTOR_R_SPEED_PWM_DUTY_LIMIT 20     /* 限速，保护电机和驱动不至发热过快 */

/* 编码器 */
#define MOTOR_L_SPEED_ENC_INTERVAL_HZ  100  /* 测速频率为100Hz */
#define MOTOR_R_SPEED_ENC_INTERVAL_HZ  100  /* 测速频率为100Hz */

void MotorL_InitDriver(void);
void MotorL_SetSpeed(int32_t pwmDuty);
void MotorL_InitEncoder(void);
int32_t MotorL_GetSpeed(void);

void MotorR_InitDriver(void);
void MotorR_SetSpeed(int32_t pwmDuty);
void MotorR_InitEncoder(void);
int32_t MotorR_GetSpeed(void);

#endif /* __MOTOR_H__ */

