/*!
* @file    oled_12864_io.c
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   基于GPIO方式对OLED显示器驱动驱动程序的底层操作进行移植
*/

#include "oled_12864.h"
#include "fsl_gpio.h"

void OLED_HW_Init(void);
void OLED_HW_SetGpioPin(OLED_GpioPin_T pin, uint8_t val);
void OLED_HW_Delay(uint32_t ms);

void OLED_WriteData(uint8_t dat)
{
    uint8_t i;

    OLED_HW_SetGpioPin(eOLED_GpioPin_DC,  1U); /* 设定为数据通信 */

    OLED_HW_SetGpioPin(eOLED_GpioPin_CLK, 0U);
    for (i = 0U; i < 8U; i++)
    {
        if ( 0U != ((1U << (7U-i)) & dat) )
        {
            OLED_HW_SetGpioPin(eOLED_GpioPin_SDA, 1U);
        }
        else
        {
            OLED_HW_SetGpioPin(eOLED_GpioPin_SDA, 0U);
        }
        OLED_HW_SetGpioPin(eOLED_GpioPin_CLK, 1U);
        OLED_HW_SetGpioPin(eOLED_GpioPin_CLK, 0U);
    }
}

void OLED_WriteCmd(uint8_t cmd)
{
    uint8_t i;

    OLED_HW_SetGpioPin(eOLED_GpioPin_DC,  0U); /* 设定为命令通信 */

    OLED_HW_SetGpioPin(eOLED_GpioPin_CLK, 0U);
    for (i = 0U; i < 8U; i++)
    {
        if ( 0U != ((1U << (7U-i)) & cmd) )
        {
            OLED_HW_SetGpioPin(eOLED_GpioPin_SDA, 1U);
        }
        else
        {
            OLED_HW_SetGpioPin(eOLED_GpioPin_SDA, 0U);
        }
        OLED_HW_SetGpioPin(eOLED_GpioPin_CLK, 1U);
        OLED_HW_SetGpioPin(eOLED_GpioPin_CLK, 0U);
    }
}






#if 0
  //-----¶Ë¿Ú³õÊ¼»¯----//
  CLOCK_EnableClock(kCLOCK_Iocon);
  //IOCON_PinMuxSet(IOCON, 1, 0, PIOFun0_config);
  //IOCON_PinMuxSet(IOCON, 1, 1, PIOFun0_config);
  //IOCON_PinMuxSet(IOCON, 1, 2, PIOFun0_config);
  //IOCON_PinMuxSet(IOCON, 1, 3, PIOFun0_config);
  PT1_10_DIR=1;
  PT1_7_DIR=1;
  PT1_21_DIR=1;
  PT1_19_DIR=1;
  PT1_10=0;
  PT1_19=0;
  PT1_7=0;
  PT1_21=0;
#endif

/*
* OLED_DC  - PIO1_10
* OLED_RST - PIO1_21
* OLED_SDA - PIO1_7  (SPI_TX)
* OLED_CLK - PIO1_19 (SPI_CLK)
* OLED_CS  - PIO1_23
*/

#define OLED_GPIO_DC_PORT  1U
#define OLED_GPIO_DC_PIN   10U
#define OLED_GPIO_RST_PORT 1U
#define OLED_GPIO_RST_PIN  21U
#define OLED_GPIO_SDA_PORT 1U
#define OLED_GPIO_SDA_PIN  7U
#define OLED_GPIO_CLK_PORT 1U
#define OLED_GPIO_CLK_PIN  19U
//#define OLED_GPIO_CS_PORT 1U
//#define OLED_GPIO_CS_PIN  23U
void OLED_HW_Init(void)
{
    gpio_pin_config_t GpioPinConfig;

    CLOCK_EnableClock(kCLOCK_Gpio1);

    GpioPinConfig.pinDirection = kGPIO_DigitalOutput;
    GpioPinConfig.outputLogic = 0U;
    GPIO_PinInit(GPIO, OLED_GPIO_DC_PORT , OLED_GPIO_DC_PIN , &GpioPinConfig);
    GPIO_PinInit(GPIO, OLED_GPIO_RST_PORT, OLED_GPIO_RST_PIN, &GpioPinConfig);
    GPIO_PinInit(GPIO, OLED_GPIO_SDA_PORT, OLED_GPIO_SDA_PIN, &GpioPinConfig);
    GPIO_PinInit(GPIO, OLED_GPIO_CLK_PORT, OLED_GPIO_CLK_PIN, &GpioPinConfig);
}

void OLED_HW_SetGpioPin(OLED_GpioPin_T pin, uint8_t val)
{
    switch (pin)
    {
        case eOLED_GpioPin_DC:
            GPIO_WritePinOutput(GPIO, OLED_GPIO_DC_PORT , OLED_GPIO_DC_PIN , val);
            break;
        case eOLED_GpioPin_RST:
            GPIO_WritePinOutput(GPIO, OLED_GPIO_RST_PORT, OLED_GPIO_RST_PIN, val);
            break;
        case eOLED_GpioPin_SDA:
            GPIO_WritePinOutput(GPIO, OLED_GPIO_SDA_PORT, OLED_GPIO_SDA_PIN, val);
            break;
        case eOLED_GpioPin_CLK:
            GPIO_WritePinOutput(GPIO, OLED_GPIO_CLK_PORT, OLED_GPIO_CLK_PIN, val);
            break;
        default:
            break;
    }
}

void OLED_HW_DelayMs(uint32_t ms)
{
    uint32_t i, j;

    for (i = 0U; i < ms; i++)
    {
        for (j = 0U; j < 10000U; j++)
        {
            __NOP();
        }
    }


}

/* EOF. */

