/*!
* @file    oled_12864_print.c
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   实现在OLED上打印字符串的函数
*/

#include "oled_12864_print.h"

volatile uint8_t gOledCurLine = 0U;
volatile uint8_t gOledCurRaw = 0U;

void OLED_PrintReset(void)
{
    gOledCurLine = 0U;
    gOledCurRaw = 0U;
    OLED_ClearScreen(0x00);
}

void OLED_PrintStr(char *str)
{
    while (*str != '\0')
    {
        if (gOledCurRaw >= OLED_ROW_COUNT_MAX - 6U)
        {
            gOledCurRaw = 0U;
            gOledCurLine++;
        }
        if (gOledCurLine >= OLED_LINE_COUNT_MAX)
        {
            OLED_ClearScreen(0x00);
            gOledCurLine = 0U;
        }

        if (*str == '\r')
        {
            gOledCurRaw = 0U;
        }
        else if (*str == '\n')
        {
            gOledCurLine++;
        }
        else
        {
            OLED_PutCharP6x8(gOledCurLine, gOledCurRaw, *str);
            gOledCurRaw += 6U; /* 8x6字符的宽度为6个像素 */
        }

        str++;
    }
}

/* EOF. */

