/*!
* @file    tick_timer.h
* @version v1.0
* @date    2018-02-05
* @author  苏勇 suyong_yq@126.com
* @brief   基于Systick的滴答定时器，实现功能包括：
*          - 基于硬件定时器的可靠延时
*          - 定时器超时回调(单次/周期)
*/

#ifndef __TICK_TIMER_H__
#define __TICK_TIMER_H__

#include <stdint.h>
#include <stdbool.h>
#include <string.h>

bool Tick_Init(uint32_t ticksPerSecond);
void Tick_DelayBlocking(uint32_t ticks);
void Tick_InstallOneTimeCallback(uint32_t ticks, void (*callback)(void));
void Tick_InstallPeriodicalCallback(uint32_t ticks, void (*callback)(void));


#endif /* __TICK_TIMER_H__ */
