/*******************************************************************************
*
 * Copyright (c) 2013 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
* 
*
****************************************************************************//*!
*
* @brief  Absolute Value
* 
*******************************************************************************/
#ifndef _MLIB_ABS_F16_H_
#define _MLIB_ABS_F16_H_

#if defined(__cplusplus)
extern "C" {
#endif

/*******************************************************************************
* Includes
*******************************************************************************/
#include "mlib_types.h"

/*******************************************************************************
* Macros 
*******************************************************************************/
#define MLIB_Abs_F16_Ci(f16Val)    MLIB_Abs_F16_FCi(f16Val)
  
/***************************************************************************//*!
*  Absolute value      
*  f16Out = |f16In|
*  not saturated
*******************************************************************************/
static inline frac16_t MLIB_Abs_F16_FCi(register frac16_t f16Val)
{
    return((f16Val < (frac16_t)0) ? (-f16Val) : (f16Val));
}
 
#if defined(__cplusplus)
}
#endif

#endif /*_MLIB_ABS_F16_H_*/
