/*******************************************************************************
*
 * Copyright (c) 2013 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
* 
*
****************************************************************************//*!
*
* @brief  Absolute Value
* 
*******************************************************************************/
#ifndef _MLIB_ABS_F32_H_
#define _MLIB_ABS_F32_H_

#if defined(__cplusplus)
extern "C" {
#endif

/*******************************************************************************
* Includes
*******************************************************************************/
#include "mlib_types.h"

/*******************************************************************************
* Macros 
*******************************************************************************/
#define MLIB_Abs_F32_Ci(f32Val)    MLIB_Abs_F32_FCi(f32Val)
  
/***************************************************************************//*!
*  Absolute value      
*  32Out = |f32In|
*  not saturated
*******************************************************************************/
static inline frac32_t MLIB_Abs_F32_FCi(register frac32_t f32Val)
{
    return((f32Val < (frac32_t)0) ? (-f32Val) : (f32Val));
}
 
#if defined(__cplusplus)
}
#endif

#endif  /* _MLIB_ABS_F32_H_*/
