/*
 * Copyright 2018-2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/*! @brief Direction type  */
typedef enum _pin_mux_direction
{
  kPIN_MUX_DirectionInput = 0U,         /* Input direction */
  kPIN_MUX_DirectionOutput = 1U,        /* Output direction */
  kPIN_MUX_DirectionInputOrOutput = 2U  /* Input or output direction */
} pin_mux_direction_t;

/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/* GPIO_AD_B0_07 (number 68), LPUART1_RXD */
#define BOARD_INITPINS_UART1_RXD_PERIPHERAL                              LPUART1   /*!< Device name: LPUART1 */
#define BOARD_INITPINS_UART1_RXD_SIGNAL                                       RX   /*!< LPUART1 signal: RX */

/* GPIO_AD_B0_06 (number 72), LPUART1_TXD */
#define BOARD_INITPINS_UART1_TXD_PERIPHERAL                              LPUART1   /*!< Device name: LPUART1 */
#define BOARD_INITPINS_UART1_TXD_SIGNAL                                       TX   /*!< LPUART1 signal: TX */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitLPUART(void);
void BOARD_InitADC(void);
void BOARD_InitPWM(void);
void BOARD_Misc(void);

/* GPIO_EMC_22 (number 93), J19[2]/BT_CFG[4]/SAI1_TXD3 */
#define BOARD_INITPINS_LCD_DC_GPIO_PIN_GPIO                                GPIO2   /*!< GPIO device name: GPIO2 */
#define BOARD_INITPINS_LCD_DC_GPIO_PIN_PORT                                GPIO2   /*!< PORT device name: GPIO2 */
#define BOARD_INITPINS_LCD_DC_GPIO_PIN_PIN                                   22U   /*!< GPIO2 pin index: 22 */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void BOARD_InitPins(void);

/* GPIO_AD_B0_12 (number 63), LPSPI1_SDO/U27[5]/J19[4] */
#define LPSPI1_INITPINS_SPI_MOSI_PERIPHERAL                               LPSPI1   /*!< Device name: LPSPI1 */
#define LPSPI1_INITPINS_SPI_MOSI_SIGNAL                                      SDO   /*!< LPSPI1 signal: SDO */

/* GPIO_AD_B0_13 (number 62), LPSPI1_SDI/U27[2]/J19[5] */
#define LPSPI1_INITPINS_SPI_MISO_PERIPHERAL                               LPSPI1   /*!< Device name: LPSPI1 */
#define LPSPI1_INITPINS_SPI_MISO_SIGNAL                                      SDI   /*!< LPSPI1 signal: SDI */

/* GPIO_AD_B0_10 (number 65), LPSPI1_SCK/U27[6]/J19[6] */
#define LPSPI1_INITPINS_SPI_CLK_PERIPHERAL                                LPSPI1   /*!< Device name: LPSPI1 */
#define LPSPI1_INITPINS_SPI_CLK_SIGNAL                                       SCK   /*!< LPSPI1 signal: SCK */

/* GPIO_AD_B0_11 (number 64), LPSPI1_PCS0/U27[1]/J19[3] */
#define LPSPI1_INITPINS_SPI_CS_PERIPHERAL                                 LPSPI1   /*!< Device name: LPSPI1 */
#define LPSPI1_INITPINS_SPI_CS_SIGNAL                                       PCS0   /*!< LPSPI1 signal: PCS0 */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPSPI1_InitPins(void);

/* GPIO_AD_B1_14 (number 53), I2C1_SCL/U10[17]/J18[6]/U26[4] */
#define LPI2C1_INITPINS_I2C1_SCL_PERIPHERAL                               LPI2C1   /*!< Device name: LPI2C1 */
#define LPI2C1_INITPINS_I2C1_SCL_SIGNAL                                      SCL   /*!< LPI2C1 signal: SCL */

/* GPIO_AD_B1_15 (number 52), I2C1_SDA/U10[18]/J18[5]/J19[9]/U26[6] */
#define LPI2C1_INITPINS_I2C1_SDA_PERIPHERAL                               LPI2C1   /*!< Device name: LPI2C1 */
#define LPI2C1_INITPINS_I2C1_SDA_SIGNAL                                      SDA   /*!< LPI2C1 signal: SDA */


/*!
 * @brief Configures pin routing and optionally pin electrical features.
 *
 */
void LPI2C1_InitPins(void);
#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
