/*
 * Copyright 2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _USB_DEVICE_DESCRIPTOR_H_
#define _USB_DEVICE_DESCRIPTOR_H_ 1

/*******************************************************************************
* Definitions
******************************************************************************/
#define USB_DEVICE_SPECIFIC_BCD_VERSION (0x0200)
#define USB_DEVICE_DEMO_BCD_VERSION (0x0101U)

/* Communication Class SubClass Codes */
#define USB_CDC_DIRECT_LINE_CONTROL_MODEL (0x01)
#define USB_CDC_ABSTRACT_CONTROL_MODEL (0x02)
#define USB_CDC_TELEPHONE_CONTROL_MODEL (0x03)
#define USB_CDC_MULTI_CHANNEL_CONTROL_MODEL (0x04)
#define USB_CDC_CAPI_CONTROL_MOPDEL (0x05)
#define USB_CDC_ETHERNET_NETWORKING_CONTROL_MODEL (0x06)
#define USB_CDC_ATM_NETWORKING_CONTROL_MODEL (0x07)
#define USB_CDC_WIRELESS_HANDSET_CONTROL_MODEL (0x08)
#define USB_CDC_DEVICE_MANAGEMENT (0x09)
#define USB_CDC_MOBILE_DIRECT_LINE_MODEL (0x0A)
#define USB_CDC_OBEX (0x0B)
#define USB_CDC_ETHERNET_EMULATION_MODEL (0x0C)

/* Communication Class Protocol Codes */
#define USB_CDC_NO_CLASS_SPECIFIC_PROTOCOL (0x00) /*also for Data Class Protocol Code */
#define USB_CDC_AT_250_PROTOCOL (0x01)
#define USB_CDC_AT_PCCA_101_PROTOCOL (0x02)
#define USB_CDC_AT_PCCA_101_ANNEX_O (0x03)
#define USB_CDC_AT_GSM_7_07 (0x04)
#define USB_CDC_AT_3GPP_27_007 (0x05)
#define USB_CDC_AT_TIA_CDMA (0x06)
#define USB_CDC_ETHERNET_EMULATION_PROTOCOL (0x07)
#define USB_CDC_EXTERNAL_PROTOCOL (0xFE)
#define USB_CDC_VENDOR_SPECIFIC (0xFF) /*also for Data Class Protocol Code */

/* Data Class Protocol Codes */
#define USB_CDC_PYHSICAL_INTERFACE_PROTOCOL (0x30)
#define USB_CDC_HDLC_PROTOCOL (0x31)
#define USB_CDC_TRANSPARENT_PROTOCOL (0x32)
#define USB_CDC_MANAGEMENT_PROTOCOL (0x50)
#define USB_CDC_DATA_LINK_Q931_PROTOCOL (0x51)
#define USB_CDC_DATA_LINK_Q921_PROTOCOL (0x52)
#define USB_CDC_DATA_COMPRESSION_V42BIS (0x90)
#define USB_CDC_EURO_ISDN_PROTOCOL (0x91)
#define USB_CDC_RATE_ADAPTION_ISDN_V24 (0x92)
#define USB_CDC_CAPI_COMMANDS (0x93)
#define USB_CDC_HOST_BASED_DRIVER (0xFD)
#define USB_CDC_UNIT_FUNCTIONAL (0xFE)

/* Descriptor SubType in Communications Class Functional Descriptors */
#define USB_CDC_HEADER_FUNC_DESC (0x00)
#define USB_CDC_CALL_MANAGEMENT_FUNC_DESC (0x01)
#define USB_CDC_ABSTRACT_CONTROL_FUNC_DESC (0x02)
#define USB_CDC_DIRECT_LINE_FUNC_DESC (0x03)
#define USB_CDC_TELEPHONE_RINGER_FUNC_DESC (0x04)
#define USB_CDC_TELEPHONE_REPORT_FUNC_DESC (0x05)
#define USB_CDC_UNION_FUNC_DESC (0x06)
#define USB_CDC_COUNTRY_SELECT_FUNC_DESC (0x07)
#define USB_CDC_TELEPHONE_MODES_FUNC_DESC (0x08)
#define USB_CDC_TERMINAL_FUNC_DESC (0x09)
#define USB_CDC_NETWORK_CHANNEL_FUNC_DESC (0x0A)
#define USB_CDC_PROTOCOL_UNIT_FUNC_DESC (0x0B)
#define USB_CDC_EXTENSION_UNIT_FUNC_DESC (0x0C)
#define USB_CDC_MULTI_CHANNEL_FUNC_DESC (0x0D)
#define USB_CDC_CAPI_CONTROL_FUNC_DESC (0x0E)
#define USB_CDC_ETHERNET_NETWORKING_FUNC_DESC (0x0F)
#define USB_CDC_ATM_NETWORKING_FUNC_DESC (0x10)
#define USB_CDC_WIRELESS_CONTROL_FUNC_DESC (0x11)
#define USB_CDC_MOBILE_DIRECT_LINE_FUNC_DESC (0x12)
#define USB_CDC_MDLM_DETAIL_FUNC_DESC (0x13)
#define USB_CDC_DEVICE_MANAGEMENT_FUNC_DESC (0x14)
#define USB_CDC_OBEX_FUNC_DESC (0x15)
#define USB_CDC_COMMAND_SET_FUNC_DESC (0x16)
#define USB_CDC_COMMAND_SET_DETAIL_FUNC_DESC (0x17)
#define USB_CDC_TELEPHONE_CONTROL_FUNC_DESC (0x18)
#define USB_CDC_OBEX_SERVICE_ID_FUNC_DESC (0x19)

/* usb descriptor length */
#define USB_DESCRIPTOR_LENGTH_CONFIGURATION_ALL (sizeof(g_UsbDeviceConfigurationDescriptor))
#define USB_CDC_VCOM_REPORT_DESCRIPTOR_LENGTH (33)
#define USB_IAD_DESC_SIZE (8)
#define USB_DESCRIPTOR_LENGTH_CDC_HEADER_FUNC (5)
#define USB_DESCRIPTOR_LENGTH_CDC_CALL_MANAG (5)
#define USB_DESCRIPTOR_LENGTH_CDC_ABSTRACT (4)
#define USB_DESCRIPTOR_LENGTH_CDC_UNION_FUNC (5)

#define USB_DEVICE_CONFIGURATION_COUNT (1)
#define USB_DEVICE_STRING_COUNT (5)
#define USB_DEVICE_LANGUAGE_COUNT (1)
#define USB_INTERFACE_COUNT (30)                         // 15 CDC class need 30 interfaces

#define USB_COMPOSITE_CONFIGURE_INDEX (1)

#define USB_MSC_DISK_CLASS (0x08)
/* scsi command set */
#define USB_MSC_DISK_SUBCLASS (0x06)
/* bulk only transport protocol */
#define USB_MSC_DISK_PROTOCOL (0x50)

/* Configuration, interface and endpoint. */
#define USB_CDC_VCOM_CIC_CLASS (0x02)
#define USB_CDC_VCOM_CIC_SUBCLASS (0x02)
#define USB_CDC_VCOM_CIC_PROTOCOL (0x00)
#define USB_CDC_VCOM_DIC_CLASS (0x0A)
#define USB_CDC_VCOM_DIC_SUBCLASS (0x00)
#define USB_CDC_VCOM_DIC_PROTOCOL (0x00)

#define USB_CDC_VCOM_INTERFACE_COUNT (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_2 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_3 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_4 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_5 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_6 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_7 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_8 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_9 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_10 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_11 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_12 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_13 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_14 (2)
#define USB_CDC_VCOM_INTERFACE_COUNT_15 (2)

#define USB_CDC_VCOM_CIC_INTERFACE_INDEX (0)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX (1)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_2 (2)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_2 (3)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_3 (4)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_3 (5)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_4 (6)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_4 (7)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_5 (8)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_5 (9)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_6 (10)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_6 (11)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_7 (12)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_7 (13)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_8 (14)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_8 (15)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_9 (16)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_9 (17)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_10 (18)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_10 (19)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_11 (20)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_11 (21)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_12 (22)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_12 (23)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_13 (24)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_13 (25)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_14 (26)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_14 (27)
#define USB_CDC_VCOM_CIC_INTERFACE_INDEX_15 (28)
#define USB_CDC_VCOM_DIC_INTERFACE_INDEX_15 (29)

/* No need interrupt IN endpoint for CIC interface */
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_2 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_3 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_4 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_5 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_6 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_7 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_8 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_9 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_10 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_11 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_12 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_13 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_14 (0)
#define USB_CDC_VCOM_CIC_ENDPOINT_COUNT_15 (0)

#if USB_CDC_CIC_INTERRUPT_IN_ENDPOINT_ENABLE
/* No need interrupt IN endpoint for CIC interface */
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_2 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_3 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_4 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_5 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_6 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_7 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_8 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_9 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_10 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_11 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_12 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_13 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_14 (0)
#define USB_CDC_VCOM_CIC_INTERRUPT_IN_ENDPOINT_15 (0)
#endif

/* Two endpoints(Bulk IN EP and Bulk out EP) for DIC interface */
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_2 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_3 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_4 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_5 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_6 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_7 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_8 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_9 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_10 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_11 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_12 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_13 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_14 (2)
#define USB_CDC_VCOM_DIC_ENDPOINT_COUNT_15 (2)


/* Endpoint usage */
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT (1)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT (1)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_2 (2)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_2 (2)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_3 (3)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_3 (3)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_4 (4)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_4 (4)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_5 (5)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_5 (5)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_6 (6)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_6 (6)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_7 (7)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_7 (7)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_8 (8)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_8 (8)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_9 (9)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_9 (9)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_10 (10)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_10 (10)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_11 (11)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_11 (11)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_12 (12)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_12 (12)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_13 (13)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_13 (13)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_14 (14)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_14 (14)
#define USB_CDC_VCOM_DIC_BULK_IN_ENDPOINT_15 (15)
#define USB_CDC_VCOM_DIC_BULK_OUT_ENDPOINT_15 (15)


/* Packet size. */
#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL (0x08)
/* Packet size. */
#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_2 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_2 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_2 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_2 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_3 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_3 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_3 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_3 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_4 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_4 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_4 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_4 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_5 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_5 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_5 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_5 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_6 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_6 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_6 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_6 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_7 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_7 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_7 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_7 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_8 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_8 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_8 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_8 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_9 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_9 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_9 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_9 (0x08)


#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_10 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_10 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_10 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_10 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_11 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_11 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_11 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_11 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_12 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_12 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_12 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_12 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_13 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_13 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_13 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_13 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_14 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_14 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_14 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_14 (0x08)

#define HS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_15 (16)
#define FS_CDC_VCOM_INTERRUPT_IN_PACKET_SIZE_15 (16)
#define HS_CDC_VCOM_INTERRUPT_IN_INTERVAL_15 (0x07) /* 2^(7-1) = 8ms */
#define FS_CDC_VCOM_INTERRUPT_IN_INTERVAL_15 (0x08)


#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_2 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_2 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_2 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_2 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_3 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_3 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_3 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_3 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_4 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_4 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_4 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_4 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_5 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_5 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_5 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_5 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_6 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_6 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_6 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_6 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_7 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_7 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_7 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_7 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_8 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_8 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_8 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_8 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_9 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_9 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_9 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_9 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_10 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_10 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_10 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_10 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_11 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_11 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_11 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_11 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_12 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_12 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_12 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_12 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_13 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_13 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_13 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_13 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_14 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_14 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_14 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_14 (64)

#define HS_CDC_VCOM_BULK_IN_PACKET_SIZE_15 (512)
#define FS_CDC_VCOM_BULK_IN_PACKET_SIZE_15 (64)
#define HS_CDC_VCOM_BULK_OUT_PACKET_SIZE_15 (512)
#define FS_CDC_VCOM_BULK_OUT_PACKET_SIZE_15 (64)

/* String descriptor length. */
#define USB_DESCRIPTOR_LENGTH_STRING0 (sizeof(g_UsbDeviceString0))
#define USB_DESCRIPTOR_LENGTH_STRING1 (sizeof(g_UsbDeviceString1))
#define USB_DESCRIPTOR_LENGTH_STRING2 (sizeof(g_UsbDeviceString2))
#define USB_DESCRIPTOR_LENGTH_STRING3 (sizeof(g_UsbDeviceString3))
#define USB_DESCRIPTOR_LENGTH_STRING4 (sizeof(g_UsbDeviceString4))

#define USB_DESCRIPTOR_TYPE_CDC_CS_INTERFACE (0x24)
#define USB_DESCRIPTOR_TYPE_CDC_CS_ENDPOINT (0x25)

/* Class code. */
#define USB_DEVICE_CLASS (0xEF)
#define USB_DEVICE_SUBCLASS (0x02)
#define USB_DEVICE_PROTOCOL (0x01)

#define USB_DEVICE_MAX_POWER (0x32)

/*******************************************************************************
* API
******************************************************************************/
/*!
 * @brief USB device callback function.
 *
 * This function handles the usb device specific requests.
 *
 * @param handle          The USB device handle.
 * @param event           The USB device event type.
 * @param param           The parameter of the device specific request.
 *
 * @return A USB error code or kStatus_USB_Success.
 */
extern usb_status_t USB_DeviceCallback(usb_device_handle handle, uint32_t event, void *param);
/*!
 * @brief USB device set speed function.
 *
 * This function sets the speed of the USB device.
 *
 * Due to the difference of HS and FS descriptors, the device descriptors and configurations need to be updated to match
 * current speed.
 * As the default, the device descriptors and configurations are configured by using FS parameters for both EHCI and
 * KHCI.
 * When the EHCI is enabled, the application needs to call this function to update device by using current speed.
 * The updated information includes endpoint max packet size, endpoint interval, etc.
 *
 * @param handle The USB device handle.
 * @param speed Speed type. USB_SPEED_HIGH/USB_SPEED_FULL/USB_SPEED_LOW.
 *
 * @return A USB error code or kStatus_USB_Success.
 */
extern usb_status_t USB_DeviceSetSpeed(usb_device_handle handle, uint8_t speed);
#if (defined(USB_DEVICE_CONFIG_CV_TEST) && (USB_DEVICE_CONFIG_CV_TEST > 0U))
/* Get device qualifier descriptor request */
usb_status_t USB_DeviceGetDeviceQualifierDescriptor(
    usb_device_handle handle, usb_device_get_device_qualifier_descriptor_struct_t *deviceQualifierDescriptor);
#endif

#endif /* _USB_DEVICE_DESCRIPTOR_H_ */
