#ifndef __SCT_USER_H__
#define __SCT_USER_H__


void MC_INIT(void);
void SCT_INIT (void);
void SCT_STOP (void);
unsigned char GET_MPOS(void);
void update_sct_out(unsigned long hall_sensor_value);


#define MR3 SCT0->SCTMATCHREL[3]
#define MR4 SCT0->SCTMATCHREL[4]
#define MR6 SCT0->SCTMATCHREL[6]

// Port pin number equates
#define P0_1      1
#define P0_16    16
#define P0_25    25

#define M_PHA P0_1
#define M_PHB P0_16
#define M_PHC P0_25

#define DIRECTION_CW              0         /* Clockwise direction */
#define DIRECTION_CCW             1         /* Counter Clockwise direction */

#define CNT_MODULO_VALUE          1000      /* This is the value that will be loaded into PWM modulo register */  
#define CNT_MINIMUN_VALUE         100/* This is the minimum value for a PWM */
#define CNT_MAXIMUN_VALUE         2000      /* This is the maximum value for a PWM */
#define CNT_NUM_VALUE		(CNT_MODULO_VALUE - DEAD_TIME)
#define DEAD_TIME                 15        /*30tick = 1us  Dead time used to avoid short circuits in the same phase transistors */ 


typedef enum {
	M_STOP=0,
	M_START=1,	
	M_ERROR=2
}MOTOR_STATE_T;



#endif
