/*******************************************************************************
*
* E M B E D D E D   W I Z A R D   P R O J E C T
*
*                                                Copyright (c) TARA Systems GmbH
*                                    written by Paul Banach and Manfred Schweyer
*
********************************************************************************
*
* This file was generated automatically by Embedded Wizard Studio.
*
* Please do not make any modifications of this file! The modifications are lost
* when the file is generated again by Embedded Wizard Studio!
*
* The template of this heading text can be found in the file 'head.ewt' in the
* directory 'Platforms' of your Embedded Wizard installation directory. If you
* wish to adapt this text, please copy the template file 'head.ewt' into your
* project directory and edit the copy only. Please avoid any modifications of
* the original template file!
*
* Version  : 11.00
* Profile  : iMX_RT
* Platform : NXP.iMX_RT.RGBA8888
*
*******************************************************************************/

#include <stdint.h>
#include <stddef.h>
#include <stdlib.h>

#include "input_proc.h"

#include "ewlocale.h"
#include "_ApplicationApplication.h"
#include "_CoreSimpleTouchHandler.h"
#include "_CoreView.h"
#include "_GraphicsCanvas.h"
#include "_ResourcesBitmap.h"
#include "_ResourcesFont.h"
#include "_ViewsBorder.h"
#include "_ViewsImage.h"
#include "_ViewsRectangle.h"
#include "_ViewsText.h"
#include "_WidgetSetPushButton.h"
#include "_WidgetSetPushButtonConfig.h"
#include "Application.h"
#include "Core.h"
#include "Resources.h"
#include "WidgetSet.h"

/* Include a file containing the font resource : 'Application::FontCustomSize' */
#include "_ApplicationFontCustomSize.h"

#define ADD_PIXELS 8

/* Compressed strings for the language 'Default'. */
EW_CONST_STRING_PRAGMA static const unsigned int _StringsDefault0[] =
{
  0x00000062, /* ratio 85.71 % */
  0xB8001F00, 0x800A6452, 0x00E80032, 0x0A000100, 0xE6003080, 0x07700444, 0x72001BC0,
  0xC0019000, 0x21C12051, 0x7C1CD800, 0x00217188, 0x224A6383, 0x2386E844, 0x8B030400,
  0x12D00124, 0x093A800E, 0x2988265D, 0x9C44A465, 0x74BA1522, 0x00001019, 0x00000000
};

/* Table with links to derived variants of the font resource : 'Application::FontCustomSize' */
EW_RES_WITHOUT_VARIANTS( ApplicationFontCustomSize )

/* Constant values used in this 'C' module only. */
static const XRect _Const0000 = {{ 0, 0 }, { 1280, 720 }};
static const XColor _Const0001 = { 0x00, 0x00, 0x00, 0xFF };
static const XRect _Const0002 = {{ 417, 160 }, { 641, 384 }};
static const XPoint _Const0003 = { 224, 224 };
static const XPoint _Const0004 = { 417, 160 };
static const XPoint _Const0005 = { 641, 160 };
static const XPoint _Const0006 = { 641, 384 };
static const XPoint _Const0007 = { 417, 384 };
static const XRect _Const0008 = {{ 416, 159 }, { 642, 385 }};
static const XRect _Const0009 = {{ 655, 159 }, { 881, 385 }};
static const XRect _Const000A = {{ 524, 464 }, { 772, 550 }};
static const XStringRes _Const000B = { _StringsDefault0, 0x0002 };
static const XRect _Const000C = {{ 525, 556 }, { 772, 632 }};
static const XStringRes _Const000D = { _StringsDefault0, 0x0011 };
static const XRect _Const000E = {{ 417, 88 }, { 641, 164 }};
static const XStringRes _Const000F = { _StringsDefault0, 0x0020 };
static const XRect _Const0010 = {{ 655, 88 }, { 879, 164 }};
static const XStringRes _Const0011 = { _StringsDefault0, 0x0028 };
static const XRect _Const0012 = {{ 656, 160 }, { 880, 384 }};
static const XColor _Const0013 = { 0x00, 0x00, 0x00, 0x00 };

/* Initializer for the class 'Application::Application' */
void ApplicationApplication__Init( ApplicationApplication _this, XObject aLink, XHandle aArg )
{
  /* At first initialize the super class ... */
  CoreRoot__Init( &_this->_.Super, aLink, aArg );

  /* Allow the Immediate Garbage Collection to evalute the members of this class. */
  _this->_.XObject._.GCT = EW_CLASS_GCT( ApplicationApplication );

  /* ... then construct all embedded objects */
  ViewsRectangle__Init( &_this->Rectangle, &_this->_.XObject, 0 );
  ViewsImage__Init( &_this->Image, &_this->_.XObject, 0 );
  GraphicsCanvas__Init( &_this->Canvas, &_this->_.XObject, 0 );
  CoreSimpleTouchHandler__Init( &_this->SimpleTouchHandler, &_this->_.XObject, 0 );
  ViewsBorder__Init( &_this->Border1, &_this->_.XObject, 0 );
  ViewsBorder__Init( &_this->Border2, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->RunButton, &_this->_.XObject, 0 );
  WidgetSetPushButton__Init( &_this->ClearButton, &_this->_.XObject, 0 );
  ViewsText__Init( &_this->InputBoxLabel, &_this->_.XObject, 0 );
  ViewsText__Init( &_this->ResultBoxLabel, &_this->_.XObject, 0 );
  ViewsText__Init( &_this->ResultText, &_this->_.XObject, 0 );

  /* Setup the VMT pointer */
  _this->_.VMT = EW_CLASS( ApplicationApplication );

  /* ... and initialize objects, variables, properties, etc. */
  CoreRectView__OnSetBounds( _this, _Const0000 );
  CoreRectView__OnSetBounds( &_this->Rectangle, _Const0000 );
  ViewsRectangle_OnSetColor( &_this->Rectangle, _Const0001 );
  CoreRectView__OnSetBounds( &_this->Image, _Const0002 );
  ResourcesBitmap__OnSetFrameSize( &_this->Canvas, _Const0003 );
  CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleTouchHandler, _Const0004 );
  CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleTouchHandler, _Const0005 );
  CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleTouchHandler, _Const0006 );
  CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleTouchHandler, _Const0007 );
  CoreRectView__OnSetBounds( &_this->Border1, _Const0008 );
  ViewsBorder_OnSetColor( &_this->Border1, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->Border2, _Const0009 );
  ViewsBorder_OnSetColor( &_this->Border2, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->RunButton, _Const000A );
  WidgetSetPushButton_OnSetLabel( &_this->RunButton, EwLoadString( &_Const000B ));
  CoreRectView__OnSetBounds( &_this->ClearButton, _Const000C );
  WidgetSetPushButton_OnSetLabel( &_this->ClearButton, EwLoadString( &_Const000D ));
  CoreRectView__OnSetBounds( &_this->InputBoxLabel, _Const000E );
  ViewsText_OnSetString( &_this->InputBoxLabel, EwLoadString( &_Const000F ));
  ViewsText_OnSetColor( &_this->InputBoxLabel, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->ResultBoxLabel, _Const0010 );
  ViewsText_OnSetString( &_this->ResultBoxLabel, EwLoadString( &_Const0011 ));
  ViewsText_OnSetColor( &_this->ResultBoxLabel, ApplicationMainColor );
  CoreRectView__OnSetBounds( &_this->ResultText, _Const0012 );
  ViewsText_OnSetString( &_this->ResultText, 0 );
  ViewsText_OnSetColor( &_this->ResultText, ApplicationMainColor );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Rectangle ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Image ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->SimpleTouchHandler ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Border1 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->Border2 ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->RunButton ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->ClearButton ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->InputBoxLabel ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->ResultBoxLabel ), 0 );
  CoreGroup_Add((CoreGroup)_this, ((CoreView)&_this->ResultText ), 0 );
  ViewsImage_OnSetBitmap( &_this->Image, ((ResourcesBitmap)&_this->Canvas ));
  _this->SimpleTouchHandler.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag );
  CoreGroup__OnSetFocus( &_this->RunButton, 0 );
  _this->RunButton.OnPress = EwNewSlot( _this, ApplicationApplication_onPressRun );
  WidgetSetPushButton_OnSetAppearance( &_this->RunButton, EwGetAutoObject( &WidgetSetPushButton_Medium, 
  WidgetSetPushButtonConfig ));
  _this->ClearButton.OnPress = EwNewSlot( _this, ApplicationApplication_onPressClear );
  WidgetSetPushButton_OnSetAppearance( &_this->ClearButton, EwGetAutoObject( &WidgetSetPushButton_Medium, 
  WidgetSetPushButtonConfig ));
  ViewsText_OnSetFont( &_this->InputBoxLabel, EwLoadResource( &ResourcesFontExtraLarge, 
  ResourcesFont ));
  ViewsText_OnSetFont( &_this->ResultBoxLabel, EwLoadResource( &ResourcesFontExtraLarge, 
  ResourcesFont ));
  ViewsText_OnSetFont( &_this->ResultText, EwLoadResource( &ApplicationFontCustomSize, 
  ResourcesFont ));

  /* Call the user defined constructor */
  ApplicationApplication_Init( _this, aArg );
}

/* Re-Initializer for the class 'Application::Application' */
void ApplicationApplication__ReInit( ApplicationApplication _this )
{
  /* At first re-initialize the super class ... */
  CoreRoot__ReInit( &_this->_.Super );

  /* ... then re-construct all embedded objects */
  ViewsRectangle__ReInit( &_this->Rectangle );
  ViewsImage__ReInit( &_this->Image );
  GraphicsCanvas__ReInit( &_this->Canvas );
  CoreSimpleTouchHandler__ReInit( &_this->SimpleTouchHandler );
  ViewsBorder__ReInit( &_this->Border1 );
  ViewsBorder__ReInit( &_this->Border2 );
  WidgetSetPushButton__ReInit( &_this->RunButton );
  WidgetSetPushButton__ReInit( &_this->ClearButton );
  ViewsText__ReInit( &_this->InputBoxLabel );
  ViewsText__ReInit( &_this->ResultBoxLabel );
  ViewsText__ReInit( &_this->ResultText );
}

/* Finalizer method for the class 'Application::Application' */
void ApplicationApplication__Done( ApplicationApplication _this )
{
  /* Finalize this class */
  _this->_.Super._.VMT = EW_CLASS( CoreRoot );

  /* Finalize all embedded objects */
  ViewsRectangle__Done( &_this->Rectangle );
  ViewsImage__Done( &_this->Image );
  GraphicsCanvas__Done( &_this->Canvas );
  CoreSimpleTouchHandler__Done( &_this->SimpleTouchHandler );
  ViewsBorder__Done( &_this->Border1 );
  ViewsBorder__Done( &_this->Border2 );
  WidgetSetPushButton__Done( &_this->RunButton );
  WidgetSetPushButton__Done( &_this->ClearButton );
  ViewsText__Done( &_this->InputBoxLabel );
  ViewsText__Done( &_this->ResultBoxLabel );
  ViewsText__Done( &_this->ResultText );

  /* Don't forget to deinitialize the super class ... */
  CoreRoot__Done( &_this->_.Super );
}

/* The method Init() is invoked automatically after the component has been created. 
   This method can be overridden and filled with logic containing additional initialization 
   statements. */
void ApplicationApplication_Init( ApplicationApplication _this, XHandle aArg )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( aArg );

  GraphicsCanvas_FillRectangle( &_this->Canvas, EwGetRectORect( _this->Image.Super1.Bounds ), 
  EwGetRectORect( _this->Image.Super1.Bounds ), _Const0013, _Const0013, _Const0013, 
  _Const0013, 0 );
  CoreView__ChangeViewState( &_this->RunButton, (XSet)0, CoreViewStateFocused );
  CoreView__ChangeViewState( &_this->ClearButton, (XSet)0, CoreViewStateFocused );
}

/* 'C' function for method : 'Application::Application.onDrag()' */
void ApplicationApplication_onDrag( ApplicationApplication _this, XObject sender )
{
  XColor clr;

  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  clr = ApplicationMainColor;
  GraphicsCanvas_DrawLine( &_this->Canvas, EwGetRectORect( _this->Image.Super1.Bounds ), 
  EwMovePointNeg( EwMovePointNeg( _this->SimpleTouchHandler.CurrentPos, _this->SimpleTouchHandler.Offset ), 
  _this->Image.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleTouchHandler.CurrentPos, 
  _this->Image.Super1.Bounds.Point1 ), clr, clr, 1 );
  EwNotifyObjObservers((XObject)&_this->Canvas, 0 );
}

void ProcessInput( ApplicationApplication _this, int *input_digit )
{
	XHandle tmp;
	XRect aArea;
	XInt32 width;
	XInt32 height;

	tmp = _this->Canvas.Super1.bitmap;

	aArea = EwGetRectORect( _this->Image.Super1.Bounds );

	width = aArea.Point2.X - aArea.Point1.X;
	height = aArea.Point2.Y - aArea.Point1.Y;

	XBitmap* bitmap = (XBitmap*)tmp;

	/* The color is stored in an embedded wizard structure and needs to be converted
	   into an integer so that it can be compared to the stored color values
	   in the memory. The stored color format is 0xAARRGGBB, where A stands for Alpha,
	   R for red, G for green and B for blue. */
	uint32_t drawing_colorINT = ((uint32_t) ApplicationMainColor.Alpha) << 24 |((uint32_t) ApplicationMainColor.Red) << 16 | ((uint32_t) ApplicationMainColor.Green) << 8 | ((uint32_t) ApplicationMainColor.Blue);

	XBitmapLock* lock = EwLockBitmap(bitmap, 0, aArea, 1, 0);

	uint32_t* src   = (uint32_t*)lock->Pixel1;

	int ofs = ( lock->Pitch1Y / 4 ) - width; // offset between rows (to skip irrelevant pixels on each row)

	uint8_t *bmp = (uint8_t*) malloc(sizeof(uint8_t) * width * height);

	if (bmp == NULL)
	{
		EwPrint("Out of memory!\n\r");
		return;
	}

	for (int i = 0; i < width * height; i++)
	{
		bmp[i] = 0;
	}

	for (int y = 0; y < height; y++, src += ofs)
	{
		for (int x = 0; x < width; x++, src++)
		{
			/* <drawing_color> colored pixels get stored as 0xFF bytes forming + signs with ADD_PIXELS long lines,
			 in order to thicken the drawn digit so that the pixels aren't lost when the picture is resized.
			 All the other pixels are stored as 0x00. Since the MNIST dataset contains single-channel
			 greyscale images, feeding the trained model single-channel black and white images
			 created this way works as well. */
			if (*src == drawing_colorINT)
			{
				for (int i = -(ADD_PIXELS/2); i <= ADD_PIXELS/2; i++ )
				{
					if ((x + i) > 0 && (x + i) < width)
						bmp[(x + i) + (y * width)] = 0xFF;
					if ((y + i) > 0 && (y + i) < height)
						bmp[x + ((y + i) * width)] = 0xFF;
				}
			}
		}
	}


	*input_digit = MODEL_ClassifyInput(bmp, width, height);

	free(bmp);

	EwUnlockBitmap(lock);
}

/* 'C' function for method : 'Application::Application.onPressClear()' */
void ApplicationApplication_onPressClear( ApplicationApplication _this, XObject 
  sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( sender );

  GraphicsCanvas_FillRectangle( &_this->Canvas, EwGetRectORect( _this->Image.Super1.Bounds ), 
  EwGetRectORect( _this->Image.Super1.Bounds ), ApplicationBackgroundColor, ApplicationBackgroundColor, 
  ApplicationBackgroundColor, ApplicationBackgroundColor, 0 );
  CoreGroup__InvalidateArea( _this, _this->Image.Super1.Bounds );
  ViewsText_OnSetString( &_this->ResultText, 0 );
}

/* 'C' function for method : 'Application::Application.onPressRun()' */
void ApplicationApplication_onPressRun( ApplicationApplication _this, XObject sender )
{
  /* Dummy expressions to avoid the 'C' warning 'unused argument'. */
  EW_UNUSED_ARG( _this );
  EW_UNUSED_ARG( sender );

	int input_digit;
	ProcessInput( _this, &input_digit );

	char input_digit_string[2];
	input_digit_string[0] = (char) (input_digit + 48); // 48 is the ASCII decimal value of 0
	input_digit_string[1] = '\0';

	ViewsText_OnSetString(&_this->ResultText, EwNewStringAnsi(input_digit_string));
}

/* Variants derived from the class : 'Application::Application' */
EW_DEFINE_CLASS_VARIANTS( ApplicationApplication )
EW_END_OF_CLASS_VARIANTS( ApplicationApplication )

/* Virtual Method Table (VMT) for the class : 'Application::Application' */
EW_DEFINE_CLASS( ApplicationApplication, CoreRoot, Rectangle, Rectangle, Rectangle, 
                 Rectangle, _.VMT, _.VMT, "Application::Application" )
  CoreRectView_initLayoutContext,
  CoreRoot_GetRoot,
  CoreRoot_Draw,
  CoreView_HandleEvent,
  CoreGroup_CursorHitTest,
  CoreRectView_ArrangeView,
  CoreRectView_MoveView,
  CoreRectView_GetExtent,
  CoreRoot_ChangeViewState,
  CoreGroup_OnSetBounds,
  CoreRoot_OnSetFocus,
  CoreRoot_DispatchEvent,
  CoreRoot_BroadcastEvent,
  CoreGroup_UpdateViewState,
  CoreRoot_InvalidateArea,
EW_END_OF_CLASS( ApplicationApplication )



/* User defined constant: 'Application::MainColor' */
const XColor ApplicationMainColor = { 0xFF, 0xFF, 0xFF, 0xFF };

/* User defined constant: 'Application::BackgroundColor' */
const XColor ApplicationBackgroundColor = { 0x00, 0x00, 0x00, 0xFF };

/* Embedded Wizard */
