/*
 * Copyright 2020-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>

#include "demo_config.h"
#include "image.h"
#include "image_utils.h"
#include "image_data.h"

/*******************************************************************************
 * Variables
 ******************************************************************************/

/* Image name. */
static const char* s_imageName = STATIC_IMAGE_NAME;
static bool s_static = true;

/*******************************************************************************
 * Code
 ******************************************************************************/

/*!
 * @brief Stores image data to destination buffer.
 *
 * This function gets image from static image or from camera device.
 *
 * @param dstData address of destination buffer for storing image data
 * @param dstWidth width of destination image
 * @param dstHeight height of destination image
 * @param dstChannels number of color channels of destination image
 * @return status code
 */
status_t IMAGE_GetImage(uint8_t* dstData, int32_t dstWidth, int32_t dstHeight, int32_t dstChannels)
{
	return IMAGE_Decode(image_data, dstData, dstWidth, dstHeight, dstChannels);
}

/*!
 * @brief Gets Image name.
 *
 * This function returns name of static image.
 *
 * @return name of the image
 */
const char* IMAGE_GetImageName(void)
{
    if (s_static)
    {
        return s_imageName;
    }
    return "camera";
}
