/*
 * main.c
 *
 *  Created on:
 *      Author:
 */

// Functional description
// * Configure the SCT for unified, unidirectional mode, with state 0 only.
// * Falling edge on CTIN_0 is Event 0.
// * Rising edge on CTIN_0 is Event 1.
// * Event 0 causes the value of the timer to be captured in capture register 0, halts, and resets the timer.
// * Event 1 causes the value of the timer to be captured in capture register 1, halts, and resets the timer.
// * Both events cause an interrupt in which the ISR waits in a debounce loop, then sets a flag for main
//   that a new captured value is available for the appropriate event.
// * Main outputs the elapsed time (in clocks), restarts the SCT counter, and the process repeats.
// * Pins used in this example:
//   P0.0  [Input]  - CTIN_0  (falling edge = Event 0, rising edge = Event 1)

#include <stdio.h>
#include <string.h>
#include "LPC8xx.h"
#include "lpc8xx_syscon.h"
#include "lpc8xx_sct.h"
#include "lpc8xx_swm.h"
#include "utilities.h"
#include "lpc8xx_uart.h"

#include "SCT_UART.h"

volatile uint8_t BytetoPrint;
volatile int8_t flag = 0;

void SCT_UART_Receive_Byte_CallBack(uint8_t ReceiveByte)
{
    BytetoPrint = ReceiveByte;
    flag = 1;
}

int main(void)
{
    SCT_UART_Init();

    while (1)
    {
        if (flag == 1)
        {
            SCT_UART_Send_Byte(BytetoPrint);
            flag = 0;
        }
    } // end of while(1)
} // end of main
