/*
 * Copyright (c) 2013 - 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "app.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
ntshell_t nts;
    
/*******************************************************************************
 * Code
 ******************************************************************************/
static int serial_read(char *buf, int cnt, void *extobj)
{
    for (int i = 0; i < cnt; i++) {
        buf[i] = uart_getc();
    }
    return cnt;
}

static int serial_write(const char *buf, int cnt, void *extobj)
{
    for (int i = 0; i < cnt; i++) {
        uart_putc(buf[i]);
    }
    return cnt;
}

static int user_callback(const char *text, void *extobj)
{
#if 0
    /*
     * This is a really simple example codes for the callback function.
     */
    uart_puts("USERINPUT[");
    uart_puts(text);
    uart_puts("]\r\n");
#else
    /*
     * This is a complete example for a real embedded application.
     */
    usrcmd_execute(text);
#endif
    return 0;
}

 
/*!
 * @brief Main function
 */
int main(void)
{
    void *extobj = 0;
    
    BOARD_BootClockFROHF96M();
    
    /* Init IOCON by main.c */
    /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */
    CLOCK_EnableClock(kCLOCK_Iocon);
    CLOCK_EnableClock(kCLOCK_Gpio0);
    CLOCK_EnableClock(kCLOCK_Gpio1);
    /* Debug Usart Pin Init */
    IOCON->PIO[DEBUGTX_PORT][DEBUGTX_PIN] = DEBUGTX_FUNC;  // Debug Usart TXD pin
    IOCON->PIO[DEBUGRX_PORT][DEBUGRX_PIN] = DEBUGRX_FUNC;  // Debug Usart TXD pin

    IOCON->PIO[LEDR_PORT][LEDR_PIN]       = LEDR_FUNC;     // Red   LED Ctrl pin
    IOCON->PIO[LEDG_PORT][LEDG_PIN]       = LEDG_FUNC;     // Green LED Ctrl pin
    IOCON->PIO[LEDB_PORT][LEDB_PIN]       = LEDB_FUNC;     // Blue  LED Ctrl pin
    
    /* Init LED Pins */
    led_init();
    
    /* Init debug uart port with 115200, 8n1 */
    debug_init(115200);
    
    /* log info */
    PRINTF("LPC55S16-EVK ntshell demo!\r\n");
    PRINTF("LPC55S16 Core Frequency is %dMHz!\r\n", SystemCoreClock/1000000);
    uart_puts("User command example for NT-Shell.\r\n");
    /* Init ntshell */
    ntshell_init(&nts, serial_read, serial_write, user_callback, extobj);
    /* Set ntshell prompt name */
    ntshell_set_prompt(&nts, "LPC55S16>");
    
    while (1)
    {
        /*ntshell tasks */
        ntshell_execute(&nts);
    }
}
