/*
 * Copyright (c) 2017 - 2018 , NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "app.h"
#include "app_led.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/
/**
 * @brief   led set status
 * @param   led num
 * @param   status
 * @return  NULL
 */
void led_init(void)
{
    gpio_pin_config_t   gpioPinConfig;
    gpioPinConfig.pinDirection = kGPIO_DigitalOutput;
    gpioPinConfig.outputLogic  = 0u; /* output high as default. */
    
    GPIO_PinInit (GPIO, LEDR_PORT, LEDR_PIN, &gpioPinConfig);
    GPIO_PinInit (GPIO, LEDG_PORT, LEDG_PIN, &gpioPinConfig);
    GPIO_PinInit (GPIO, LEDB_PORT, LEDB_PIN, &gpioPinConfig);
}

/**
 * @brief   led set status
 * @param   led num
 * @param   status
 * @return  NULL
 */
void led_set(uint32_t num, uint8_t value)
{
    if(num == LEDR_NUM)
    {
        GPIO_PinWrite(GPIO, LEDR_PORT, LEDR_PIN, value);
    }
    if(num == LEDG_NUM)
    {
        GPIO_PinWrite(GPIO, LEDG_PORT, LEDG_PIN, value);
    }
    if(num == LEDB_NUM)
    {
        GPIO_PinWrite(GPIO, LEDB_PORT, LEDB_PIN, value);
    }
}

/**
 * @brief   led toggle status
 * @param   led num
 * @param   status
 * @return  NULL
 */
void led_toggle(uint32_t num)
{
    if(num == LEDR_NUM)
    {
        GPIO_PortToggle(GPIO, LEDR_PORT, 1 << LEDR_PIN);
    }
    if(num == LEDG_NUM)
    {
        GPIO_PortToggle(GPIO, LEDG_PORT, 1 << LEDG_PIN);
    }
    if(num == LEDB_NUM)
    {
        GPIO_PortToggle(GPIO, LEDB_PORT, 1 << LEDB_PIN);
    }
}

// end file
