/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _FSL_SDIF1_H_
#define _FSL_SDIF1_H_

#include "fsl_common.h"

/*!
 * @addtogroup sdif
 * @{
 */

/**********************************
 * Definitions.
 *****************************************************************************/

/*!
 * @brief SDIF send initialize 80 clocks for SD card 1 after initial
 * @param base SDIF peripheral base address.
 * @param timeout value
 */
bool SDIF_SendCard1Active(SDIF_Type *base, uint32_t timeout);

/*!
 * @brief Sets the card 1 bus clock frequency.
 *
 * @param base SDIF peripheral base address.
 * @param srcClock_Hz SDIF source clock frequency united in Hz.
 * @param target_HZ card bus clock frequency united in Hz.
 * @return The nearest frequency of busClock_Hz configured to SD bus.
 */
uint32_t SDIF_SetCard1Clock(SDIF_Type *base, uint32_t srcClock_Hz, uint32_t target_HZ);

/* @} */

#if defined(__cplusplus)
}
#endif
/*! @} */

#endif /* _FSL_sdif1_H_*/
