/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _SDMMC_HOST1_H
#define _SDMMC_HOST1_H

#include "fsl_common.h"
#include "board.h"
#if defined(FSL_FEATURE_SOC_SDHC_COUNT) && FSL_FEATURE_SOC_SDHC_COUNT > 0U
#include "fsl_sdhc.h"
#elif defined(FSL_FEATURE_SOC_SDIF_COUNT) && FSL_FEATURE_SOC_SDIF_COUNT > 0U
#include "fsl_sdif.h"
#include "fsl_sdif1.h"
#elif defined(FSL_FEATURE_SOC_USDHC_COUNT) && FSL_FEATURE_SOC_USDHC_COUNT > 0U
#include "fsl_usdhc.h"
#endif

/*!
 * @addtogroup SDMMCHOST
 * @{
 */

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define SDMMCHOST_SET_CARD1_CLOCK(base, sourceClock_HZ, busClock_HZ) \
    (SDIF_SetCard1Clock(base, sourceClock_HZ, busClock_HZ))
		
#define SDMMCHOST_SEND_CARD1_ACTIVE(base, timeout) (SDIF_SendCard1Active(base, timeout))
 
#define SDMMCHOST_SET_CARD1_BUS_WIDTH(base, busWidth) (SDIF_SetCard1BusWidth(base, busWidth)) 
 
#define SDMMCHOST_ENABLE_CARD1_CLOCK(base, enable) (SDIF_EnableCard1Clock(base, enable))
/* sd card detect through host CD */
#define SDMMCHOST_CARD1_DETECT_INSERT_STATUS(base, data3) (SDIF_DetectCard1Insert(base, data3))
/* @} */
#endif /* _FSL_SDMMC_HOST_H */
