/*******************************************************************************
 *
 * E M B E D D E D   W I Z A R D   P R O J E C T
 *
 *                                                Copyright (c) TARA Systems GmbH
 *                                    written by Paul Banach and Manfred Schweyer
 *
 ********************************************************************************
 *
 * This file was generated automatically by Embedded Wizard Studio.
 *
 * Please do not make any modifications of this file! The modifications are lost
 * when the file is generated again by Embedded Wizard Studio!
 *
 * The template of this heading text can be found in the file 'head.ewt' in the
 * directory 'Platforms' of your Embedded Wizard installation directory. If you
 * wish to adapt this text, please copy the template file 'head.ewt' into your
 * project directory and edit the copy only. Please avoid any modifications of
 * the original template file!
 *
 * Version  : 9.20
 * Profile  : Profile
 * Platform : NXP.iMX_RT.RGBA8888
 *
 *******************************************************************************/

#include <mnist_lock.h>

#include "ewlocale.h"
#include "_ApplicationApplication.h"
#include "_CoreSimpleTouchHandler.h"
#include "_CoreView.h"
#include "_GraphicsCanvas.h"
#include "_ResourcesBitmap.h"
#include "_ResourcesFont.h"
#include "_ViewsBorder.h"
#include "_ViewsImage.h"
#include "_ViewsRectangle.h"
#include "_ViewsText.h"
#include "_WidgetSetPushButton.h"
#include "_WidgetSetPushButtonConfig.h"
#include "Application.h"
#include "Core.h"
#include "CustomConstants.h"
#include "Resources.h"
#include "WidgetSet.h"
#include "stdint.h"
#include "stdlib.h"
#include "ewrte.h"
#include "ewgfxdriver.h"
#include "ewextgfx.h"
#include "ewgfxdefs.h"

#include "ewextpxl_RGBA8888.h"

/* Compressed strings for the language 'Default'. */
static const unsigned int _StringsDefault0[] =
{
		0x00000046, /* ratio 97.14 % */
		0xB8001300, 0x80000452, 0x00D80021, 0x0C200328, 0x01063900, 0x10581840, 0x008594C0,
		0x010000E8, 0x00434A00, 0xB8024073, 0x43CDE003, 0x22226400, 0x499068A0, 0x00630049,
		0x334889AC, 0x00000020, 0x00000000
};

/* Constant values used in this 'C' module only. */
static const XRect _Const0000 = {{ 0, 0 }, { 480, 270 }};
static const XPoint _Const0001 = { 112, 112 };
static const XRect _Const0002 = {{ 4, 18 }, { 116, 130 }};
static const XPoint _Const0003 = { 4, 18 };
static const XPoint _Const0004 = { 116, 18 };
static const XPoint _Const0005 = { 116, 130 };
static const XPoint _Const0006 = { 4, 130 };
static const XRect _Const0007 = {{ 4, 200 }, { 164, 250 }};
static const XStringRes _Const0008 = { _StringsDefault0, 0x0003 };
static const XRect _Const0009 = {{ 2, 16 }, { 118, 132 }};
static const XRect _Const000A = {{ 4, 150 }, { 164, 200 }};
static const XStringRes _Const000B = { _StringsDefault0, 0x000C };
static const XRect _Const000C = {{ 124, 18 }, { 236, 130 }};
static const XPoint _Const000D = { 124, 18 };
static const XPoint _Const000E = { 236, 18 };
static const XPoint _Const000F = { 236, 130 };
static const XPoint _Const0010 = { 124, 130 };
static const XRect _Const0011 = {{ 122, 16 }, { 238, 132 }};
static const XRect _Const0012 = {{ 244, 18 }, { 356, 130 }};
static const XPoint _Const0013 = { 244, 18 };
static const XPoint _Const0014 = { 356, 18 };
static const XPoint _Const0015 = { 356, 130 };
static const XPoint _Const0016 = { 244, 130 };
static const XRect _Const0017 = {{ 242, 16 }, { 358, 132 }};
static const XRect _Const0018 = {{ 364, 18 }, { 476, 130 }};
static const XColor _Const0019 = { 0xFF, 0xFF, 0xFF, 0xFF };
static const XPoint _Const001A = { 364, 18 };
static const XPoint _Const001B = { 476, 18 };
static const XPoint _Const001C = { 476, 130 };
static const XPoint _Const001D = { 364, 130 };
static const XRect _Const001E = {{ 362, 16 }, { 478, 132 }};
static const XRect _Const001F = {{ 166, 152 }, { 314, 246 }};
static const XStringRes _Const0020 = { _StringsDefault0, 0x001C };
static const XRect _Const0021 = {{ 328, 158 }, { 462, 194 }};
static const XRect _Const0022 = {{ 328, 200 }, { 462, 236 }};
int password[4] = { 1, 2, 3, 4 };
int locked = 0;

/* Initializer for the class 'Application::Application' */
void ApplicationApplication__Init( ApplicationApplication _this, XObject aLink, XHandle aArg )
{
	/* At first initialize the super class ... */
	CoreRoot__Init( &_this->_Super, aLink, aArg );

	/* ... then construct all embedded objects */
	ViewsRectangle__Init( &_this->Rectangle, &_this->_XObject, 0 );
	GraphicsCanvas__Init( &_this->InputCanvas, &_this->_XObject, 0 );
	ViewsImage__Init( &_this->InputImage, &_this->_XObject, 0 );
	CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler, &_this->_XObject, 0 );
	WidgetSetPushButton__Init( &_this->PushButtonClear, &_this->_XObject, 0 );
	ViewsBorder__Init( &_this->InputBorder, &_this->_XObject, 0 );
	WidgetSetPushButton__Init( &_this->PushButtonRun, &_this->_XObject, 0 );
	ViewsImage__Init( &_this->InputImage1, &_this->_XObject, 0 );
	CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler1, &_this->_XObject, 0 );
	ViewsBorder__Init( &_this->InputBorder1, &_this->_XObject, 0 );
	ViewsImage__Init( &_this->InputImage2, &_this->_XObject, 0 );
	CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler2, &_this->_XObject, 0 );
	ViewsBorder__Init( &_this->InputBorder2, &_this->_XObject, 0 );
	ViewsImage__Init( &_this->InputImage3, &_this->_XObject, 0 );
	CoreSimpleTouchHandler__Init( &_this->SimpleInputTouchHandler3, &_this->_XObject, 0 );
	ViewsBorder__Init( &_this->InputBorder3, &_this->_XObject, 0 );
	GraphicsCanvas__Init( &_this->InputCanvas1, &_this->_XObject, 0 );
	GraphicsCanvas__Init( &_this->InputCanvas2, &_this->_XObject, 0 );
	GraphicsCanvas__Init( &_this->InputCanvas3, &_this->_XObject, 0 );
	WidgetSetPushButton__Init( &_this->LockButton, &_this->_XObject, 0 );
	ViewsText__Init( &_this->ResultsText, &_this->_XObject, 0 );
	ViewsText__Init( &_this->InfoText, &_this->_XObject, 0 );

	/* Setup the VMT pointer */
	_this->_VMT = EW_CLASS( ApplicationApplication );

	/* ... and initialize objects, variables, properties, etc. */
	CoreRectView__OnSetBounds( _this, _Const0000 );
	CoreRectView__OnSetBounds( &_this->Rectangle, _Const0000 );
	ViewsRectangle_OnSetColorBL( &_this->Rectangle, CustomConstantsbackground_color );
	ViewsRectangle_OnSetColorBR( &_this->Rectangle, CustomConstantsbackground_color );
	ViewsRectangle_OnSetColorTR( &_this->Rectangle, CustomConstantsbackground_color );
	ViewsRectangle_OnSetColorTL( &_this->Rectangle, CustomConstantsbackground_color );
	ViewsRectangle_OnSetColor( &_this->Rectangle, CustomConstantsbackground_color );
	ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas, _Const0001 );
	CoreRectView__OnSetBounds( &_this->InputImage, _Const0002 );
	CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0003 );
	CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0004 );
	CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0005 );
	CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler, _Const0006 );
	CoreRectView__OnSetBounds( &_this->PushButtonClear, _Const0007 );
	WidgetSetPushButton_OnSetLabel( &_this->PushButtonClear, EwLoadString( &_Const0008 ));
	CoreRectView__OnSetBounds( &_this->InputBorder, _Const0009 );
	ViewsBorder_OnSetColorBL( &_this->InputBorder, CustomConstantsgreen );
	ViewsBorder_OnSetColorBR( &_this->InputBorder, CustomConstantsgreen );
	ViewsBorder_OnSetColorTR( &_this->InputBorder, CustomConstantsgreen );
	ViewsBorder_OnSetColorTL( &_this->InputBorder, CustomConstantsgreen );
	ViewsBorder_OnSetColor( &_this->InputBorder, CustomConstantsgreen );
	CoreRectView__OnSetBounds( &_this->PushButtonRun, _Const000A );
	WidgetSetPushButton_OnSetLabel( &_this->PushButtonRun, EwLoadString( &_Const000B ));
	CoreRectView__OnSetBounds( &_this->InputImage1, _Const000C );
	CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const000D );
	CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const000E );
	CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const000F );
	CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler1, _Const0010 );
	CoreRectView__OnSetBounds( &_this->InputBorder1, _Const0011 );
	ViewsBorder_OnSetColorBL( &_this->InputBorder1, CustomConstantsgreen );
	ViewsBorder_OnSetColorBR( &_this->InputBorder1, CustomConstantsgreen );
	ViewsBorder_OnSetColorTR( &_this->InputBorder1, CustomConstantsgreen );
	ViewsBorder_OnSetColorTL( &_this->InputBorder1, CustomConstantsgreen );
	ViewsBorder_OnSetColor( &_this->InputBorder1, CustomConstantsgreen );
	CoreRectView__OnSetBounds( &_this->InputImage2, _Const0012 );
	CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const0013 );
	CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const0014 );
	CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const0015 );
	CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler2, _Const0016 );
	CoreRectView__OnSetBounds( &_this->InputBorder2, _Const0017 );
	ViewsBorder_OnSetColorBL( &_this->InputBorder2, CustomConstantsgreen );
	ViewsBorder_OnSetColorBR( &_this->InputBorder2, CustomConstantsgreen );
	ViewsBorder_OnSetColorTR( &_this->InputBorder2, CustomConstantsgreen );
	ViewsBorder_OnSetColorTL( &_this->InputBorder2, CustomConstantsgreen );
	ViewsBorder_OnSetColor( &_this->InputBorder2, CustomConstantsgreen );
	CoreRectView__OnSetBounds( &_this->InputImage3, _Const0018 );
	ViewsImage_OnSetColorBL( &_this->InputImage3, _Const0019 );
	ViewsImage_OnSetColorBR( &_this->InputImage3, _Const0019 );
	ViewsImage_OnSetColorTR( &_this->InputImage3, _Const0019 );
	ViewsImage_OnSetColorTL( &_this->InputImage3, _Const0019 );
	ViewsImage_OnSetColor( &_this->InputImage3, _Const0019 );
	CoreQuadView_OnSetPoint4((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const001A );
	CoreQuadView_OnSetPoint3((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const001B );
	CoreQuadView_OnSetPoint2((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const001C );
	CoreQuadView_OnSetPoint1((CoreQuadView)&_this->SimpleInputTouchHandler3, _Const001D );
	CoreRectView__OnSetBounds( &_this->InputBorder3, _Const001E );
	ViewsBorder_OnSetColorBL( &_this->InputBorder3, CustomConstantsgreen );
	ViewsBorder_OnSetColorBR( &_this->InputBorder3, CustomConstantsgreen );
	ViewsBorder_OnSetColorTR( &_this->InputBorder3, CustomConstantsgreen );
	ViewsBorder_OnSetColorTL( &_this->InputBorder3, CustomConstantsgreen );
	ViewsBorder_OnSetColor( &_this->InputBorder3, CustomConstantsgreen );
	ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas1, _Const0001 );
	ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas2, _Const0001 );
	ResourcesBitmap__OnSetFrameSize( &_this->InputCanvas3, _Const0001 );
	CoreRectView__OnSetBounds( &_this->LockButton, _Const001F );
	WidgetSetPushButton_OnSetLabel( &_this->LockButton, EwLoadString( &_Const0020 ));
	CoreRectView__OnSetBounds( &_this->ResultsText, _Const0021 );
	ViewsText_OnSetString( &_this->ResultsText, 0 );
	CoreRectView__OnSetBounds( &_this->InfoText, _Const0022 );
	ViewsText_OnSetString( &_this->InfoText, 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->Rectangle ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputImage ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->PushButtonClear ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputBorder ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->PushButtonRun ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputImage1 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler1 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputBorder1 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputImage2 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler2 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputBorder2 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputImage3 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->SimpleInputTouchHandler3 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InputBorder3 ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->LockButton ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->ResultsText ), 0 );
	CoreGroup__Add( _this, ((CoreView)&_this->InfoText ), 0 );
	ViewsImage_OnSetBitmap( &_this->InputImage, ((ResourcesBitmap)&_this->InputCanvas ));
	_this->SimpleInputTouchHandler.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag );
	_this->PushButtonClear.OnPress = EwNewSlot( _this, ApplicationApplication_onPushClear );
	WidgetSetPushButton_OnSetAppearance( &_this->PushButtonClear, EwGetAutoObject(
			&WidgetSetPushButton_Medium, WidgetSetPushButtonConfig ));
	_this->PushButtonRun.OnPress = EwNewSlot( _this, ApplicationApplication_onPushSetPass );
	WidgetSetPushButton_OnSetAppearance( &_this->PushButtonRun, EwGetAutoObject( &WidgetSetPushButton_Medium,
			WidgetSetPushButtonConfig ));
	ViewsImage_OnSetBitmap( &_this->InputImage1, ((ResourcesBitmap)&_this->InputCanvas1 ));
	_this->SimpleInputTouchHandler1.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag1 );
	ViewsImage_OnSetBitmap( &_this->InputImage2, ((ResourcesBitmap)&_this->InputCanvas2 ));
	_this->SimpleInputTouchHandler2.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag2 );
	ViewsImage_OnSetBitmap( &_this->InputImage3, ((ResourcesBitmap)&_this->InputCanvas3 ));
	_this->SimpleInputTouchHandler3.OnDrag = EwNewSlot( _this, ApplicationApplication_onDrag3 );
	CoreGroup__OnSetFocus( &_this->LockButton, 0 );
	_this->LockButton.OnLeave = EwNullSlot;
	_this->LockButton.OnEnter = EwNullSlot;
	_this->LockButton.OnPress = EwNewSlot( _this, ApplicationApplication_onPushRun );
	_this->LockButton.OnActivate = EwNullSlot;
	WidgetSetPushButton_OnSetIcon( &_this->LockButton, 0 );
	WidgetSetPushButton_OnSetAppearance( &_this->LockButton, EwGetAutoObject( &WidgetSetPushButton_Medium,
			WidgetSetPushButtonConfig ));
	ViewsText_OnSetFont( &_this->ResultsText, EwLoadResource( &ResourcesFontLarge,
			ResourcesFont ));
	ViewsText_OnSetFont( &_this->InfoText, EwLoadResource( &ResourcesFontLarge, ResourcesFont ));

	/* Call the user defined constructor */
	ApplicationApplication_Init( _this, aArg );
}

/* Re-Initializer for the class 'Application::Application' */
void ApplicationApplication__ReInit( ApplicationApplication _this )
{
	/* At first re-initialize the super class ... */
	CoreRoot__ReInit( &_this->_Super );

	/* ... then re-construct all embedded objects */
	ViewsRectangle__ReInit( &_this->Rectangle );
	GraphicsCanvas__ReInit( &_this->InputCanvas );
	ViewsImage__ReInit( &_this->InputImage );
	CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler );
	WidgetSetPushButton__ReInit( &_this->PushButtonClear );
	ViewsBorder__ReInit( &_this->InputBorder );
	WidgetSetPushButton__ReInit( &_this->PushButtonRun );
	ViewsImage__ReInit( &_this->InputImage1 );
	CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler1 );
	ViewsBorder__ReInit( &_this->InputBorder1 );
	ViewsImage__ReInit( &_this->InputImage2 );
	CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler2 );
	ViewsBorder__ReInit( &_this->InputBorder2 );
	ViewsImage__ReInit( &_this->InputImage3 );
	CoreSimpleTouchHandler__ReInit( &_this->SimpleInputTouchHandler3 );
	ViewsBorder__ReInit( &_this->InputBorder3 );
	GraphicsCanvas__ReInit( &_this->InputCanvas1 );
	GraphicsCanvas__ReInit( &_this->InputCanvas2 );
	GraphicsCanvas__ReInit( &_this->InputCanvas3 );
	WidgetSetPushButton__ReInit( &_this->LockButton );
	ViewsText__ReInit( &_this->ResultsText );
	ViewsText__ReInit( &_this->InfoText );
}

/* Finalizer method for the class 'Application::Application' */
void ApplicationApplication__Done( ApplicationApplication _this )
{
	/* Finalize this class */
	_this->_VMT = EW_CLASS( ApplicationApplication );

	/* Finalize all embedded objects */
	ViewsRectangle__Done( &_this->Rectangle );
	GraphicsCanvas__Done( &_this->InputCanvas );
	ViewsImage__Done( &_this->InputImage );
	CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler );
	WidgetSetPushButton__Done( &_this->PushButtonClear );
	ViewsBorder__Done( &_this->InputBorder );
	WidgetSetPushButton__Done( &_this->PushButtonRun );
	ViewsImage__Done( &_this->InputImage1 );
	CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler1 );
	ViewsBorder__Done( &_this->InputBorder1 );
	ViewsImage__Done( &_this->InputImage2 );
	CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler2 );
	ViewsBorder__Done( &_this->InputBorder2 );
	ViewsImage__Done( &_this->InputImage3 );
	CoreSimpleTouchHandler__Done( &_this->SimpleInputTouchHandler3 );
	ViewsBorder__Done( &_this->InputBorder3 );
	GraphicsCanvas__Done( &_this->InputCanvas1 );
	GraphicsCanvas__Done( &_this->InputCanvas2 );
	GraphicsCanvas__Done( &_this->InputCanvas3 );
	WidgetSetPushButton__Done( &_this->LockButton );
	ViewsText__Done( &_this->ResultsText );
	ViewsText__Done( &_this->InfoText );

	/* Don't forget to deinitialize the super class ... */
	CoreRoot__Done( &_this->_Super );
}

/* The method Init() is invoked automatically after the component has been created. 
   This method can be overridden and filled with logic containing additional initialization 
   statements. */
void ApplicationApplication_Init( ApplicationApplication _this, XHandle aArg )
{
	/* Dummy expressions to avoid the 'C' warning 'unused argument'. */
	EW_UNUSED_ARG( aArg );

	GraphicsCanvas_FillRectangle( &_this->InputCanvas, EwGetRectORect( _this->InputImage.Super1.Bounds ),
			EwGetRectORect( _this->InputImage.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );
	GraphicsCanvas_FillRectangle( &_this->InputCanvas1, EwGetRectORect( _this->InputImage1.Super1.Bounds ),
			EwGetRectORect( _this->InputImage1.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );
	GraphicsCanvas_FillRectangle( &_this->InputCanvas2, EwGetRectORect( _this->InputImage2.Super1.Bounds ),
			EwGetRectORect( _this->InputImage2.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );
	GraphicsCanvas_FillRectangle( &_this->InputCanvas3, EwGetRectORect( _this->InputImage3.Super1.Bounds ),
			EwGetRectORect( _this->InputImage3.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );
	CoreView__ChangeViewState( &_this->PushButtonClear, CoreViewStateEnabled, CoreViewStateFocused );
	CoreView__ChangeViewState( &_this->PushButtonRun, CoreViewStateEnabled, CoreViewStateFocused );
}

/* Draws a while a user drags their finger across the touch screen */
void ApplicationApplication_onDrag( ApplicationApplication _this, XObject sender )
{
	/* Dummy expressions to avoid the 'C' warning 'unused argument'. */
	EW_UNUSED_ARG( sender );

	GraphicsCanvas_DrawLine( &_this->InputCanvas, EwGetRectORect( _this->InputImage.Super1.Bounds ),
			EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler.CurrentPos, _this->SimpleInputTouchHandler.Offset ),
					_this->InputImage.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler.CurrentPos,
							_this->InputImage.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color,
							1 );
	EwNotifyObjObservers((XObject)&_this->InputCanvas, 0 );
}

/* Clears the input and result areas */
void ApplicationApplication_onPushClear( ApplicationApplication _this, XObject sender )
{
	/* Dummy expressions to avoid the 'C' warning 'unused argument'. */
	EW_UNUSED_ARG( sender );

	GraphicsCanvas_FillRectangle( &_this->InputCanvas, EwGetRectORect( _this->InputImage.Super1.Bounds ),
			EwGetRectORect( _this->InputImage.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );
	GraphicsCanvas_FillRectangle( &_this->InputCanvas1, EwGetRectORect( _this->InputImage1.Super1.Bounds ),
			EwGetRectORect( _this->InputImage1.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );
	GraphicsCanvas_FillRectangle( &_this->InputCanvas2, EwGetRectORect( _this->InputImage2.Super1.Bounds ),
			EwGetRectORect( _this->InputImage2.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );
	GraphicsCanvas_FillRectangle( &_this->InputCanvas3, EwGetRectORect( _this->InputImage3.Super1.Bounds ),
			EwGetRectORect( _this->InputImage3.Super1.Bounds ), CustomConstantsbackground_color,
			CustomConstantsbackground_color, CustomConstantsbackground_color, CustomConstantsbackground_color,
			0 );

	CoreGroup__InvalidateArea( _this, _this->InputImage.Super1.Bounds );
	CoreGroup__InvalidateArea( _this, _this->InputImage1.Super1.Bounds );
	CoreGroup__InvalidateArea( _this, _this->InputImage2.Super1.Bounds );
	CoreGroup__InvalidateArea( _this, _this->InputImage3.Super1.Bounds );

	ViewsText_OnSetString( &_this->InfoText, 0 );
	ViewsText_OnSetString( &_this->ResultsText, 0 );
}

void ProcessInput( ApplicationApplication _this, int *input_code )
{
	XHandle tmp;
	XHandle tmp1;
	XHandle tmp2;
	XHandle tmp3;
	XRect aArea;
	XRect aArea1;
	XRect aArea2;
	XRect aArea3;
	XInt32 width;
	XInt32 height;
	XColor main_color;

	tmp = _this->InputCanvas.Super1.bitmap;
	tmp1 = _this->InputCanvas1.Super1.bitmap;
	tmp2 = _this->InputCanvas2.Super1.bitmap;
	tmp3 = _this->InputCanvas3.Super1.bitmap;

	aArea = EwGetRectORect( _this->InputImage.Super1.Bounds );
	aArea1 = EwGetRectORect( _this->InputImage1.Super1.Bounds );
	aArea2 = EwGetRectORect( _this->InputImage2.Super1.Bounds );
	aArea3 = EwGetRectORect( _this->InputImage3.Super1.Bounds );

	width = aArea.Point2.X - aArea.Point1.X;
	height = aArea.Point2.Y - aArea.Point1.Y;
	main_color = CustomConstantsmain_color; // the color used for drawing, text and borders

	XBitmap* bitmap = (XBitmap*)tmp;
	XBitmap* bitmap1 = (XBitmap*)tmp1;
	XBitmap* bitmap2 = (XBitmap*)tmp2;
	XBitmap* bitmap3 = (XBitmap*)tmp3;

	/* The color is stored in an embedded wizard structure and needs to be converted
	   into an integer so that it can be compared to the stored color values
	   in the memory. The stored color format is 0xAARRGGBB, where A stands for Alpha,
	   R for red, G for green and B for blue. */
	uint32_t drawing_colorINT = ((uint32_t) main_color.Alpha) << 24 |((uint32_t) main_color.Red) << 16 | ((uint32_t) main_color.Green) << 8 | ((uint32_t) main_color.Blue);

	XBitmapLock* lock = EwLockBitmap(bitmap, 0, aArea, 1, 0);
	XBitmapLock* lock1 = EwLockBitmap(bitmap1, 0, aArea1, 1, 0);
	XBitmapLock* lock2 = EwLockBitmap(bitmap2, 0, aArea2, 1, 0);
	XBitmapLock* lock3 = EwLockBitmap(bitmap3, 0, aArea3, 1, 0);

	uint32_t* src   = (uint32_t*)lock->Pixel1;
	uint32_t* src1   = (uint32_t*)lock1->Pixel1;
	uint32_t* src2   = (uint32_t*)lock2->Pixel1;
	uint32_t* src3   = (uint32_t*)lock3->Pixel1;

	int ofs = ( lock->Pitch1Y / 4 ) - width; // offset between rows (to skip irrelevant pixels on each row)
	int ofs1 = ( lock1->Pitch1Y / 4 ) - width;
	int ofs2 = ( lock2->Pitch1Y / 4 ) - width;
	int ofs3 = ( lock3->Pitch1Y / 4 ) - width;

	int *result_array = NULL;

	uint8_t *bmp = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp1 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp2 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);
	uint8_t *bmp3 = (uint8_t*) malloc(sizeof(uint8_t) * width * height);

	if (bmp == NULL || bmp1 == NULL || bmp2 == NULL || bmp3 == NULL)
	{
		EwPrint("Out of memory!\n\r");
		return;
	}

	for (int i = 0; i < width * height; i++)
	{
		bmp[i] = 0;
		bmp1[i] = 0;
		bmp2[i] = 0;
		bmp3[i] = 0;
	}

	for (int y = 0; y < height; y++, src += ofs, src1 += ofs1, src2 += ofs2, src3 += ofs3 )
	{
		for (int x = 0; x < width; x++, src++, src1++, src2++, src3++ )
		{
			/* <drawing_color> colored pixel and its 8 neighboring pixels are stored as 0xFF bytes
			 (the input line is thickened so that it retains more detail when the input image gets
			 scaled from 112x112 down to 28x28 so that it has the same size as the MNIST images).
			 All the other pixels are stored as 0x00. Since the MNIST dataset contains single-channel
			 greyscale images, feeding the trained model single-channel black and white images
			 created this way works as well. */
			if (*src == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}

			if (*src1 == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp1[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp1[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp1[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp1[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp1[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp1[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp1[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp1[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp1[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp1[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp1[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}

			if (*src2 == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp2[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp2[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp2[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp2[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp2[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp2[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp2[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp2[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp2[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp2[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp2[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}

			if (*src3 == drawing_colorINT)
			{
				/* -- 0 -- */
				bmp3[x + y*width] = 0xFF;


				/* -- 1 -- */
				/*
				 X 0 0
				 0 1 0
				 0 0 0
				 */
				if (((x - 1) > 0) && ((y - 1) > 0))
				{
					bmp3[(x - 1) + (y - 1)  * width] = 0xFF;
				}

				/*
				 0 0 0
				 X 1 0
				 0 0 0
				 */
				if ((x - 1) > 0)
				{
					bmp3[(x - 1) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 X 0 0
				 */
				if (((x - 1) > 0) && ((y + 1) < height))
				{
					bmp3[(x - 1) + (y + 1) * width] = 0xFF;
				}

				/*
				 0 X 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 1) > 0)
				{
					bmp3[x + (y - 1) * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 X 0
				 0 0 0
				 0 1 0
				 0 0 0
				 */
				if ((y - 2) > 0)
				{
					bmp3[x + (y - 2) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 X 0
				 */
				if ((y + 1) < height)
				{
					bmp3[x + (y + 1) * width] = 0xFF;
				}

				/*
				 0 0 X
				 0 1 0
				 0 0 0
				 */
				if (((x + 1) < width) && ((y - 1) > 0))
				{
					bmp3[(x + 1) + (y - 1) * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 X
				 0 0 0
				 */
				if ((x + 1) < width)
				{
					bmp3[(x + 1) + y * width] = 0xFF;
				}

				/*
				 * The image will be scaled down 4 times at most. By adding a 4th pixel,
				 * the line can never be fully skipped and removed by the scaling algorithm.
				 0 0 0 0
				 0 1 0 X
				 0 0 0 0
				 */
				if ((x + 2) < width)
				{
					bmp3[(x + 2) + y * width] = 0xFF;
				}

				/*
				 0 0 0
				 0 1 0
				 0 0 X
				 */
				if (((x + 1) < width) && ((y + 1) < height))
				{
					bmp3[(x + 1) + (y + 1) * width] = 0xFF;
				}
			}
		}
	}

	result_array = processImage(bmp, width, height);
	input_code[0] = result_array[1];
	free(result_array);
	result_array = NULL;

	result_array = processImage(bmp1, width, height);
	input_code[1] = result_array[1];
	free(result_array);
	result_array = NULL;

	result_array = processImage(bmp2, width, height);
	input_code[2] = result_array[1];
	free(result_array);
	result_array = NULL;

	result_array = processImage(bmp3, width, height);
	input_code[3] = result_array[1];
	free(result_array);
	result_array = NULL;

	free(bmp);
	free(bmp1);
	free(bmp2);
	free(bmp3);

	EwUnlockBitmap(lock);
	EwUnlockBitmap(lock1);
	EwUnlockBitmap(lock2);
	EwUnlockBitmap(lock3);
}

/* Runs inference on the drawn symbol inside the input area */
void ApplicationApplication_onPushRun( ApplicationApplication _this, XObject sender )
{
	if (!locked)
	{
		locked = 1;
		ViewsText_OnSetString( &_this->InfoText, 0 );
		ViewsText_OnSetString( &_this->ResultsText, 0 );
		WidgetSetPushButton_OnSetLabel( &_this->LockButton, EwLoadString( &CustomConstantsunlock_string ));
		ViewsBorder_OnSetColor( &_this->InputBorder, CustomConstantsred );
		ViewsBorder_OnSetColor( &_this->InputBorder1, CustomConstantsred );
		ViewsBorder_OnSetColor( &_this->InputBorder2, CustomConstantsred );
		ViewsBorder_OnSetColor( &_this->InputBorder3, CustomConstantsred );
		return;
	}


	{
		int input_code[4];
		ProcessInput( _this, input_code );

		char input_code_string[5];
		int correct = 1;
		for (int i = 0; i < 4; i++ )
		{
			if (!(input_code[i] == password[i]))
			{
				correct = 0;
			}

			input_code_string[i] = (char) (input_code[i] + 48); // 48 is the ASCII decimal value of 0
		}
		input_code_string[4] = '\0';


		/* Printing out the result into the result area */
		ViewsText_OnSetString(&_this->ResultsText, EwNewStringAnsi(input_code_string));

		if (correct)
		{
			ViewsText_OnSetString( &_this->InfoText, EwLoadString( &CustomConstantscorrect_string ));
			ViewsText_OnSetColor( &_this->InfoText, CustomConstantsgreen );
			locked = 0;
			WidgetSetPushButton_OnSetLabel( &_this->LockButton, EwLoadString( &CustomConstantslock_string ));
			ViewsBorder_OnSetColor( &_this->InputBorder, CustomConstantsgreen );
			ViewsBorder_OnSetColor( &_this->InputBorder1, CustomConstantsgreen );
			ViewsBorder_OnSetColor( &_this->InputBorder2, CustomConstantsgreen );
			ViewsBorder_OnSetColor( &_this->InputBorder3, CustomConstantsgreen );
		}
		else
		{
			ViewsText_OnSetString( &_this->InfoText, EwLoadString( &CustomConstantswrong_string ));
			ViewsText_OnSetColor( &_this->InfoText, CustomConstantsred );
		}
	}
}

/* This is a slot method. */
void ApplicationApplication_onDrag1( ApplicationApplication _this, XObject sender )
{
	/* Dummy expressions to avoid the 'C' warning 'unused argument'. */
	EW_UNUSED_ARG( sender );

	GraphicsCanvas_DrawLine( &_this->InputCanvas1, EwGetRectORect( _this->InputImage1.Super1.Bounds ),
			EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler1.CurrentPos, _this->SimpleInputTouchHandler1.Offset ),
					_this->InputImage1.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler1.CurrentPos,
							_this->InputImage1.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color,
							1 );
	EwNotifyObjObservers((XObject)&_this->InputCanvas1, 0 );
}

/* This is a slot method. */
void ApplicationApplication_onDrag2( ApplicationApplication _this, XObject sender )
{
	/* Dummy expressions to avoid the 'C' warning 'unused argument'. */
	EW_UNUSED_ARG( sender );

	GraphicsCanvas_DrawLine( &_this->InputCanvas2, EwGetRectORect( _this->InputImage2.Super1.Bounds ),
			EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler2.CurrentPos, _this->SimpleInputTouchHandler2.Offset ),
					_this->InputImage2.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler2.CurrentPos,
							_this->InputImage2.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color,
							1 );
	EwNotifyObjObservers((XObject)&_this->InputCanvas2, 0 );
}

/* This is a slot method. */
void ApplicationApplication_onDrag3( ApplicationApplication _this, XObject sender )
{
	/* Dummy expressions to avoid the 'C' warning 'unused argument'. */
	EW_UNUSED_ARG( sender );

	GraphicsCanvas_DrawLine( &_this->InputCanvas3, EwGetRectORect( _this->InputImage3.Super1.Bounds ),
			EwMovePointNeg( EwMovePointNeg( _this->SimpleInputTouchHandler3.CurrentPos, _this->SimpleInputTouchHandler3.Offset ),
					_this->InputImage3.Super1.Bounds.Point1 ), EwMovePointNeg( _this->SimpleInputTouchHandler3.CurrentPos,
							_this->InputImage3.Super1.Bounds.Point1 ), CustomConstantsmain_color, CustomConstantsmain_color,
							1 );
	EwNotifyObjObservers((XObject)&_this->InputCanvas3, 0 );
}

/* 'C' function for method : 'Application::Application.onPushSetPass()' */
void ApplicationApplication_onPushSetPass( ApplicationApplication _this, XObject 
		sender )
{
	/* Dummy expressions to avoid the 'C' warning 'unused argument'. */
	EW_UNUSED_ARG( sender );

	ProcessInput( _this, password );

	char input_code_string[5];
	for (int i = 0; i < 4; i++ )
	{
		input_code_string[i] = (char) (password[i] + 48); // 48 is the ASCII decimal value of 0
	}
	input_code_string[4] = '\0';

	/* Printing out the result into the result area */
	ViewsText_OnSetString(&_this->ResultsText, EwNewStringAnsi(input_code_string));
	ViewsText_OnSetString( &_this->InfoText, EwLoadString( &CustomConstantspass_string ));
	ViewsText_OnSetColor( &_this->InfoText, CustomConstantsmain_color );
}

/* Variants derived from the class : 'Application::Application' */
EW_DEFINE_CLASS_VARIANTS( ApplicationApplication )
EW_END_OF_CLASS_VARIANTS( ApplicationApplication )

/* Virtual Method Table (VMT) for the class : 'Application::Application' */
EW_DEFINE_CLASS( ApplicationApplication, CoreRoot, Rectangle, Rectangle, Rectangle, 
		Rectangle, _None, "Application::Application" )
		CoreRectView_initLayoutContext,
		CoreRoot_GetRoot,
		CoreRoot_Draw,
		CoreView_HandleEvent,
		CoreGroup_CursorHitTest,
		CoreRectView_ArrangeView,
		CoreRectView_MoveView,
		CoreRectView_GetExtent,
		CoreRoot_ChangeViewState,
		CoreGroup_OnSetBounds,
		CoreRoot_OnSetFocus,
		CoreRoot_DispatchEvent,
		CoreRoot_BroadcastEvent,
		CoreGroup_UpdateViewState,
		CoreRoot_InvalidateArea,
		CoreRoot_RestackBehind,
		CoreRoot_RestackTop,
		CoreRoot_Restack,
		CoreRoot_Add,
		EW_END_OF_CLASS( ApplicationApplication )

		/* Embedded Wizard */
