#if 1
/*
 *  TCP/IP or UDP/IP networking functions
 *
 *  Copyright (C) 2006-2015, ARM Limited, All Rights Reserved
 *  SPDX-License-Identifier: Apache-2.0
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"); you may
 *  not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 *  WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *  This file is part of mbed TLS (https://tls.mbed.org)
 */

#if !defined(MBEDTLS_CONFIG_FILE)
#include "mbedtls/config.h"
#else
#include MBEDTLS_CONFIG_FILE
#endif

#if 1//defined(MBEDTLS_NET_C)

#include "mbedtls/net.h"
#include "mqtt.h"
#include <string.h>
#include "qcom_api.h"


/* Some MS functions want int and MSVC warns if we pass size_t,
 * but the standard fucntions use socklen_t, so cast only for MSVC */
#if defined(_MSC_VER)
#define MSVC_INT_CAST   (int)
#else
#define MSVC_INT_CAST
#endif

#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <stdint.h>
#include "RNG1.h"


int mbedtls_net_incoming(void *ctx, unsigned char *buf, size_t len) {
  (void)ctx; /* not used */
  RNG1_Putn(buf, len);
  //PRINTF("mbedtls_net_incoming: put nof bytes: %d, free: %d\r\n", len, (int)RNG1_NofFreeElements());
  return 0;
}

/*
 * Read at most 'len' characters
 */
int mbedtls_net_recv( void *ctx, unsigned char *buf, size_t len )
{
//    struct mqtt_client_t *context;

//    context = (struct mqtt_client_t *)ctx;
//    if(context->conn == NULL) {
//      return( MBEDTLS_ERR_NET_INVALID_CONTEXT );
//    }
		
		if (tls_tcp_recv_polling() == 0){
			vTaskDelay(MSEC_TO_TICK(20));
			tls_tcp_recv_polling();
		}
    if (RNG1_NofElements()>=len) {
      //PRINTF("mbedtls_net_recv: requested nof: %d, available %d\r\n", len, (int)RNG1_NofElements());
      if (RNG1_Getn(buf, len)==ERR_OK) {
        return len; /* ok */
      }
    }
    return 0; /* nothing read */
}

/*
 * Write at most 'len' characters
 */
extern SOCKADDR_T brokeraddr;
extern mqtt_pal_socket_handle  sockfd;
int mbedtls_net_send( void *ctx, const unsigned char *buf, size_t len )
{
		size_t sent = 0;
		ctx = ctx;
    while(sent < len) {
				//ssize_t tmp = send(fd, buf + sent, len - sent, flags);
				char * sendBuf = custom_alloc( len - sent );
				if( sendBuf == NULL )
				{
						return -1;
				}
				memcpy( sendBuf, buf + sent, len - sent );
				//ssize_t tmp = qcom_sendto(fd, buf + sent, len - sent, flags,(struct sockaddr *)&brokeraddr, sizeof(brokeraddr));
        ssize_t tmp = qcom_send(sockfd, sendBuf, len - sent, 0);
				custom_free( sendBuf );
				if (tmp < 1) {
            return MQTT_ERROR_SOCKET_ERROR;
        }
        sent += (size_t) tmp;
    }
    return sent;
}


ssize_t tls_tcp_recv_polling(void)
{
//			const void *const start = buf;
//		char *p = (char*)buf;
		unsigned char *recvbuff = NULL;
    A_STATUS status;	
    ssize_t rv = 0;
    do {
				QCA_CONTEXT_STRUCT *enetCtx = wlan_get_context();
				status = (A_STATUS)t_select(enetCtx, sockfd, 0);
				if(status == A_ERROR){
					return rv;
				} 
				rv = qcom_recvfrom(sockfd, &recvbuff, 1500, 0,(struct sockaddr *)&brokeraddr, sizeof(brokeraddr));
				//rv = qcom_recv(sockfd, recvbuff, 1500, 0);
        if (rv > 0) {
            /* successfully read bytes from the socket */
						mbedtls_net_incoming(NULL, recvbuff, rv);
        }
				/* Free RxBuffer */
				if (NULL != recvbuff)
				{
						zero_copy_free(recvbuff);
						recvbuff = NULL;
				}
    } while (rv > 0);

    return rv;
}
#endif /* MBEDTLS_NET_C */

#endif
