/* led.c */
#include "led.h"

#include "fsl_power.h"
#include "fsl_gpio.h"
#include "fsl_swm.h"
#include "fsl_iocon.h"

/* for g board. */
//const uint8_t led_gpio_pins[LED_COUNT] = { 20u, 15u, 1u, 9u, 8u, 30u, 7u };
const uint8_t led_gpio_pins[LED_COUNT] = { 7u, 12u, 19u, 20u, 14u, 15u, 0u };
void led_init(void)
{
    /* enable clocks. */
    CLOCK_EnableClock(kCLOCK_Iocon);
    CLOCK_EnableClock(kCLOCK_Swm);
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* iocon. */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_20, 0); /*  */
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_15, 0);
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_1, 0);
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_9, 0);
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_8, 0);
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_30, 0);
    IOCON_PinMuxSet(IOCON, IOCON_INDEX_PIO0_7, 0);

    /* swm. no setting for gpio.*/

    gpio_pin_config_t gpio_pin_config;

    gpio_pin_config.pinDirection =kGPIO_DigitalOutput;
    gpio_pin_config.outputLogic = 1u;

    for (uint8_t i = 0u; i < LED_COUNT; i++)
    {
        GPIO_PinInit(GPIO, 0u, led_gpio_pins[i], &gpio_pin_config);
    }
}

void led_on(uint8_t mask)
{
    for (uint8_t i = 0u; i < LED_COUNT; i++)
    {
        if (0u != ((1u << i) & mask) )
        {
            GPIO_PinWrite(GPIO, 0u, led_gpio_pins[i], 0u);
        }
    }
}

void led_off(uint8_t mask)
{
    for (uint8_t i = 0u; i < LED_COUNT; i++)
    {
        if (0u != ((1u << i) & mask) )
        {
            GPIO_PinWrite(GPIO, 0u, led_gpio_pins[i], 1u);
        }
    }
}

/* EOF. */

