/* touch.h */
#ifndef __TOUCH_H__
#define __TOUCH_H__

#include "fsl_common.h"

#define TOUCH_ENABLE_VAL_ADJ 0

#define TOUCH_USER_CHANNEL_NUM  5 /* how many channels would be used in application. */

#if 0
typedef struct
{
    int   num_chn; /* how many channel would be used in a same time. */
    int * val_chn; /* sensing values. */
} touch_data_handler_t;

/* all the APIs would return the error code. 0-succ. */
int touch_calibration(touch_data_handler_t *handler, int err_threshold);
int touch_get_position(touch_data_handler_t *handler, int * pos_x);
void touch_calibration_update(touch_data_handler_t *handler);
#endif

void touch_init(void);
void touch_start(void);
void touch_wait_data_ready(int16_t *output);

uint16_t touch_calib(int16_t * input);
void touch_calib_update(int16_t *input);
bool touch_verify(int16_t *input, int max_offset);

typedef enum
{
    eTouch_GetPosErr_YesTouch = 0,
    eTouch_GetPosErr_NoTouch = 1,
    eTouch_GetPosErr_Noise = 2,
    eTouch_GetPosErr_UnKnown = 3,
} touch_get_pos_err_t;
touch_get_pos_err_t touch_get_pos(int16_t * val_raw, uint32_t pos_range, int32_t * pos);

/* iir filter. */
void touch_iir_filter_init(int16_t *input);
void touch_iir_filter_process(int16_t *input, int16_t *output);

/* value. */


#endif /* __TOUCH_H__ */

