/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2019, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_INPUTMUX_CONNECTIONS_
#define _FSL_INPUTMUX_CONNECTIONS_

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* Component ID definition, used by tools. */
#ifndef FSL_COMPONENT_ID
#define FSL_COMPONENT_ID "platform.drivers.inputmux_connections"
#endif

/*!
 * @addtogroup inputmux_driver
 * @{
 */

/*! @brief Periphinmux IDs */
#define SCT0_PMUX_ID 0x00U
#define SHSGPIO_PMUX_ID 0x80U
#define PINTSEL_PMUX_ID 0x100U
#define DSP_INT_PMUX_ID 0x140U
#define DMA0_ITRIG_PMUX_ID 0x200U
#define DMA0_OTRIG_PMUX_ID 0x300U
#define DMA1_ITRIG_PMUX_ID 0x400U
#define DMA1_OTRIG_PMUX_ID 0x500U
#define CT32BIT0_CAP_PMUX_ID 0x600U
#define CT32BIT1_CAP_PMUX_ID 0x610U
#define CT32BIT2_CAP_PMUX_ID 0x620U
#define CT32BIT3_CAP_PMUX_ID 0x630U
#define CT32BIT4_CAP_PMUX_ID 0x640U
#define FREQMEAS_PMUX_ID 0x700U
#define DMA0_REQ_ENA0_ID 0x740U
#define DMA1_REQ_ENA0_ID 0x760U
#define DMA0_ITRIG_EN0_ID 0x780U
#define DMA1_ITRIG_EN0_ID 0x7A0U
#define ENA_SHIFT 8U
#define PMUX_SHIFT 20U

/*! @brief INPUTMUX connections type */
typedef enum _inputmux_connection_t
{
    /*!< SCT INMUX. */
    kINPUTMUX_Sct0PinInp0ToSct0     = 0U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0PinInp1ToSct0     = 1U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0PinInp2ToSct0     = 2U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0PinInp3ToSct0     = 3U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0PinInp4ToSct0     = 4U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0PinInp5ToSct0     = 5U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0PinInp6ToSct0     = 6U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0PinInp7ToSct0     = 7U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0Mat0ToSct0     = 8U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1Mat0ToSct0     = 9U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2Mat0ToSct0     = 10U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3Mat0ToSct0     = 11U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer4Mat0ToSct0     = 12U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_AdcIrqToSct0          = 13U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioIntBmatchToSct0   = 14U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Usb1FrameToggleToSct0 = 15U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Cmp0OutToSct0         = 16U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0SclkToSct0  = 17U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1SclkToSct0  = 18U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToSct0    = 19U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToSct0    = 20U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_MclkToSct0            = 21U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_ArmTxevToSct0         = 22U + (SCT0_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_DebugHaltedToSct0     = 23U + (SCT0_PMUX_ID << PMUX_SHIFT),

    /*!< Pin Interrupt. */
    kINPUTMUX_GpioPort0Pin0ToPintsel  = 0U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin1ToPintsel  = 1U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin2ToPintsel  = 2U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin3ToPintsel  = 3U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin4ToPintsel  = 4U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin5ToPintsel  = 5U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin6ToPintsel  = 6U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin7ToPintsel  = 7U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin8ToPintsel  = 8U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin9ToPintsel  = 9U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin10ToPintsel = 10U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin11ToPintsel = 11U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin12ToPintsel = 12U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin13ToPintsel = 13U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin14ToPintsel = 14U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin15ToPintsel = 15U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin16ToPintsel = 16U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin17ToPintsel = 17U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin18ToPintsel = 18U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin19ToPintsel = 19U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin20ToPintsel = 20U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin21ToPintsel = 21U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin22ToPintsel = 22U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin23ToPintsel = 23U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin24ToPintsel = 24U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin25ToPintsel = 25U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin26ToPintsel = 26U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin27ToPintsel = 27U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin28ToPintsel = 28U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin29ToPintsel = 29U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin30ToPintsel = 30U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort0Pin31ToPintsel = 31U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin0ToPintsel  = 32U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin1ToPintsel  = 33U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin2ToPintsel  = 34U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin3ToPintsel  = 35U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin4ToPintsel  = 36U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin5ToPintsel  = 37U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin6ToPintsel  = 38U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin7ToPintsel  = 39U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin8ToPintsel  = 40U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin9ToPintsel  = 41U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin10ToPintsel = 42U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin11ToPintsel = 43U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin12ToPintsel = 44U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin13ToPintsel = 45U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin14ToPintsel = 46U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin15ToPintsel = 47U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin16ToPintsel = 48U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin17ToPintsel = 49U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin18ToPintsel = 50U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin19ToPintsel = 51U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin20ToPintsel = 52U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin21ToPintsel = 53U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin22ToPintsel = 54U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin23ToPintsel = 55U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin24ToPintsel = 56U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin25ToPintsel = 57U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin26ToPintsel = 58U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin27ToPintsel = 59U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin28ToPintsel = 60U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin29ToPintsel = 61U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin30ToPintsel = 62U + (PINTSEL_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioPort1Pin31ToPintsel = 63U + (PINTSEL_PMUX_ID << PMUX_SHIFT),

    /*!< DSP Interrupt. */
    kINPUTMUX_Flexcomm0ToDspInterrupt    = 0U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm1ToDspInterrupt    = 1U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm2ToDspInterrupt    = 2U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm3ToDspInterrupt    = 3U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm4ToDspInterrupt    = 4U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm5ToDspInterrupt    = 5U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm6ToDspInterrupt    = 6U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Flexcomm7ToDspInterrupt    = 7U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt0ToDspInterrupt     = 8U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt1ToDspInterrupt     = 9U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt2ToDspInterrupt     = 10U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt3ToDspInterrupt     = 11U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt4ToDspInterrupt     = 12U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt5ToDspInterrupt     = 13U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt6ToDspInterrupt     = 14U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_GpioInt7ToDspInterrupt     = 15U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsHsGpioInt0ToDspInterrupt = 16U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsHsGpioInt1ToDspInterrupt = 17U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Wdt1ToDspInterrupt         = 18U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dmac0ToDspInterrupt        = 19U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dmac1ToDspInterrupt        = 20U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_MuBToDspInterrupt          = 21U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Utick0ToDspInterrupt       = 22U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Mrt0ToDspInterrupt         = 23U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_OsEventTimerToDspInterrupt = 24U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0ToDspInterrupt      = 25U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1ToDspInterrupt      = 26U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2ToDspInterrupt      = 27U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3ToDspInterrupt      = 28U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer4ToDspInterrupt      = 29U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_RtcToDspInterrupt          = 30U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_I3c0ToDspInterrupt         = 31U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dmic0ToDspInterrupt        = 32U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Hwvad0ToDspInterrupt       = 33U + (DSP_INT_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiToDspInterrupt      = 34U + (DSP_INT_PMUX_ID << PMUX_SHIFT),

    /*!< Frequency measure. */
    kINPUTMUX_XtalinToFreqmeas        = 0U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SfroToFreqmeas          = 1U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FfroToFreqmeas          = 2U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_LposcToFreqmeas         = 3U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Rtc32KhzOscToFreqmeas   = 4U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_MainSysClkToFreqmeas    = 5U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FreqmeGpioClkToFreqmeas = 6U + (FREQMEAS_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier0 capture input mux. */
    kINPUTMUX_CtInp0ToTimer0CaptureChannels          = 0U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp1ToTimer0CaptureChannels          = 1U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp2ToTimer0CaptureChannels          = 2U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp3ToTimer0CaptureChannels          = 3U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp4ToTimer0CaptureChannels          = 4U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp5ToTimer0CaptureChannels          = 5U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp6ToTimer0CaptureChannels          = 6U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp7ToTimer0CaptureChannels          = 7U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp8ToTimer0CaptureChannels          = 8U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp9ToTimer0CaptureChannels          = 9U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp10ToTimer0CaptureChannels         = 10U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp11ToTimer0CaptureChannels         = 11U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp12ToTimer0CaptureChannels         = 12U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp13ToTimer0CaptureChannels         = 13U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp14ToTimer0CaptureChannels         = 14U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp15ToTimer0CaptureChannels         = 15U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer0CaptureChannels    = 16U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer0CaptureChannels    = 17U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Usb1FrameToggleToTimer0CaptureChannels = 18U + (CT32BIT0_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier1 capture input mux. */
    kINPUTMUX_CtInp0ToTimer1CaptureChannels          = 0U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp1ToTimer1CaptureChannels          = 1U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp2ToTimer1CaptureChannels          = 2U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp3ToTimer1CaptureChannels          = 3U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp4ToTimer1CaptureChannels          = 4U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp5ToTimer1CaptureChannels          = 5U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp6ToTimer1CaptureChannels          = 6U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp7ToTimer1CaptureChannels          = 7U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp8ToTimer1CaptureChannels          = 8U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp9ToTimer1CaptureChannels          = 9U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp10ToTimer1CaptureChannels         = 10U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp11ToTimer1CaptureChannels         = 11U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp12ToTimer1CaptureChannels         = 12U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp13ToTimer1CaptureChannels         = 13U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp14ToTimer1CaptureChannels         = 14U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp15ToTimer1CaptureChannels         = 15U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer1CaptureChannels    = 16U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer1CaptureChannels    = 17U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Usb1FrameToggleToTimer1CaptureChannels = 18U + (CT32BIT1_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier2 capture input mux. */
    kINPUTMUX_CtInp0ToTimer2CaptureChannels          = 0U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp1ToTimer2CaptureChannels          = 1U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp2ToTimer2CaptureChannels          = 2U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp3ToTimer2CaptureChannels          = 3U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp4ToTimer2CaptureChannels          = 4U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp5ToTimer2CaptureChannels          = 5U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp6ToTimer2CaptureChannels          = 6U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp7ToTimer2CaptureChannels          = 7U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp8ToTimer2CaptureChannels          = 8U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp9ToTimer2CaptureChannels          = 9U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp10ToTimer2CaptureChannels         = 10U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp11ToTimer2CaptureChannels         = 11U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp12ToTimer2CaptureChannels         = 12U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp13ToTimer2CaptureChannels         = 13U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp14ToTimer2CaptureChannels         = 14U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp15ToTimer2CaptureChannels         = 15U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer2CaptureChannels    = 16U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer2CaptureChannels    = 17U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Usb1FrameToggleToTimer2CaptureChannels = 18U + (CT32BIT2_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier3 capture input mux. */
    kINPUTMUX_CtInp0ToTimer3CaptureChannels          = 0U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp1ToTimer3CaptureChannels          = 1U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp2ToTimer3CaptureChannels          = 2U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp3ToTimer3CaptureChannels          = 3U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp4ToTimer3CaptureChannels          = 4U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp5ToTimer3CaptureChannels          = 5U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp6ToTimer3CaptureChannels          = 6U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp7ToTimer3CaptureChannels          = 7U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp8ToTimer3CaptureChannels          = 8U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp9ToTimer3CaptureChannels          = 9U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp10ToTimer3CaptureChannels         = 10U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp11ToTimer3CaptureChannels         = 11U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp12ToTimer3CaptureChannels         = 12U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp13ToTimer3CaptureChannels         = 13U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp14ToTimer3CaptureChannels         = 14U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp15ToTimer3CaptureChannels         = 15U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer3CaptureChannels    = 16U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer3CaptureChannels    = 17U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Usb1FrameToggleToTimer3CaptureChannels = 18U + (CT32BIT3_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< CTmier4 capture input mux. */
    kINPUTMUX_CtInp0ToTimer4CaptureChannels          = 0U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp1ToTimer4CaptureChannels          = 1U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp2ToTimer4CaptureChannels          = 2U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp3ToTimer4CaptureChannels          = 3U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp4ToTimer4CaptureChannels          = 4U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp5ToTimer4CaptureChannels          = 5U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp6ToTimer4CaptureChannels          = 6U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp7ToTimer4CaptureChannels          = 7U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp8ToTimer4CaptureChannels          = 8U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp9ToTimer4CaptureChannels          = 9U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp10ToTimer4CaptureChannels         = 10U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp11ToTimer4CaptureChannels         = 11U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp12ToTimer4CaptureChannels         = 12U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp13ToTimer4CaptureChannels         = 13U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp14ToTimer4CaptureChannels         = 14U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_CtInp15ToTimer4CaptureChannels         = 15U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s0WsToTimer4CaptureChannels    = 16U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_SharedI2s1WsToTimer4CaptureChannels    = 17U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Usb1FrameToggleToTimer4CaptureChannels = 18U + (CT32BIT4_CAP_PMUX_ID << PMUX_SHIFT),

    /*!< DMA0 ITRIG. */
    kINPUTMUX_NsGpioPint0Int0ToDma0 = 0U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint0Int1ToDma0 = 1U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint0Int2ToDma0 = 2U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint0Int3ToDma0 = 3U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma0       = 4U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma0       = 5U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToDma0       = 6U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToDma0       = 7U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma0       = 8U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToDma0       = 9U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToDma0       = 10U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToDma0       = 11U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToDma0       = 12U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToDma0       = 13U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutAToDma0    = 14U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutBToDma0    = 15U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutCToDma0    = 16U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0TrigOutDToDma0    = 17U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac0ToDma0       = 18U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac1ToDma0       = 19U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_HashCryptOutToDma0    = 20U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_AcmpToDma0            = 21U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_AdcToDma0             = 24U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiRxToDma0       = 28U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiTxToDma0       = 29U + (DMA0_ITRIG_PMUX_ID << PMUX_SHIFT),

    /*!< DMA1 ITRIG. */
    kINPUTMUX_NsGpioPint0Int0ToDma1 = 0U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint0Int1ToDma1 = 1U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint0Int2ToDma1 = 2U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_NsGpioPint0Int3ToDma1 = 3U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M0ToDma1       = 4U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer0M1ToDma1       = 5U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M0ToDma1       = 6U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer1M1ToDma1       = 7U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M0ToDma1       = 8U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer2M1ToDma1       = 9U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M0ToDma1       = 10U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer3M1ToDma1       = 11U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M0ToDma1       = 12U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Ctimer4M1ToDma1       = 13U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutAToDma1    = 14U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutBToDma1    = 15U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutCToDma1    = 16U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1TrigOutDToDma1    = 17U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac0ToDma1       = 18U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Sct0Dmac1ToDma1       = 19U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_HashCryptOutToDma1    = 20U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_AcmpToDma1            = 21U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_AdcToDma1             = 24U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiRxToDma1       = 28U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_FlexspiTxToDma1       = 29U + (DMA1_ITRIG_PMUX_ID << PMUX_SHIFT),

    /*!< DMA0 OTRIG. */
    kINPUTMUX_Dma0OtrigChannel0ToTriginChannels  = 0U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel1ToTriginChannels  = 1U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel2ToTriginChannels  = 2U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel3ToTriginChannels  = 3U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel4ToTriginChannels  = 4U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel5ToTriginChannels  = 5U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel6ToTriginChannels  = 6U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel7ToTriginChannels  = 7U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel8ToTriginChannels  = 8U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel9ToTriginChannels  = 9U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel10ToTriginChannels = 10U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel11ToTriginChannels = 11U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel12ToTriginChannels = 12U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel13ToTriginChannels = 13U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel14ToTriginChannels = 14U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel15ToTriginChannels = 15U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel16ToTriginChannels = 16U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel17ToTriginChannels = 17U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel18ToTriginChannels = 18U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel19ToTriginChannels = 19U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel20ToTriginChannels = 20U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel21ToTriginChannels = 21U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel22ToTriginChannels = 22U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel23ToTriginChannels = 23U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel24ToTriginChannels = 24U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel25ToTriginChannels = 25U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel26ToTriginChannels = 26U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel27ToTriginChannels = 27U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel28ToTriginChannels = 28U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel29ToTriginChannels = 29U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel30ToTriginChannels = 30U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel31ToTriginChannels = 31U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma0OtrigChannel32ToTriginChannels = 32U + (DMA0_OTRIG_PMUX_ID << PMUX_SHIFT),

    /*!< DMA1 OTRIG. */
    kINPUTMUX_Dma1OtrigChannel0ToTriginChannels  = 0U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel1ToTriginChannels  = 1U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel2ToTriginChannels  = 2U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel3ToTriginChannels  = 3U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel4ToTriginChannels  = 4U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel5ToTriginChannels  = 5U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel6ToTriginChannels  = 6U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel7ToTriginChannels  = 7U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel8ToTriginChannels  = 8U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel9ToTriginChannels  = 9U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel10ToTriginChannels = 10U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel11ToTriginChannels = 11U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel12ToTriginChannels = 12U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel13ToTriginChannels = 13U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel14ToTriginChannels = 14U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel15ToTriginChannels = 15U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel16ToTriginChannels = 16U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel17ToTriginChannels = 17U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel18ToTriginChannels = 18U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel19ToTriginChannels = 19U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel20ToTriginChannels = 20U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel21ToTriginChannels = 21U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel22ToTriginChannels = 22U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel23ToTriginChannels = 23U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel24ToTriginChannels = 24U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel25ToTriginChannels = 25U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel26ToTriginChannels = 26U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel27ToTriginChannels = 27U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel28ToTriginChannels = 28U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel29ToTriginChannels = 29U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel30ToTriginChannels = 30U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel31ToTriginChannels = 31U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
    kINPUTMUX_Dma1OtrigChannel32ToTriginChannels = 32U + (DMA1_OTRIG_PMUX_ID << PMUX_SHIFT),
} inputmux_connection_t;
/*! @brief INPUTMUX signal enable/disable type */
typedef enum _inputmux_signal_t
{
    /*!< DMA0 input trigger source enable. */
    kINPUTMUX_Dmac0InputTriggerPint0Ena     = 0U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPint1Ena     = 1U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPint2Ena     = 2U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerPint3Ena     = 3U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer0M0Ena = 4U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer0M1Ena = 5U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer1M0Ena = 6U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer1M1Ena = 7U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer2M0Ena = 8U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer2M1Ena = 9U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer3M0Ena = 10U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer3M1Ena = 11U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer4M0Ena = 12U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerCtimer4M1Ena = 13U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutAEna  = 14U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutBEna  = 15U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutCEna  = 16U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerDma0OutDEna  = 17U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerSctDmac0Ena  = 18U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerSctDmac1Ena  = 19U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerHashOutEna   = 20U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAcmpEna      = 21U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerAdcEna       = 24U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexspiRxEna = 28U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac0InputTriggerFlexspiTxEna = 29U + (DMA0_ITRIG_EN0_ID << ENA_SHIFT),

    /*!< DMA1 input trigger source enable. */
    kINPUTMUX_Dmac1InputTriggerPint0Ena     = 0U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerPint1Ena     = 1U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerPint2Ena     = 2U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerPint3Ena     = 3U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer0M0Ena = 4U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer0M1Ena = 5U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer1M0Ena = 6U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer1M1Ena = 7U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer2M0Ena = 8U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer2M1Ena = 9U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer3M0Ena = 10U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer3M1Ena = 11U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer4M0Ena = 12U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerCtimer4M1Ena = 13U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutAEna  = 14U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutBEna  = 15U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutCEna  = 16U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerDma1OutDEna  = 17U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerSctDmac0Ena  = 18U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerSctDmac1Ena  = 19U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerHashOutEna   = 20U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerAcmpEna      = 21U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerAdcEna       = 24U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexspiRxEna = 28U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),
    kINPUTMUX_Dmac1InputTriggerFlexspiTxEna = 29U + (DMA1_ITRIG_EN0_ID << ENA_SHIFT),

    /*!< DMA0 REQ signal. */
    kINPUTMUX_Flexcomm0RxToDmac0Ch0RequestEna   = 0U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm0TxToDmac0Ch1RequestEna   = 1U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1RxToDmac0Ch2RequestEna   = 2U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1TxToDmac0Ch3RequestEna   = 3U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2RxToDmac0Ch4RequestEna   = 4U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2TxToDmac0Ch5RequestEna   = 5U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3RxToDmac0Ch6RequestEna   = 6U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3TxToDmac0Ch7RequestEna   = 7U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm4RxToDmac0Ch8RequestEna   = 8U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm4TxToDmac0Ch9RequestEna   = 9U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm5RxToDmac0Ch10RequestEna  = 10U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm5TxToDmac0Ch11RequestEna  = 11U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm6RxToDmac0Ch12RequestEna  = 12U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm6TxToDmac0Ch13RequestEna  = 13U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm7RxToDmac0Ch14RequestEna  = 14U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm7TxToDmac0Ch15RequestEna  = 15U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch0ToDmac0Ch16RequestEna     = 16U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch1ToDmac0Ch17RequestEna     = 17U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch2ToDmac0Ch18RequestEna     = 18U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch3ToDmac0Ch19RequestEna     = 19U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch4ToDmac0Ch20RequestEna     = 20U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch5ToDmac0Ch21RequestEna     = 21U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch6ToDmac0Ch22RequestEna     = 22U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch7ToDmac0Ch23RequestEna     = 23U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_I3c0RxToDmac0Ch24RequestEna       = 24U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_I3c0TxToDmac0Ch25RequestEna       = 25U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14RxToDmac0Ch26RequestEna = 26U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14TxToDmac0Ch27RequestEna = 27U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_HashCryptToDmac0Ch30RequestEna    = 30U + (DMA0_REQ_ENA0_ID << ENA_SHIFT),

    /*!< DMA1 REQ signal. */
    kINPUTMUX_Flexcomm0RxToDmac1Ch0RequestEna   = 0U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm0TxToDmac1Ch1RequestEna   = 1U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1RxToDmac1Ch2RequestEna   = 2U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm1TxToDmac1Ch3RequestEna   = 3U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2RxToDmac1Ch4RequestEna   = 4U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm2TxToDmac1Ch5RequestEna   = 5U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3RxToDmac1Ch6RequestEna   = 6U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm3TxToDmac1Ch7RequestEna   = 7U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm4RxToDmac1Ch8RequestEna   = 8U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm4TxToDmac1Ch9RequestEna   = 9U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm5RxToDmac1Ch10RequestEna  = 10U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm5TxToDmac1Ch11RequestEna  = 11U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm6RxToDmac1Ch12RequestEna  = 12U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm6TxToDmac1Ch13RequestEna  = 13U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm7RxToDmac1Ch14RequestEna  = 14U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm7TxToDmac1Ch15RequestEna  = 15U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch0ToDmac1Ch16RequestEna     = 16U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch1ToDmac1Ch17RequestEna     = 17U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch2ToDmac1Ch18RequestEna     = 18U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch3ToDmac1Ch19RequestEna     = 19U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch4ToDmac1Ch20RequestEna     = 20U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch5ToDmac1Ch21RequestEna     = 21U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch6ToDmac1Ch22RequestEna     = 22U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Dmic0Ch7ToDmac1Ch23RequestEna     = 23U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_I3c0RxToDmac1Ch24RequestEna       = 24U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_I3c0TxToDmac1Ch25RequestEna       = 25U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14RxToDmac1Ch26RequestEna = 26U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_Flexcomm14TxToDmac1Ch27RequestEna = 27U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),
    kINPUTMUX_HashCryptToDmac1Ch30RequestEna    = 30U + (DMA1_REQ_ENA0_ID << ENA_SHIFT),

} inputmux_signal_t;

/*@}*/

#endif /* _FSL_INPUTMUX_CONNECTIONS_ */
