/* ------------------------------------------------------------------------ */
/* Copyright (c) 2018 by Cadence Design Systems, Inc. ALL RIGHTS RESERVED.  */
/* These coded instructions, statements, and computer programs ("Cadence    */
/* Libraries") are the copyrighted works of Cadence Design Systems Inc.	    */
/* Cadence IP is licensed for use with Cadence processor cores only and     */
/* must not be used for any other processors and platforms. Your use of the */
/* Cadence Libraries is subject to the terms of the license agreement you   */
/* have entered into with Cadence Design Systems, or a sublicense granted   */
/* to you by a direct Cadence licensee.                                     */
/* ------------------------------------------------------------------------ */
/*  IntegrIT, Ltd.   www.integrIT.com, info@integrIT.com                    */
/*                                                                          */
/* DSP Library                                                              */
/*                                                                          */
/* This library contains copyrighted materials, trade secrets and other     */
/* proprietary information of IntegrIT, Ltd. This software is licensed for  */
/* use with Cadence processor cores only and must not be used for any other */
/* processors and platforms. The license to use these sources was given to  */
/* Cadence, Inc. under Terms and Condition of a Software License Agreement  */
/* between Cadence, Inc. and IntegrIT, Ltd.                                 */
/* ------------------------------------------------------------------------ */
/*          Copyright (C) 2015-2018 IntegrIT, Limited.                      */
/*                      All Rights Reserved.                                */
/* ------------------------------------------------------------------------ */
#include "vec_recip_table.h"
#include "common.h"

/* -------------------------------------------------
recip_table: contains packed (1/x) / 1/(x^2) in Q.15 
------------------------------------------------ */ 
#ifdef COMPILER_MSVC

const int16_t _declspec(align(4)) recip_table[] =
#else
const int16_t                     recip_table[] __attribute__((aligned(4))) =
#endif
{
/*
MATLAB code:
ord=128;
xt=1:1/ord:2;
tbl_x=1./xt;
tbl_y=(1./(xt.^2));
tbl_x=round(tbl_x*2^15);
tbl_y=round(tbl_y*2^15);
tbl_x=max(-2^15,min(2^15-1,tbl_x));
tbl_y=max(-2^15,min(32690,tbl_y));
tbl_recip = [tbl_x;tbl_y];
*/
0x7FFF,0x7FB2,0x7F02,0x7E06,
0x7E08,0x7C18,0x7D11,0x7A34,
0x7C1F,0x785C,0x7B30,0x768F,
0x7A45,0x74CB,0x795D,0x7312,
0x7878,0x7162,0x7797,0x6FBC,
0x76BA,0x6E1F,0x75DF,0x6C8B,
0x7507,0x6AFF,0x7433,0x697C,
0x7361,0x6801,0x7293,0x668E,
0x71C7,0x6523,0x70FE,0x63BF,
0x7038,0x6262,0x6F75,0x610D,
0x6EB4,0x5FBE,0x6DF6,0x5E76,
0x6D3A,0x5D35,0x6C81,0x5BFA,
0x6BCA,0x5AC5,0x6B16,0x5996,
0x6A64,0x586D,0x69B4,0x574A,
0x6906,0x562D,0x685B,0x5515,
0x67B2,0x5402,0x670B,0x52F4,
0x6666,0x51EC,0x65C3,0x50E8,
0x6523,0x4FE9,0x6484,0x4EEF,
0x63E7,0x4DF9,0x634C,0x4D08,
0x62B3,0x4C1B,0x621B,0x4B32,
0x6186,0x4A4E,0x60F2,0x496D,
0x6060,0x4891,0x5FD0,0x47B8,
0x5F41,0x46E3,0x5EB5,0x4612,
0x5E29,0x4545,0x5D9F,0x447A,
0x5D17,0x43B4,0x5C91,0x42F1,
0x5C0B,0x4231,0x5B88,0x4174,
0x5B06,0x40BA,0x5A85,0x4004,
0x5A06,0x3F50,0x5988,0x3E9F,
0x590B,0x3DF1,0x5890,0x3D47,
0x5816,0x3C9E,0x579D,0x3BF9,
0x5726,0x3B56,0x56B0,0x3AB6,
0x563B,0x3A18,0x55C8,0x397C,
0x5555,0x38E4,0x54E4,0x384D,
0x5474,0x37B9,0x5405,0x3727,
0x5398,0x3697,0x532B,0x360A,
0x52BF,0x357E,0x5255,0x34F5,
0x51EB,0x346E,0x5183,0x33E9,
0x511C,0x3365,0x50B6,0x32E4,
0x5050,0x3265,0x4FEC,0x31E7,
0x4F88,0x316B,0x4F26,0x30F1,
0x4EC5,0x3079,0x4E64,0x3003,
0x4E05,0x2F8E,0x4DA6,0x2F1B,
0x4D48,0x2EA9,0x4CEC,0x2E39,
0x4C90,0x2DCB,0x4C34,0x2D5E,
0x4BDA,0x2CF3,0x4B80,0x2C89,
0x4B28,0x2C21,0x4AD0,0x2BBA,
0x4A79,0x2B54,0x4A23,0x2AF3,
0x49CD,0x2A8D,0x4978,0x2A2C,
0x4925,0x29CC,0x48D1,0x296D,
0x487F,0x290F,0x482D,0x28B3,
0x47DC,0x2858,0x478C,0x27FE,
0x473C,0x27A5,0x46ED,0x274D,
0x469F,0x26F7,0x4651,0x26A1,
0x4604,0x264D,0x45B8,0x25FA,
0x456C,0x25A7,0x4521,0x2556,
0x44D7,0x2506,0x448D,0x24B7,
0x4444,0x2469,0x43FC,0x241B,
0x43B4,0x23CF,0x436C,0x2384,
0x4326,0x233A,0x42E0,0x22F0,
0x429A,0x22A8,0x4255,0x2260,
0x4210,0x2219,0x41CC,0x21D3,
0x4189,0x218E,0x4146,0x214A,
0x4104,0x2106,0x40C2,0x20C3,
0x4081,0x2082,0x4040,0x2040,
0x4000,0x2000  
};
