/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v9.0
processor: MKM35Z512xxx7
package_id: MKM35Z512VLL7
mcu_data: ksdk2_0
processor_version: 9.0.1
board: TWR-KM35Z75M
pin_labels:
- {pin_num: '78', pin_signal: LCD_P10/PTG3/SPI0_SCK/I2C0_SCL, label: 'J32[B7]/J12[1]/U4[6]/SPI0_SCK', identifier: FLASH_CLK}
- {pin_num: '77', pin_signal: LCD_P9/ADC0_SE11/PTG2/LLWU_P1/SPI0_PCS0, label: 'J32[B9]/J9[2]/U4[1]/SPI0_PCS0', identifier: FLASH_CS}
- {pin_num: '79', pin_signal: LCD_P11/PTG4/SPI0_MOSI/I2C0_SDA, label: 'J32[B10]/J15[1]/U4[5]/SPI0_MOSI', identifier: FLASH_SI}
- {pin_num: '80', pin_signal: LCD_P12/PTG5/SPI0_MISO/LPTMR0_ALT2, label: 'J32[B11]/J13[2]/U4[2]/SPI0_MISO', identifier: FLASH_SO}
- {pin_num: '90', pin_signal: PTH7/UART1_RTS_b/SPI1_SCK/XBAR_OUT7, label: 'J32[B21]'}
- {pin_num: '93', pin_signal: LCD_P21/PTI2/LLWU_P22/LPUART0_RX, label: 'J32[B23]'}
- {pin_num: '64', pin_signal: PTE5/LLWU_P6/QTMR0_TMR3/UART2_RTS_b/EWM_OUT_b, label: 'J32[B35]'}
- {pin_num: '72', pin_signal: LCD_P4/PTF5/SPI1_MISO/I2C1_SCL, label: 'J32[B44]/J23[9]/J25[14]/SPI1_MISO'}
- {pin_num: '73', pin_signal: LCD_P5/PTF6/LLWU_P3/SPI1_MOSI/I2C1_SDA, label: GND}
- {pin_num: '70', pin_signal: LCD_P2/PTF3/LLWU_P20/SPI1_PCS0/LPTMR0_ALT2/UART0_RX, label: 'J32[B46]/J23[11]/J25[16]/SPI1_PCS0'}
- {pin_num: '71', pin_signal: LCD_P3/PTF4/SPI1_SCK/LPTMR0_ALT1/UART0_TX, label: 'J32[B48]/J23[12]/J25[15]/SPI1_SCK'}
- {pin_num: '83', pin_signal: LCD_P15/PTH0/LPUART0_CTS_b, label: 'J32[B55]/J32[B56]'}
- {pin_num: '84', pin_signal: LCD_P16/PTH1/LPUART0_RTS_b, label: 'J32[B57]/J32[B58]'}
- {pin_num: '85', pin_signal: LCD_P17/PTH2/LPUART0_RX, label: 'J32[B59]/J32[B60]'}
- {pin_num: '86', pin_signal: LCD_P18/PTH3/LPUART0_TX, label: GND}
- {pin_num: '54', pin_signal: CMP0_IN4/PTD7/LLWU_P7/I2C0_SCL/XBAR_IN4/UART3_RX, label: 'J25[12]/I2C0_SCL'}
- {pin_num: '55', pin_signal: PTE0/I2C0_SDA/XBAR_OUT4/UART3_TX/CLKOUT, label: 'J25[11]/I2C0_SDA'}
- {pin_num: '89', pin_signal: PTH6/UART1_CTS_b/SPI1_PCS0/XBAR_IN7, label: MCU_PWR}
- {pin_num: '63', pin_signal: PTE4/LPTMR0_ALT1/UART2_CTS_b/EWM_IN, label: 'J32[A35]'}
- {pin_num: '91', pin_signal: CMP0_IN5/PTI0/LLWU_P21/UART1_RX/XBAR_IN8/SPI1_MISO/SPI1_MOSI, label: 'J32[A43]'}
- {pin_num: '92', pin_signal: PTI1/UART1_TX/XBAR_OUT8/SPI1_MOSI/SPI1_MISO, label: 'J32[A44]'}
- {pin_num: '49', pin_signal: CMP0_IN1/PTD2/LLWU_P10/UART1_RX/SPI0_SCK/XBAR_IN3, label: 'J25[8]/UART1_RX'}
- {pin_num: '56', pin_signal: PTE1/RESET_b, label: GND}
- {pin_num: '7', pin_signal: LCD_P29/PTA6/LLWU_P14/XBAR_IN0, label: 'DS1[6]/LCD_P29', identifier: LCD_P29}
- {pin_num: '6', pin_signal: LCD_P28/PTA5/CMP0_OUT, label: 'DS1[18]/LCD_P28', identifier: LCD_P28}
- {pin_num: '66', pin_signal: ADC0_SE6a/PTE7/XBAR_OUT5/UART2_TX/I2C0_SDA/SWD_CLK, label: 'J24[4]/SWD_CLK_TGTMCU'}
- {pin_num: '67', pin_signal: ADC0_SE7a/CMP2_IN3/PTF0/LLWU_P4/RTC_CLKOUT/QTMR0_TMR2/CMP0_OUT, label: NC}
- {pin_num: '62', pin_signal: VDD62, label: D3/GRN, identifier: LED_GREEN}
- {pin_num: '44', pin_signal: ADC0_SE0/CMP2_IN0/PTC5/LLWU_P12/UART0_RTS_b/LPTMR1_ALT1, label: 'J31[18]/ADC0_SE0'}
- {pin_num: '47', pin_signal: CMP0_IN0/PTD0/LLWU_P11/UART0_RX/XBAR_IN2, label: 'J25[24]/UART0_RX'}
- {pin_num: '18', pin_signal: LCD_P38/PTB7/AFE_CLK, label: MCU_PWR}
- {pin_num: '16', pin_signal: LCD_P36/PTB5/SPI2_MOSI, label: 'DS1[2]/LCD_P36', identifier: LCD_P36}
- {pin_num: '14', pin_signal: LCD_P34/PTB3/SPI2_SCK, label: 'J23[4]/I2C1_SDA'}
- {pin_num: '12', pin_signal: LCD_P32/PTB1/LLWU_P17, label: 'DS1[4]/LCD_P32', identifier: LCD_P32}
- {pin_num: '9', pin_signal: LCD_P31/PTB0, label: 'DS1[5]/LCD_P31', identifier: LCD_P31}
- {pin_num: '3', pin_signal: LCD_P25/PTA2, label: 'DS1[15]/LCD_P45', identifier: LCD_P45}
- {pin_num: '1', pin_signal: LCD_P23/PTA0/LLWU_P16, label: GND}
- {pin_num: '23', pin_signal: LCD_P43/PTC4, label: 'DS1[9]/LCD_P43', identifier: LCD_P43}
- {pin_num: '17', pin_signal: LCD_P37/CMP1_IN0/PTB6, label: 'DS1[13]/LCD_P50', identifier: LCD_P50}
- {pin_num: '15', pin_signal: LCD_P35/PTB4/SPI2_MISO, label: 'J23[3]/I2C1_SCL'}
- {pin_num: '13', pin_signal: LCD_P33/PTB2/SPI2_PCS0, label: 'DS1[12]/LCD_P33', identifier: LCD_P33}
- {pin_num: '8', pin_signal: LCD_P30/PTA7/XBAR_OUT0, label: 'DS1[14]/LCD_P30', identifier: LCD_P30}
- {pin_num: '82', pin_signal: LCD_P14/PTG7/LPTMR1_ALT1, label: 'DS1[28]/LCD_P14', identifier: LCD_P14}
- {pin_num: '88', pin_signal: LCD_P20/PTH5/LPTMR1_ALT3, label: 'DS1[27]/LCD_P20', identifier: LCD_P20}
- {pin_num: '94', pin_signal: LCD_P22/PTI3/LPUART0_TX/CMP2_OUT, label: 'DS1[26]/LCD_P22', identifier: LCD_P22}
- {pin_num: '57', pin_signal: EXTAL/PTE2/EWM_IN/XBAR_IN6/I2C1_SDA, label: GND}
- {pin_num: '81', pin_signal: LCD_P13/PTG6/LLWU_P0/LPTMR0_ALT3, label: 'DS1[23]/LCD_P13', identifier: LCD_P13}
- {pin_num: '87', pin_signal: LCD_P19/PTH4/LPTMR1_ALT2, label: 'DS1[22]/LCD_P19', identifier: LCD_P19}
- {pin_num: '58', pin_signal: XTAL/PTE3/EWM_OUT_b/AFE_CLK/I2C1_SCL, label: 'J7[2]/Y2[1]/XTAL_8MHz', identifier: XTAL0}
- {pin_num: '4', pin_signal: LCD_P26/PTA3, label: 'DS1[17]/LCD_P26', identifier: LCD_P26}
- {pin_num: '2', pin_signal: LCD_P24/PTA1, label: GND}
- {pin_num: '5', pin_signal: LCD_P27/PTA4/LLWU_P15/NMI_b, label: SW1, identifier: SW1}
- {pin_num: '48', pin_signal: PTD1/UART1_TX/SPI0_PCS0/XBAR_OUT3/QTMR0_TMR3, label: 'J25[9]/UART1_TX'}
- {pin_num: '68', pin_signal: LCD_P0/ADC0_SE8/CMP2_IN4/PTF1/QTMR0_TMR0/XBAR_OUT6, label: 'J21[1]/POT_5K', identifier: ADC_POT}
- {pin_num: '69', pin_signal: LCD_P1/ADC0_SE9/CMP2_IN5/PTF2/CMP1_OUT/RTC_CLKOUT, label: 'J20[1]/TEMP_SENSE', identifier: ADC_TEMP}
- {pin_num: '26', pin_signal: EXTAL32, label: 'Y1[2]/EXTAL_32K', identifier: EXTAL_32K}
- {pin_num: '25', pin_signal: XTAL32, label: 'Y1[1]/XTAL_32K', identifier: XTAL_32K}
- {pin_num: '51', pin_signal: ADC0_SE3/PTD4/LLWU_P9/UART1_RTS_b/SPI0_MISO/LPTMR1_ALT3, label: 'J22[9]/TWRPI-ADC1'}
- {pin_num: '75', pin_signal: LCD_P7/PTG0/QTMR0_TMR1/LPTMR0_ALT3, label: 'J25[20]/QTMR0_TMR1'}
- {pin_num: '53', pin_signal: ADC0_SE5a/PTD6/LLWU_P8/LPTMR0_ALT2/CMP1_OUT/UART3_RTS_b, label: 'J22[18]/TWRPI-ID1'}
- {pin_num: '52', pin_signal: ADC0_SE4a/PTD5/LPTMR0_ALT3/QTMR0_TMR0/UART3_CTS_b, label: 'J22[17]/TWRPI-ID0'}
- {pin_num: '50', pin_signal: PTD3/UART1_CTS_b/SPI0_MOSI/LPTMR1_ALT2, label: 'J23[16]'}
- {pin_num: '22', pin_signal: LCD_P42/CMP0_IN3/PTC3/LLWU_P13/UART3_RX, label: 'J23[17]/UART3_RX'}
- {pin_num: '20', pin_signal: LCD_P40/CMP1_IN1/PTC1/UART3_CTS_b, label: 'J23[19]/UART3_CTS'}
- {pin_num: '21', pin_signal: LCD_P41/PTC2/UART3_TX/XBAR_OUT1, label: 'J23[18]/UART3_TX'}
- {pin_num: '19', pin_signal: LCD_P39/PTC0/UART3_RTS_b/XBAR_IN1/PDB0_EXTRG, label: GND}
- {pin_num: '30', pin_signal: TAMPER0, label: 'J25[2]'}
- {pin_num: '29', pin_signal: TAMPER1, label: 'J25[4]'}
- {pin_num: '28', pin_signal: TAMPER2, label: 'J25[6]'}
- {pin_num: '74', pin_signal: LCD_P6/PTF7/QTMR0_TMR2/CLKOUT/CMP2_OUT, label: GND}
- {pin_num: '46', pin_signal: ADC0_SE2/CMP2_IN2/PTC7/UART0_TX/XBAR_OUT2, label: 'J31[22]/ADC0_SE2'}
- {pin_num: '65', pin_signal: CMP0_IN2/PTE6/LLWU_P5/XBAR_IN5/UART2_RX/I2C0_SCL/SWD_DIO, label: 'J24[2]/SWD_DIO_TGTMCU'}
- {pin_num: '41', pin_signal: VREF, label: 'J2[2]/VREF'}
- {pin_num: '38', pin_signal: VREFL, label: GND}
- {pin_num: '37', pin_signal: VREFH, label: GND}
- {pin_num: '61', pin_signal: VDDA, label: VDDA}
- {pin_num: '60', pin_signal: VSSA, label: VSSA}
- {pin_num: '31', pin_signal: AFE_VDDA, label: VDDA_AFE}
- {pin_num: '32', pin_signal: AFE_VSSA, label: VSSA_AFE}
- {pin_num: '39', pin_signal: AFE_SDADP2/CMP1_IN2, label: 'J31[10]/AFE_SDADP2'}
- {pin_num: '33', pin_signal: AFE_SDADP0, label: 'J31[2]/AFE_SDADP0'}
- {pin_num: '34', pin_signal: AFE_SDADM0, label: 'J31[4]/AFE_SDADM0'}
- {pin_num: '35', pin_signal: AFE_SDADP1, label: 'J31[6]/AFE_SDADP1'}
- {pin_num: '36', pin_signal: AFE_SDADM1, label: 'J31[8]/AFE_SDADM1'}
- {pin_num: '40', pin_signal: AFE_SDADM2/CMP1_IN3, label: 'J31[12]/AFE_SDADM2'}
- {pin_num: '43', pin_signal: AFE_SDADM3/CMP1_IN5, label: 'J31[16]/AFE_SDADM3'}
- {pin_num: '42', pin_signal: AFE_SDADP3/CMP1_IN4, label: 'J31[14]/AFE_SDADP3'}
- {pin_num: '45', pin_signal: ADC0_SE1/CMP2_IN1/PTC6/UART0_CTS_b/QTMR0_TMR1/PDB0_EXTRG, label: 'J31[20]/ADC0_SE1'}
- {pin_num: '24', pin_signal: VBAT, label: 'J1[2]/VBAT'}
- {pin_num: '76', pin_signal: LCD_P8/ADC0_SE10/PTG1/LLWU_P2/LPTMR0_ALT1, label: NC}
- {pin_num: '96', pin_signal: VLL3, label: 'J33[2]/VLL3'}
- {pin_num: '98', pin_signal: VLL1/LCD_P61/PTM1, label: VLL1}
- {pin_num: '97', pin_signal: VLL2/LCD_P60/PTM0, label: VLL2}
- {pin_num: '99', pin_signal: VCAP2/LCD_P62/PTM2, label: C83/VCAP2}
- {pin_num: '100', pin_signal: VCAP1/LCD_P63/PTM3, label: C83/VCAP1}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "fsl_gpio.h"
#include "fsl_xbar.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
    BOARD_InitDEBUG_UARTPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void)
{
    /* Application specific Clock Gate Control: Clock enabled */
  CLOCK_EnableClock(kCLOCK_PortA);
  CLOCK_EnableClock(kCLOCK_PortB);
  CLOCK_EnableClock(kCLOCK_PortC);
  CLOCK_EnableClock(kCLOCK_PortD);
  CLOCK_EnableClock(kCLOCK_PortE);
  CLOCK_EnableClock(kCLOCK_PortF);
  CLOCK_EnableClock(kCLOCK_PortG);
  CLOCK_EnableClock(kCLOCK_PortH);
  CLOCK_EnableClock(kCLOCK_PortI);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitButtonsPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '5', peripheral: GPIOA, signal: 'GPIO, 4', pin_signal: LCD_P27/PTA4/LLWU_P15/NMI_b, direction: INPUT, slew_rate: slow, open_drain: disable, pull_select: up,
    pull_enable: enable}
  - {pin_num: '48', peripheral: GPIOD, signal: 'GPIO, 1', pin_signal: PTD1/UART1_TX/SPI0_PCS0/XBAR_OUT3/QTMR0_TMR3, direction: INPUT, slew_rate: slow, open_drain: disable,
    pull_select: up, pull_enable: enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitButtonsPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitButtonsPins(void)
{
    /* PCTLA Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortA);
    /* PCTLD Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortD);

    gpio_pin_config_t SW1_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTA4 (pin 5)  */
    GPIO_PinInit(BOARD_SW1_GPIO, BOARD_SW1_PIN, &SW1_config);

    gpio_pin_config_t gpiod_pin48_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTD1 (pin 48)  */
    GPIO_PinInit(GPIOD, 1U, &gpiod_pin48_config);

    const port_pin_config_t SW1 = {/* Internal pull-up resistor is enabled */
                                   kPORT_PullUp,
                                   /* Slow slew rate is configured */
                                   kPORT_SlowSlewRate,
                                   /* Open drain is disabled */
                                   kPORT_OpenDrainDisable,
                                   /* Pin is configured as PTA4 */
                                   kPORT_MuxAsGpio,
                                   /* Pin Control Register fields [15:0] are not locked */
                                   kPORT_UnlockRegister};
    /* PORTA4 (pin 5) is configured as PTA4 */
    PORT_SetPinConfig(BOARD_SW1_PORT, BOARD_SW1_PIN, &SW1);

    const port_pin_config_t portd1_pin48_config = {/* Internal pull-up resistor is enabled */
                                                   kPORT_PullUp,
                                                   /* Slow slew rate is configured */
                                                   kPORT_SlowSlewRate,
                                                   /* Open drain is disabled */
                                                   kPORT_OpenDrainDisable,
                                                   /* Pin is configured as PTD1 */
                                                   kPORT_MuxAsGpio,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTD1 (pin 48) is configured as PTD1 */
    PORT_SetPinConfig(PORTD, 1U, &portd1_pin48_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitLEDsPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {peripheral: GPIOJ, signal: 'GPIO, 3', pin_signal: PTJ3/LPUART0_RTS_b/CMP2_OUT, direction: OUTPUT, gpio_init_state: 'true', slew_rate: slow, open_drain: disable,
    pull_select: down, pull_enable: disable}
  - {peripheral: GPIOJ, signal: 'GPIO, 4', pin_signal: PTJ4/LPUART0_CTS_b/LPTMR1_ALT1, direction: OUTPUT, gpio_init_state: 'true', slew_rate: slow, open_drain: disable,
    pull_select: down, pull_enable: disable}
  - {pin_num: '47', peripheral: GPIOD, signal: 'GPIO, 0', pin_signal: CMP0_IN0/PTD0/LLWU_P11/UART0_RX/XBAR_IN2, direction: OUTPUT, gpio_init_state: 'true', slew_rate: slow,
    open_drain: disable, pull_select: down, pull_enable: disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitLEDsPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitLEDsPins(void)
{
    /* There are conflicts or other incorrect settings in the configuration, the code below is generated only for 
     * those registers which are set correctly and without a conflict. Open this file in Pins Tool for more details. */

    /* PCTLD Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortD);

    gpio_pin_config_t gpiod_pin47_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PTD0 (pin 47)  */
    GPIO_PinInit(GPIOD, 0U, &gpiod_pin47_config);

    const port_pin_config_t portd0_pin47_config = {/* Internal pull-up/down resistor is disabled */
                                                   kPORT_PullDisable,
                                                   /* Slow slew rate is configured */
                                                   kPORT_SlowSlewRate,
                                                   /* Open drain is disabled */
                                                   kPORT_OpenDrainDisable,
                                                   /* Pin is configured as PTD0 */
                                                   kPORT_MuxAsGpio,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTD0 (pin 47) is configured as PTD0 */
    PORT_SetPinConfig(PORTD, 0U, &portd0_pin47_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitACCELPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '55', peripheral: I2C0, signal: SDA, pin_signal: PTE0/I2C0_SDA/XBAR_OUT4/UART3_TX/CLKOUT, slew_rate: fast, open_drain: enable, pull_select: down, pull_enable: disable,
    digital_filter: disable}
  - {pin_num: '54', peripheral: I2C0, signal: SCL, pin_signal: CMP0_IN4/PTD7/LLWU_P7/I2C0_SCL/XBAR_IN4/UART3_RX, slew_rate: fast, open_drain: enable, pull_select: down,
    pull_enable: disable}
  - {peripheral: GPIOJ, signal: 'GPIO, 5', pin_signal: PTJ5/LPUART0_TX, direction: INPUT, slew_rate: fast, open_drain: enable, pull_select: up, pull_enable: enable}
  - {peripheral: GPIOJ, signal: 'GPIO, 6', pin_signal: PTJ6/LLWU_P18/LPUART0_RX, direction: INPUT, slew_rate: fast, open_drain: enable, pull_select: up, pull_enable: enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitACCELPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitACCELPins(void)
{
    /* There are conflicts or other incorrect settings in the configuration, the code below is generated only for 
     * those registers which are set correctly and without a conflict. Open this file in Pins Tool for more details. */

    /* PCTLD Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortD);
    /* PCTLE Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortE);

    const port_pin_config_t portd7_pin54_config = {/* Internal pull-up/down resistor is disabled */
                                                   kPORT_PullDisable,
                                                   /* Fast slew rate is configured */
                                                   kPORT_FastSlewRate,
                                                   /* Open drain is enabled */
                                                   kPORT_OpenDrainEnable,
                                                   /* Pin is configured as I2C0_SCL */
                                                   kPORT_MuxAlt2,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTD7 (pin 54) is configured as I2C0_SCL */
    PORT_SetPinConfig(PORTD, 7U, &portd7_pin54_config);
    /* Configure digital filter */
    PORT_EnablePinsDigitalFilter(
        /* Digital filter is configured on port E */
        PORTE,
        /* Digital filter is configured for PORTE0 */
        PORT_DFER_DFE_0_MASK,
        /* Disable digital filter */
        false);

    const port_pin_config_t porte0_pin55_config = {/* Internal pull-up/down resistor is disabled */
                                                   kPORT_PullDisable,
                                                   /* Fast slew rate is configured */
                                                   kPORT_FastSlewRate,
                                                   /* Open drain is enabled */
                                                   kPORT_OpenDrainEnable,
                                                   /* Pin is configured as I2C0_SDA */
                                                   kPORT_MuxAlt2,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTE0 (pin 55) is configured as I2C0_SDA */
    PORT_SetPinConfig(PORTE, 0U, &porte0_pin55_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitDEBUG_UARTPins:
- options: {callFromInitBoot: 'true', prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {peripheral: UART2, signal: TX, pin_signal: LCD_P47/PTI7/UART2_TX, direction: OUTPUT, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: UART2, signal: RX, pin_signal: LCD_P46/PTI6/UART2_RX, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitDEBUG_UARTPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitDEBUG_UARTPins(void)
{
    /* There are conflicts or other incorrect settings in the configuration, the code below is generated only for 
     * those registers which are set correctly and without a conflict. Open this file in Pins Tool for more details. */

}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitOSCPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '58', peripheral: OSC, signal: XTAL, pin_signal: XTAL/PTE3/EWM_OUT_b/AFE_CLK/I2C1_SCL, slew_rate: no_init, open_drain: no_init, pull_select: no_init,
    pull_enable: no_init, digital_filter: no_init}
  - {pin_num: '57', peripheral: OSC, signal: EXTAL, pin_signal: EXTAL/PTE2/EWM_IN/XBAR_IN6/I2C1_SDA, slew_rate: no_init, open_drain: no_init, pull_select: no_init,
    pull_enable: no_init, digital_filter: no_init}
  - {pin_num: '25', peripheral: RTC, signal: XTAL32, pin_signal: XTAL32}
  - {pin_num: '26', peripheral: RTC, signal: EXTAL32, pin_signal: EXTAL32}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitOSCPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitOSCPins(void)
{
    /* PCTLE Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortE);

    /* PORTE2 (pin 57) is configured as EXTAL */
    PORT_SetPinMux(PORTE, 2U, kPORT_PinDisabledOrAnalog);

    /* PORTE3 (pin 58) is configured as XTAL */
    PORT_SetPinMux(BOARD_XTAL0_PORT, BOARD_XTAL0_PIN, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitSPI_FLASHPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '79', peripheral: SPI0, signal: MOSI, pin_signal: LCD_P11/PTG4/SPI0_MOSI/I2C0_SDA, direction: OUTPUT, slew_rate: fast, open_drain: disable, pull_select: down,
    pull_enable: disable}
  - {pin_num: '80', peripheral: SPI0, signal: MISO, pin_signal: LCD_P12/PTG5/SPI0_MISO/LPTMR0_ALT2, direction: INPUT, slew_rate: fast, open_drain: disable, pull_select: down,
    pull_enable: disable}
  - {pin_num: '78', peripheral: SPI0, signal: SCK, pin_signal: LCD_P10/PTG3/SPI0_SCK/I2C0_SCL, direction: OUTPUT, slew_rate: fast, open_drain: disable, pull_select: down,
    pull_enable: disable}
  - {pin_num: '77', peripheral: SPI0, signal: PCS0, pin_signal: LCD_P9/ADC0_SE11/PTG2/LLWU_P1/SPI0_PCS0, direction: OUTPUT, slew_rate: fast, open_drain: disable,
    pull_select: down, pull_enable: disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitSPI_FLASHPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitSPI_FLASHPins(void)
{
    /* PCTLG Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortG);

    const port_pin_config_t FLASH_CS = {/* Internal pull-up/down resistor is disabled */
                                        kPORT_PullDisable,
                                        /* Fast slew rate is configured */
                                        kPORT_FastSlewRate,
                                        /* Open drain is disabled */
                                        kPORT_OpenDrainDisable,
                                        /* Pin is configured as SPI0_PCS0 */
                                        kPORT_MuxAlt2,
                                        /* Pin Control Register fields [15:0] are not locked */
                                        kPORT_UnlockRegister};
    /* PORTG2 (pin 77) is configured as SPI0_PCS0 */
    PORT_SetPinConfig(BOARD_FLASH_CS_PORT, BOARD_FLASH_CS_PIN, &FLASH_CS);

    const port_pin_config_t FLASH_CLK = {/* Internal pull-up/down resistor is disabled */
                                         kPORT_PullDisable,
                                         /* Fast slew rate is configured */
                                         kPORT_FastSlewRate,
                                         /* Open drain is disabled */
                                         kPORT_OpenDrainDisable,
                                         /* Pin is configured as SPI0_SCK */
                                         kPORT_MuxAlt2,
                                         /* Pin Control Register fields [15:0] are not locked */
                                         kPORT_UnlockRegister};
    /* PORTG3 (pin 78) is configured as SPI0_SCK */
    PORT_SetPinConfig(BOARD_FLASH_CLK_PORT, BOARD_FLASH_CLK_PIN, &FLASH_CLK);

    const port_pin_config_t FLASH_SI = {/* Internal pull-up/down resistor is disabled */
                                        kPORT_PullDisable,
                                        /* Fast slew rate is configured */
                                        kPORT_FastSlewRate,
                                        /* Open drain is disabled */
                                        kPORT_OpenDrainDisable,
                                        /* Pin is configured as SPI0_MOSI */
                                        kPORT_MuxAlt2,
                                        /* Pin Control Register fields [15:0] are not locked */
                                        kPORT_UnlockRegister};
    /* PORTG4 (pin 79) is configured as SPI0_MOSI */
    PORT_SetPinConfig(BOARD_FLASH_SI_PORT, BOARD_FLASH_SI_PIN, &FLASH_SI);

    const port_pin_config_t FLASH_SO = {/* Internal pull-up/down resistor is disabled */
                                        kPORT_PullDisable,
                                        /* Fast slew rate is configured */
                                        kPORT_FastSlewRate,
                                        /* Open drain is disabled */
                                        kPORT_OpenDrainDisable,
                                        /* Pin is configured as SPI0_MISO */
                                        kPORT_MuxAlt2,
                                        /* Pin Control Register fields [15:0] are not locked */
                                        kPORT_UnlockRegister};
    /* PORTG5 (pin 80) is configured as SPI0_MISO */
    PORT_SetPinConfig(BOARD_FLASH_SO_PORT, BOARD_FLASH_SO_PIN, &FLASH_SO);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitInfra_RedPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {peripheral: SIM, signal: UART_MOD_AND_OUT, pin_signal: LCD_P55/PTL2/XBAR_OUT10, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: SIM, signal: UART_MOD_CARR, pin_signal: RTC_CLK_Output}
  - {peripheral: SIM, signal: UART_MOD_DATA, pin_signal: UART0_TX_output}
  - {pin_num: '47', peripheral: CMP0, signal: 'IN, 0', pin_signal: CMP0_IN0/PTD0/LLWU_P11/UART0_RX/XBAR_IN2, slew_rate: fast, open_drain: disable, pull_select: down,
    pull_enable: disable}
  - {peripheral: UART0, signal: RX, pin_signal: CMP0_Output}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitInfra_RedPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitInfra_RedPins(void)
{
    /* There are conflicts or other incorrect settings in the configuration, the code below is generated only for 
     * those registers which are set correctly and without a conflict. Open this file in Pins Tool for more details. */

    /* PCTLD Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortD);
    /* Peripheral Crossbar Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_Xbar);

    const port_pin_config_t portd0_pin47_config = {/* Internal pull-up/down resistor is disabled */
                                                   kPORT_PullDisable,
                                                   /* Fast slew rate is configured */
                                                   kPORT_FastSlewRate,
                                                   /* Open drain is disabled */
                                                   kPORT_OpenDrainDisable,
                                                   /* Pin is configured as CMP0_IN0 */
                                                   kPORT_PinDisabledOrAnalog,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTD0 (pin 47) is configured as CMP0_IN0 */
    PORT_SetPinConfig(PORTD, 0U, &portd0_pin47_config);

    SIM->MISC_CTL = ((SIM->MISC_CTL &
                      /* Mask bits to zero which are setting */
                      (~(SIM_MISC_CTL_UART0IRSEL_MASK)))

                     /* UART0 IrDA Select: UART0 selected for IrDA modulation.
                      * UART0 TX modulated by XBAR_OUT[14] and UART0 RX input connected to XBAR_OUT[13].
                      * UARTxIRSEL cannot configure XBAR_OUT[14] and XBAR_OUT[13] automatically, and they need
                      * extra configuration in XBAR.
                      * User should configure XBAR[14:13] accordingly. */
                     | SIM_MISC_CTL_UART0IRSEL(MISC_CTL_UART0IRSEL_0b1));
    /* CMP0 Output output assigned to XBAR_IN11 input is connected
     * to XBAR_OUT13 output assigned to UART Rx IrDA Input */
    XBAR_SetSignalsConnection(XBAR, kXBAR_InputCmp0Output, kXBAR_OutputUartRxInput);
    /* iRTC Clock Output output assigned to XBAR_IN10 input is connected
     * to XBAR_OUT14 output assigned to SIM UART Tx IrDA Modulator Carrier Input */
    XBAR_SetSignalsConnection(XBAR, kXBAR_InputRtcClockOutput, kXBAR_OutputUartTxModCarrier);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPotentiometerPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '68', peripheral: ADC0, signal: 'SE, 8', pin_signal: LCD_P0/ADC0_SE8/CMP2_IN4/PTF1/QTMR0_TMR0/XBAR_OUT6, slew_rate: no_init, open_drain: no_init, pull_select: down,
    pull_enable: disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPotentiometerPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPotentiometerPins(void)
{
    /* PCTLF Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortF);

    /* PORTF1 (pin 68) is configured as ADC0_SE8 */
    PORT_SetPinMux(BOARD_ADC_POT_PORT, BOARD_ADC_POT_PIN, kPORT_PinDisabledOrAnalog);

    PORTF->PCR[1] = ((PORTF->PCR[1] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_PS_MASK | PORT_PCR_PE_MASK | PORT_PCR_ISF_MASK)))

                     /* Pull Select: Internal pulldown resistor is enabled on the corresponding pin, if the
                      * corresponding PE field is set. */
                     | PORT_PCR_PS(kPORT_PullDown)

                     /* Pull Enable: Internal pullup or pulldown resistor is not enabled on the corresponding pin. */
                     | PORT_PCR_PE(kPORT_PullDisable));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitTemp_sensorPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '69', peripheral: ADC0, signal: 'SE, 9', pin_signal: LCD_P1/ADC0_SE9/CMP2_IN5/PTF2/CMP1_OUT/RTC_CLKOUT, slew_rate: no_init, open_drain: no_init, pull_select: down,
    pull_enable: disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitTemp_sensorPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitTemp_sensorPins(void)
{
    /* PCTLF Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortF);

    /* PORTF2 (pin 69) is configured as ADC0_SE9 */
    PORT_SetPinMux(BOARD_ADC_TEMP_PORT, BOARD_ADC_TEMP_PIN, kPORT_PinDisabledOrAnalog);

    PORTF->PCR[2] = ((PORTF->PCR[2] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_PS_MASK | PORT_PCR_PE_MASK | PORT_PCR_ISF_MASK)))

                     /* Pull Select: Internal pulldown resistor is enabled on the corresponding pin, if the
                      * corresponding PE field is set. */
                     | PORT_PCR_PS(kPORT_PullDown)

                     /* Pull Enable: Internal pullup or pulldown resistor is not enabled on the corresponding pin. */
                     | PORT_PCR_PE(kPORT_PullDisable));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitLCDPins:
- options: {prefix: BOARD_, coreID: core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '18', peripheral: LCD, signal: 'P, 38', pin_signal: LCD_P38/PTB7/AFE_CLK, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '16', peripheral: LCD, signal: 'P, 36', pin_signal: LCD_P36/PTB5/SPI2_MOSI, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '14', peripheral: LCD, signal: 'P, 34', pin_signal: LCD_P34/PTB3/SPI2_SCK, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '12', peripheral: LCD, signal: 'P, 32', pin_signal: LCD_P32/PTB1/LLWU_P17, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '9', peripheral: LCD, signal: 'P, 31', pin_signal: LCD_P31/PTB0, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '7', peripheral: LCD, signal: 'P, 29', pin_signal: LCD_P29/PTA6/LLWU_P14/XBAR_IN0, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '3', peripheral: LCD, signal: 'P, 25', pin_signal: LCD_P25/PTA2, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '1', peripheral: LCD, signal: 'P, 23', pin_signal: LCD_P23/PTA0/LLWU_P16, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '23', peripheral: LCD, signal: 'P, 43', pin_signal: LCD_P43/PTC4, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '17', peripheral: LCD, signal: 'P, 37', pin_signal: LCD_P37/CMP1_IN0/PTB6, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '15', peripheral: LCD, signal: 'P, 35', pin_signal: LCD_P35/PTB4/SPI2_MISO, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '13', peripheral: LCD, signal: 'P, 33', pin_signal: LCD_P33/PTB2/SPI2_PCS0, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: LCD, signal: 'P, 50', pin_signal: LCD_P50/PTJ2, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '8', peripheral: LCD, signal: 'P, 30', pin_signal: LCD_P30/PTA7/XBAR_OUT0, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: LCD, signal: 'P, 45', pin_signal: LCD_P45/PTI5, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '2', peripheral: LCD, signal: 'P, 24', pin_signal: LCD_P24/PTA1, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '4', peripheral: LCD, signal: 'P, 26', pin_signal: LCD_P26/PTA3, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '6', peripheral: LCD, signal: 'P, 28', pin_signal: LCD_P28/PTA5/CMP0_OUT, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: LCD, signal: 'P, 44', pin_signal: LCD_P44/PTI4, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: LCD, signal: 'P, 59', pin_signal: LCD_P59/PTL6, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: LCD, signal: 'P, 57', pin_signal: LCD_P57/PTL4/EWM_OUT_b, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '87', peripheral: LCD, signal: 'P, 19', pin_signal: LCD_P19/PTH4/LPTMR1_ALT2, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '81', peripheral: LCD, signal: 'P, 13', pin_signal: LCD_P13/PTG6/LLWU_P0/LPTMR0_ALT3, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: LCD, signal: 'P, 58', pin_signal: LCD_P58/PTL5/LLWU_P23, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {peripheral: LCD, signal: 'P, 56', pin_signal: LCD_P56/PTL3/EWM_IN, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '94', peripheral: LCD, signal: 'P, 22', pin_signal: LCD_P22/PTI3/LPUART0_TX/CMP2_OUT, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '88', peripheral: LCD, signal: 'P, 20', pin_signal: LCD_P20/PTH5/LPTMR1_ALT3, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
  - {pin_num: '82', peripheral: LCD, signal: 'P, 14', pin_signal: LCD_P14/PTG7/LPTMR1_ALT1, slew_rate: fast, open_drain: disable, pull_select: down, pull_enable: disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitLCDPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitLCDPins(void)
{
    /* There are conflicts or other incorrect settings in the configuration, the code below is generated only for 
     * those registers which are set correctly and without a conflict. Open this file in Pins Tool for more details. */

    /* PCTLA Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortA);
    /* PCTLB Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortB);
    /* PCTLC Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortC);
    /* PCTLG Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortG);
    /* PCTLH Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortH);
    /* PCTLI Clock Gate Control: Clock enabled */
    CLOCK_EnableClock(kCLOCK_PortI);

    const port_pin_config_t porta0_pin1_config = {/* Internal pull-up/down resistor is disabled */
                                                  kPORT_PullDisable,
                                                  /* Fast slew rate is configured */
                                                  kPORT_FastSlewRate,
                                                  /* Open drain is disabled */
                                                  kPORT_OpenDrainDisable,
                                                  /* Pin is configured as LCD_P23 */
                                                  kPORT_PinDisabledOrAnalog,
                                                  /* Pin Control Register fields [15:0] are not locked */
                                                  kPORT_UnlockRegister};
    /* PORTA0 (pin 1) is configured as LCD_P23 */
    PORT_SetPinConfig(PORTA, 0U, &porta0_pin1_config);

    const port_pin_config_t porta1_pin2_config = {/* Internal pull-up/down resistor is disabled */
                                                  kPORT_PullDisable,
                                                  /* Fast slew rate is configured */
                                                  kPORT_FastSlewRate,
                                                  /* Open drain is disabled */
                                                  kPORT_OpenDrainDisable,
                                                  /* Pin is configured as LCD_P24 */
                                                  kPORT_PinDisabledOrAnalog,
                                                  /* Pin Control Register fields [15:0] are not locked */
                                                  kPORT_UnlockRegister};
    /* PORTA1 (pin 2) is configured as LCD_P24 */
    PORT_SetPinConfig(PORTA, 1U, &porta1_pin2_config);

    const port_pin_config_t LCD_P45 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P25 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTA2 (pin 3) is configured as LCD_P25 */
    PORT_SetPinConfig(BOARD_LCD_P45_PORT, BOARD_LCD_P45_PIN, &LCD_P45);

    const port_pin_config_t LCD_P26 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P26 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTA3 (pin 4) is configured as LCD_P26 */
    PORT_SetPinConfig(BOARD_LCD_P26_PORT, BOARD_LCD_P26_PIN, &LCD_P26);

    const port_pin_config_t LCD_P28 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P28 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTA5 (pin 6) is configured as LCD_P28 */
    PORT_SetPinConfig(BOARD_LCD_P28_PORT, BOARD_LCD_P28_PIN, &LCD_P28);

    const port_pin_config_t LCD_P29 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P29 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTA6 (pin 7) is configured as LCD_P29 */
    PORT_SetPinConfig(BOARD_LCD_P29_PORT, BOARD_LCD_P29_PIN, &LCD_P29);

    const port_pin_config_t LCD_P30 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P30 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTA7 (pin 8) is configured as LCD_P30 */
    PORT_SetPinConfig(BOARD_LCD_P30_PORT, BOARD_LCD_P30_PIN, &LCD_P30);

    const port_pin_config_t LCD_P31 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P31 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTB0 (pin 9) is configured as LCD_P31 */
    PORT_SetPinConfig(BOARD_LCD_P31_PORT, BOARD_LCD_P31_PIN, &LCD_P31);

    const port_pin_config_t LCD_P32 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P32 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTB1 (pin 12) is configured as LCD_P32 */
    PORT_SetPinConfig(BOARD_LCD_P32_PORT, BOARD_LCD_P32_PIN, &LCD_P32);

    const port_pin_config_t LCD_P33 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P33 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTB2 (pin 13) is configured as LCD_P33 */
    PORT_SetPinConfig(BOARD_LCD_P33_PORT, BOARD_LCD_P33_PIN, &LCD_P33);

    const port_pin_config_t portb3_pin14_config = {/* Internal pull-up/down resistor is disabled */
                                                   kPORT_PullDisable,
                                                   /* Fast slew rate is configured */
                                                   kPORT_FastSlewRate,
                                                   /* Open drain is disabled */
                                                   kPORT_OpenDrainDisable,
                                                   /* Pin is configured as LCD_P34 */
                                                   kPORT_PinDisabledOrAnalog,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTB3 (pin 14) is configured as LCD_P34 */
    PORT_SetPinConfig(PORTB, 3U, &portb3_pin14_config);

    const port_pin_config_t portb4_pin15_config = {/* Internal pull-up/down resistor is disabled */
                                                   kPORT_PullDisable,
                                                   /* Fast slew rate is configured */
                                                   kPORT_FastSlewRate,
                                                   /* Open drain is disabled */
                                                   kPORT_OpenDrainDisable,
                                                   /* Pin is configured as LCD_P35 */
                                                   kPORT_PinDisabledOrAnalog,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTB4 (pin 15) is configured as LCD_P35 */
    PORT_SetPinConfig(PORTB, 4U, &portb4_pin15_config);

    const port_pin_config_t LCD_P36 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P36 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTB5 (pin 16) is configured as LCD_P36 */
    PORT_SetPinConfig(BOARD_LCD_P36_PORT, BOARD_LCD_P36_PIN, &LCD_P36);

    const port_pin_config_t LCD_P50 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P37 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTB6 (pin 17) is configured as LCD_P37 */
    PORT_SetPinConfig(BOARD_LCD_P50_PORT, BOARD_LCD_P50_PIN, &LCD_P50);

    const port_pin_config_t portb7_pin18_config = {/* Internal pull-up/down resistor is disabled */
                                                   kPORT_PullDisable,
                                                   /* Fast slew rate is configured */
                                                   kPORT_FastSlewRate,
                                                   /* Open drain is disabled */
                                                   kPORT_OpenDrainDisable,
                                                   /* Pin is configured as LCD_P38 */
                                                   kPORT_PinDisabledOrAnalog,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   kPORT_UnlockRegister};
    /* PORTB7 (pin 18) is configured as LCD_P38 */
    PORT_SetPinConfig(PORTB, 7U, &portb7_pin18_config);

    const port_pin_config_t LCD_P43 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P43 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTC4 (pin 23) is configured as LCD_P43 */
    PORT_SetPinConfig(BOARD_LCD_P43_PORT, BOARD_LCD_P43_PIN, &LCD_P43);

    const port_pin_config_t LCD_P13 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P13 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTG6 (pin 81) is configured as LCD_P13 */
    PORT_SetPinConfig(BOARD_LCD_P13_PORT, BOARD_LCD_P13_PIN, &LCD_P13);

    const port_pin_config_t LCD_P14 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P14 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTG7 (pin 82) is configured as LCD_P14 */
    PORT_SetPinConfig(BOARD_LCD_P14_PORT, BOARD_LCD_P14_PIN, &LCD_P14);

    const port_pin_config_t LCD_P19 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P19 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTH4 (pin 87) is configured as LCD_P19 */
    PORT_SetPinConfig(BOARD_LCD_P19_PORT, BOARD_LCD_P19_PIN, &LCD_P19);

    const port_pin_config_t LCD_P20 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P20 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTH5 (pin 88) is configured as LCD_P20 */
    PORT_SetPinConfig(BOARD_LCD_P20_PORT, BOARD_LCD_P20_PIN, &LCD_P20);

    const port_pin_config_t LCD_P22 = {/* Internal pull-up/down resistor is disabled */
                                       kPORT_PullDisable,
                                       /* Fast slew rate is configured */
                                       kPORT_FastSlewRate,
                                       /* Open drain is disabled */
                                       kPORT_OpenDrainDisable,
                                       /* Pin is configured as LCD_P22 */
                                       kPORT_PinDisabledOrAnalog,
                                       /* Pin Control Register fields [15:0] are not locked */
                                       kPORT_UnlockRegister};
    /* PORTI3 (pin 94) is configured as LCD_P22 */
    PORT_SetPinConfig(BOARD_LCD_P22_PORT, BOARD_LCD_P22_PIN, &LCD_P22);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
