/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef APPLICATION_H
#define APPLICATION_H

#include "common.h"
#include "appstructures.h"
#include "RTCDriver.h"
#include "MeteringLPRT.h"
#include "Calibration1Ph.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define VER_NO 0001u

#define IRC_2MHZ_CLOCK                          2048000uL

typedef struct
{
  uint32 BusClk;        /* Holds the Bus clock of the MCU */
  uint32 SysClk;        /* Holds the system clock of the MCU */
  uint8  PowerMode;     /* Holds the power mode of the meter */
  uint8  MetMode;       /* Holds the current metering mode of the meter */
} tSystemState;

extern uint32 LLWUStatus;
extern tSystemState SystemState;
extern tMETERLIBLPRT1PH_DATA mlib1phdata;
extern tCalibPoint1Ph  CalibPoint;
/*******************************************************************************
* Prototypes
******************************************************************************/
extern void InitModules(void);
extern void DoPulsing1Ph(void);
extern void TMR2callback(void);
extern void LLWU_Init(void);
#endif
