/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __EEPROMADDRS_H
#define __EEPROMADDRS_H

#include "common.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define CALIBADDRESS      0xFF10		/* Address where Calibration structure value of the meter is saved */
#define CALIBBKPADDR      0x0010		/* Address of the backup of Calibration structure */

#define EEPROMERASELOG    0xFFBC		/* Address of EEPROM erase log */
#define RTCCHNGUTCTIME    0xFFE0		/* Address where last RTC programming time is stamped */
#define NVM_VALIDITY      0xFFE4		/* Reserved address to test a write-read-verify test of EEPROM */
#define CALIBLOCKADDR     0xFFE8		/* Address to store a state that meter calibration is now blocked/unblocked */

#define ENERGYADDRESS     0xFE10		/* Address to store energy registers */ 

#define GeneralAddr       0x0180		/* Address to store few meter metadata */
#define zSRNO             8				/* Size of meter serial no in bytes */
#define zSRNORES          8				/* Total reserved size to store meter serial no in bytes */
#define zLOTNO            10			/* Size to store LOT number of the meter, in bytes */
#define zPCBNO            10			/* Size to store PCB number of the meter, in bytes */
#define zDEFSIGN          2				/* Size to store a sign to indicate the meter in production */
#define zBOOTPWDSIGN      2				/* Size to store a sign for bootmode password */
#define zBOOTPWD          (16+1)        /* Size to store bootmode password, 1 extra byte for the trailing '\0' character */

#define EEPDEFSIGN        0xDEAF		/* A sign to indicate meter is in production/calibration */
#define SRNOAddr          GeneralAddr           /* Address where meter serial no is saved */
#define MeterManuAddr     GeneralAddr+zSRNORES  /* Address where meter manufacturing date is saved */
#define ManuTime          MeterManuAddr+2       /* Address where meter manufacturing time is saved */
#define MemSignAddr       ManuTime+4       /* Address to store a sign to indicate that few 
                                        meter metadata can be initialized during the 1st time of meter initialization */
#define LotNoAddr         MemSignAddr+4			/* Address to store meter LOT number */
#define PCBNoAddr         LotNoAddr+zLOTNO              /* Address to store meter PCB number */
#define DefSignAddr       PCBNoAddr+zPCBNO              /* Address to store meter production/phase state */

#define DiscnCtrlAddr     0x0480        /* Reserved 0x10 bytes */
#define METRECTYPE        0x0490
#define ImageTrnfInfoAddr 0x09D0        /* Reserved 0x200 bytes */

#define DispAddr          0x0BD0	/* Address to store display function related metadata */

#define EPRTestAddr       0x0C00
#define FWBaseAddr    0x10000
#define MAX_IMAGE_SIZE (0x40000 - FWBaseAddr)
/*******************************************************************************
* Prototypes
******************************************************************************/
#endif