/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __EEPROMDriver_H
#define __EEPROMDriver_H

#include "common.h"
#include "iic_config.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define MEMSIGN                     0xDEADBED7
/* Macros related to EEPROM */
#define NVMEM_MAX_ADDR              (uint32)0x7FFF
#define NVMEM_FU_MAX_ADDR           (uint32)0x3FFFF             /* NVMEM for Communication FW secondary image storage */
/** Page boundary for EEPROM */
#define PAGE_BITS                   (uint8)8
#define PAGE_BOUNDARY               (uint32)(1<<PAGE_BITS)

#define EEPSIGNADDR                 EEPROMERASELOG
#define EEPERASECNT                 EEPSIGNADDR+2
#define EEPERASELOG                 EEPERASECNT+2

#define EEPERASESIGN                0xBEED

/*******************************************************************************
* Prototypes
******************************************************************************/
extern volatile uint8 I2CTimeout;
extern uint8 I2CStuck;

extern uint8 NVWriteIIC(uint32 Address, uint8 *Buffer, uint16 NBytes);
extern uint8 NVReadIIC(uint32 Address, uint8 *Buffer, uint16 NBytes);
extern void  DoEEPROMTest(void);
/*
 * -------------------------------------------
 * NV Memory Driver Global Function Prototypes
 * -------------------------------------------
 */

#endif