/*
 * Copyright (c) 2018-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __VERIFY_FW_H
#define __VERIFY_FW_H

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define FLASH_BYTE_PROG_SIZE    16
#define FW_BUFFER_LEN   128 
#define IMAGE_VERIFY_TIMEOUT (5)    /* in seconds */
#define MAX_DESC                        4
#define FLASH_SECTOR_SIZE               2048

enum
{
  IMAGE_VERIFY,
  IMAGE_ACTIVATE,
};
/*******************************************************************************
* Prototypes
******************************************************************************/
extern uint8  fw_buffer[FW_BUFFER_LEN];
extern uint8 ImageVerifyTO;
extern void InitializeFlash(void);
extern void VerifyFW(uint32 dest_start_address, uint32 length, uint32 *file_checksum, int16 *ret_val);

#endif
