/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#include "Defines.h"
#include "UserInterface.h"
#include "Timer.h"
#include "MeteringLPRT.h"
#include "Application.h"
#include "RTCDriver.h"
#include "ComPortDriver.h"
#include "EEPROMDriver.h"
#include "PowerModes.h"
#include "MeteringInterface1Ph.h"
#include "IOControls.h"
#include "fsl_qtmr.h"
#include "UpgradeFW.h"
#include "ComPortDriver.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define GPTimerEventHandler                     TMR1_IRQHandler
#define SecondTimerCallback                     TMR0_IRQHandler
/*******************************************************************************
* Prototypes
******************************************************************************/
uint8  MeterUnlockTimer;
uint8  BattPBDisabled;
uint16 BattPBTimeout;
uint8 TickOneSec = FALSE;       /* used to indicate application one second passed, and to do any job every one sec */
uint16 MagStatus;
void SecondTimerCallback(void);

/*******************************************************************************
 * Code
 ******************************************************************************/
 /*!
 * @brief Initializes a tick timer and second timer which are used for various 
 * timing and control for meter application.
 */
void GPTimerModuleInit(void)
{
  uint32 ModValue = 0;
  uint16 SecTmrModVal;
  qtmr_config_t qtmrConfig;
  
  /*
  Initliazing the Configurable timer
  It will use Quad Timer 1
  Enable the Quad Timer Clock
  Interrupt Frequency Desired= 25ms
  Interrupt Frequency in terms of Bus Clock= (Interrupt Time*Bus Freq)
  Configuring the timer in Free Running Mode
   */
  ModValue = SystemState.BusClk/1000 ;

  switch (SystemState.PowerMode)
  {
    case POWERMODE_MAINS:
      ModValue = ModValue / 128;
      ModValue=ModValue* INTERRUPT_FREQUENCY;
      QTMR_GetDefaultConfig(&qtmrConfig);
      
      /* Set clock prescaler */
      qtmrConfig.primarySource = kQTMR_ClockDivide_128;
      QTMR_Init(TMR1, &qtmrConfig);
      
      QTMR_SetTimerPeriod(TMR1, ModValue);
      
      /* Enable timer compare interrupt */
      QTMR_EnableInterrupts(TMR1, kQTMR_CompareInterruptEnable);
      
      /* Enable at the NVIC */
      NVIC_SetPriority(TMR1_IRQn, TMR1_INTERRUPT_PRIORITY);
      EnableIRQ(TMR1_IRQn);
      
      /* Start timer */
      QTMR_StartTimer(TMR1, kQTMR_PriSrcRiseEdge);      

      SecTmrModVal = SystemState.BusClk >> 7;
      QTMR_Init(TMR0, &qtmrConfig);
      
      QTMR_SetTimerPeriod(TMR0, SecTmrModVal);
      
      /* Enable timer compare interrupt */
      QTMR_EnableInterrupts(TMR0, kQTMR_CompareInterruptEnable);
      
      /* Enable at the NVIC */
      NVIC_SetPriority(TMR0_IRQn, TMR3_INTERRUPT_PRIORITY);
      EnableIRQ(TMR0_IRQn);
      
      /* Start timer */
      QTMR_StartTimer(TMR0, kQTMR_PriSrcRiseEdge);
      break;

    case POWERMODE_BAT:
      SecTmrModVal = SystemState.BusClk >> 4;
      ModValue=ModValue* INTERRUPT_FREQUENCY;
      
      QTMR_GetDefaultConfig(&qtmrConfig);
      
      /* Set clock prescaler */
      qtmrConfig.primarySource = kQTMR_ClockDivide_1;
      QTMR_Init(TMR1, &qtmrConfig);
      
      QTMR_SetTimerPeriod(TMR1, ModValue);
      
      /* Enable timer compare interrupt */
      QTMR_EnableInterrupts(TMR1, kQTMR_CompareInterruptEnable);
      
      /* Enable at the NVIC */
      NVIC_SetPriority(TMR1_IRQn, TMR1_INTERRUPT_PRIORITY);
      EnableIRQ(TMR1_IRQn);
      
      /* Start timer */
      QTMR_StartTimer(TMR1, kQTMR_PriSrcRiseEdge);
	  
      SecTmrModVal = SystemState.BusClk >> 4;
      /* Set clock prescaler */
      qtmrConfig.primarySource = kQTMR_ClockDivide_16;
      QTMR_Init(TMR0, &qtmrConfig);
      
      QTMR_SetTimerPeriod(TMR0, SecTmrModVal);
      
      /* Enable timer compare interrupt */
      QTMR_EnableInterrupts(TMR0, kQTMR_CompareInterruptEnable);
      
      /* Enable at the NVIC */
      NVIC_SetPriority(TMR0_IRQn, TMR3_INTERRUPT_PRIORITY);
      EnableIRQ(TMR0_IRQn);
      
      /* Start timer */
      QTMR_StartTimer(TMR0, kQTMR_PriSrcRiseEdge);
      break;
  }
}

 /*!
* @brief Implements the callback function of high resoution timing for timing 
* and control of meter application.
*/
void GPTimerEventHandler(void)
{
  /* Clear interrupt flag.*/
  QTMR_ClearStatusFlags(TMR1, kQTMR_CompareFlag);
  
  if (I2CTimeout)
  {
    I2CTimeout--;
  }
  
  if ((GPIO_GET_PB) == PB_ACTIVE_LEVEL)
  {
    if (SystemState.MetMode == METMODE_NONE)
    {
      if (BattPBTimeout == 0)
      {
        BattPBTimeout = BATTPBTO;
      }
    }
    //if (DownDetected == FALSE)
    {
      {
        DownScroll = TRUE;
      }
      DownDetected = TRUE;
    }
  }
  else
  {
    BattPBDisabled = FALSE;
    DownDetected = FALSE;
  }

  if (BattPBDisabled == TRUE)
  {
    DownDetected = FALSE;
    DownScroll = FALSE;
  }
  
  SDK_ISR_EXIT_BARRIER;
}

 /*!
 * @brief Implements the callback of a timer with tick-a-second resoluton, 
 * used to time and control various activities in the meter application.
 */
void SecondTimerCallback(void)
{
  uint8 i;
  
  TickOneSec = TRUE;
  
  /* Clear interrupt flag.*/
  QTMR_ClearStatusFlags(TMR0, kQTMR_CompareFlag);
  
  /*
   LCD refresh timeout
   */
  if (lcd_refresh_count)
  {
    lcd_refresh_count--;
  }

  /*
   LCD scrolling timeout.
   */
  if (lcd_scroll_count)
  {
    lcd_scroll_count--;
  }

  /* Battery mode settle down time */
  if (SystemState.PowerMode == POWERMODE_BAT)
  {
    if (BattModeTimeout)
    {
      BattModeTimeout--;
      if (BattModeTimeout == 0)
      {
        TurnLatchOff = TRUE;
      }
    }
  }
  
  
  /* Communications */
  for(i=0; i<NUM_UART_CHANNEL; i++)
  {
    if (UARTTimeout[i])
    {
      UARTTimeout[i]--;
    }
    else
    {
      UartPortStatus[i] = UART_IDLE;
    }
  } 
  
  if(DontCheckEOLTimeout)
  {
    DontCheckEOLTimeout--;
    
    if(DontCheckEOLTimeout == 0)
    {
      DontCheckEOLCount = 0;
      UartPortStatus[UART_OPTICAL_INDEX] = UART_IDLE;
    }
  }
  
  if (MeterUnlockTimer)
  {
    MeterUnlockTimer--;
    if (MeterUnlockTimer == 0)
    {
      MeterUnlocked = FALSE;
    }
  }
  
  if ((SystemState.MetMode == METMODE_MAINS) && (mlib1phdata.IrmsNoFudge[mlib1phdata.CurToUse] > 0.100))
  {
    MagStatus &= 0x00FF;
    MagStatus <<= 1;
    if ((GPIO_GET_MAG) == MAG_ACTIVE_LEVEL)
    {
      MagStatus |= 1;
    }
#if defined(MAG2)
    if ((GPIO_GET_MAG2) == MAG2_ACTIVE_LEVEL)
    {
      MagStatus |= 1;
    }
#endif
  }
  SDK_ISR_EXIT_BARRIER
}

