/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2019, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef __METERINGINTERFACE1PH_H
#define __METERINGINTERFACE1PH_H

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define NSAMPLES 3000
#define METERCONSTANT 3200

#define ENERSIGN 0xABCDEFFC

#define NOMET_TO (8)
#define PLL_FREQ 12288000

#define SECSIN1HR 3600
#define POWERTOENERGY      (74.56540444) //(46.603375)
#define POWERTOENERGY_SWR  (POWERTOENERGY)
#define IRMSTHRESHOLD_SWR  (0.230)
#define SWB_SAMPLINGTIME   (5)
#define SWB_SAMPLINGTIME_NIGHT  (30)
#define SWB_SAMPPULSETIME  (1)

#define MAXUNITSIN15MINS   (7)   

//#define CALIBLED_COMPARE    0x03D09000
//#define CALIBLED_COMPARE    0x01E84800
//#define CALIBLED_COMPARE    0x03333330
#define CALIBLED_COMPARE      0x051EB851

#define ONCOUNTS 40

#if (NSAMPLES==1500)
#define AFE_OSR    kAFE_DecimatorOversampleRatio512
#define QCYCLEFACTOR 0.00066666
#endif
#if (NSAMPLES==3000)
#define AFE_OSR    kAFE_DecimatorOversampleRatio256
#define QCYCLEFACTOR 0.000333333
#endif
#if (NSAMPLES==6000)
#define AFE_OSR    DEC_OSR256
#define QCYCLEFACTOR 0.0001666666
#endif

#define PERIOD_ACCUMULATION_CYCLES 10
/* Would like to drive TMR by 1.5 MHz so that for 50 Hz i.e., 20 msec 
 * cross over does not roll over the timer count more than once. */
#define TMR_CNTS_50HZ (BUS_CLOCK/50/4)  /* when BUS_CLOCK is 6MHz */
//#define TMR_CNTS_50HZ (BUS_CLOCK/50/8) /* when BUS_CLOCK is 12MHz */       
#define TMR_CNTS_50HZ_ND (BATTERY_FREQ/50/2)

#define IOVERLOAD 91.0f
#define VBASIC    240.0f

#define IBASIC    10.0f
#define IMAX      60.0f
#define IOVER     65.0f
#define IOVERLOAD 91.0f
#define VBASIC    240.0f
/*******************************************************************************
* Prototypes
******************************************************************************/   
extern uint8  NoMetTO;
extern uint8  ResetPLL;
extern uint32 ActAccumulator;
extern uint32 ReactAccumulator;
/******************************************************************************
 * public function prototypes                                                 *
 ******************************************************************************/
extern void  V_Callback(void);
extern void  RelaySense_Callback(void);
extern void TMR2callback(void);
extern void TMR2callbackND(void);
extern void TMR2LPcallback(void);
extern void InitAFE_SWR(void);
extern void InitLPTMR(void);
extern void InitVREF(void);

extern void CheckForSnglWrBattMtrng(void);
extern void DoAnalogHealthCheck(void);
extern void CalibMemwrite1Ph(void);
extern void SetCalibPhase(uint8 CalibPhase);
extern void UpdateCalib(uint32 Address);
extern uint8 ReadVerifyCalib1Ph(uint32 Address);
extern void MeteringInit(void);
#endif /* __METERINGINTERFACE3PH_H */
