/*
 * Copyright (c) 2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef POWERMODES_H
#define POWERMODES_H
#include "Application.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define BattModeTO (15)

typedef enum
{
  POWERMODE_MAINS,
  POWERMODE_BAT,
  nPOWERMODES
} POWERMODES;

typedef enum
{
  METMODE_MAINS,
  METMODE_SWR,
  METMODE_NONE,
  nMETMODES
} METMODES;

/*******************************************************************************
* Prototypes
******************************************************************************/
extern uint8 MainsOn;
extern uint8 TurnLatchOff;
extern uint8 BattModeTimeout;

extern void ClockModuleInit(void);
extern void DoPowerStatus(void);
extern void GoToSleep(void);
extern void ShutDownIPs(void); 
#endif // POWERMODE_H
