/*
 * Copyright (c) 2010-2016, Freescale Semiconductor, Inc.
 * Copyright (c) 2016-2021, NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef __COMMON_H
#define __COMMON_H

/******************************************************************************
 * List of the basic configuration structure macros
 *
 *//*! @addtogroup config_struct_macros
 * @{
 ******************************************************************************/
/***************************************************************************//*!
 * @brief   Sets register field in peripheral configuration structure.
 * @details This macro sets register field <c>mask</c> in the peripheral
 *          configuration structure.
 * @param   mask  Register field to be set.
 * @note    Implemented as an inline macro.
 ******************************************************************************/
#define SET(mask)   (mask)

/***************************************************************************//*!
 * @brief   Clears register field in peripheral configuration structure.
 * @details This macro clears register field <c>mask</c> in the peripheral
 *          configuration structure.
 * @param   mask  Register field to be cleared.
 * @note    Implemented as an inline macro.
 ******************************************************************************/
#define CLR(mask)   0
/*! @} End of config_struct_macros                                            */

/******************************************************************************
 * channel mask definition used by various drivers.
 *
 *//*! @addtogroup channel_mask
 * @{
 ******************************************************************************/
#define CH0   (1 << 0)  ///< Channel 0
#define CH1   (1 << 1)  ///< Channel 1
#define CH2   (1 << 2)  ///< Channel 2
#define CH3   (1 << 3)  ///< Channel 3
/*! @} End of channel_mask                                                    */

/******************************************************************************
 * Definition of common aliases                                               *
 ******************************************************************************/
#if defined(__ICCARM__) || defined(__CC_ARM)
  #define weak  __weak
#elif defined(__GNUC__)
  #define weak  __attribute__((weak))
#endif

/******************************************************************************
 * Toolchain check                                                            *
 ******************************************************************************/
#if !defined(__ICCARM__) && !defined(__GNUC__) && !defined(__CC_ARM)
  #error "Toolchain is not supported."
#endif

/******************************************************************************
 * Include common header file                                                 *
 ******************************************************************************/
#include "types.h"              /* Basic data types and conversion macros     */
#include "appconfig.h"          /* User configuration structures              */
#include "MKM35Z7.h"    /* Device header file                         */

#endif /* __COMMON_H */