/*
 * Copyright (c) 2018, NXP, Inc.
 * Copyright 2017-2018 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * How to set up clock using clock driver functions:
 *
 * 1. Setup clock sources.
 *
 * 2. Set up all dividers.
 *
 * 3. Set up all selectors to provide selected clocks.
 */

#include "fsl_power.h"
#include "fsl_clock.h"
#include "clock_config.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/
/* System clock frequency. */
extern uint32_t SystemCoreClock;

/*******************************************************************************
 ********************* Configuration BOARD_BootClockFRO12M ***********************
 ******************************************************************************/

/*******************************************************************************
 * Variables for BOARD_BootClockFRO18M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFRO18M configuration
 ******************************************************************************/
void BOARD_BootClockFRO18M(void)
{
    POWER_DisablePD(kPDRUNCFG_PD_FRO_OUT); /*!< Ensure FRO is on  */
    POWER_DisablePD(kPDRUNCFG_PD_FRO);     /*!< Ensure FRO is on  */
    /*!< Set Main clock source to FRO */
    CLOCK_SetMainClkSrc(kCLOCK_MainClkSrcFro);
    /*!< Set up FRO to the 18 MHz*/
    CLOCK_SetFroOscFreq(kCLOCK_FroOscOut18M);
    /*!< Set up AHBCLKDIV to value 1 */
    CLOCK_SetCoreSysClkDiv(1U);
    /*!< Set Main clock source to FRO */
    CLOCK_SetMainClkSrc(kCLOCK_MainClkSrcFro);
    /*!< Set SystemCoreClock variable. */
    SystemCoreClock = BOARD_BOOTCLOCKFRO18M_CORE_CLOCK;
}

/*******************************************************************************
 ********************** Configuration BOARD_BootClockFRO24M ***********************
 ******************************************************************************/

/*******************************************************************************
 * Variables for BOARD_BootClockFRO24M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFRO24M configuration
 ******************************************************************************/
void BOARD_BootClockFRO24M(void)
{
    POWER_DisablePD(kPDRUNCFG_PD_FRO_OUT); /*!< Ensure FRO is on  */
    POWER_DisablePD(kPDRUNCFG_PD_FRO);     /*!< Ensure FRO is on  */
    /*!< Set Main clock source to FRO */
    CLOCK_SetMainClkSrc(kCLOCK_MainClkSrcFro);
    /*!< Set up FRO to the 24 MHz*/
    CLOCK_SetFroOscFreq(kCLOCK_FroOscOut24M);
    /*!< Set up AHBCLKDIV to value 1 */
    CLOCK_SetCoreSysClkDiv(1U);
    /*!< Set Main clock source to FRO */
    CLOCK_SetMainClkSrc(kCLOCK_MainClkSrcFro);
    /*!< Set SystemCoreClock variable. */
    SystemCoreClock = BOARD_BOOTCLOCKFRO24M_CORE_CLOCK;
}

/*******************************************************************************
 ********************* Configuration BOARD_BootClockFRO30M **********************
 ******************************************************************************/

/*******************************************************************************
 * Variables for BOARD_BootClockFRO30M configuration
 ******************************************************************************/
/*******************************************************************************
 * Code for BOARD_BootClockFRO30M configuration
 ******************************************************************************/
void BOARD_BootClockFRO30M(void)
{
    POWER_DisablePD(kPDRUNCFG_PD_FRO_OUT); /*!< Ensure FRO is on  */
    POWER_DisablePD(kPDRUNCFG_PD_FRO);     /*!< Ensure FRO is on  */
    /*!< Set Main clock source to FRO */
    CLOCK_SetMainClkSrc(kCLOCK_MainClkSrcFro);
    /*!< Set up FRO to the 30 MHz*/
    CLOCK_SetFroOscFreq(kCLOCK_FroOscOut30M);
    /*!< Set up AHBCLKDIV to value 1 */
    CLOCK_SetCoreSysClkDiv(1U);
    /*!< Set Main clock source to FRO */
    CLOCK_SetMainClkSrc(kCLOCK_MainClkSrcFro);
    /*!< Set SystemCoreClock variable. */
    SystemCoreClock = BOARD_BOOTCLOCKFRO30M_CORE_CLOCK;
}



