/*! *********************************************************************************
 * \addtogroup can and lin common api
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2018 NXP
* All rights reserved.
*
* \file
*
* This file is the source file for the CAN and LIN
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

#ifndef CAN_LIN_COMMON_H
#define CAN_LIN_COMMON_H

#include "EmbeddedTypes.h"
#include "LED.h"
#include "pin_mux.h"
/*************************************************************************************
**************************************************************************************
* Public macros
**************************************************************************************
*************************************************************************************/
#define gLinkMonitorNumMax  4

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/
typedef struct link_monitor_para_tag
{
    uint8_t channelLastUnmaped;
    uint8_t tableUsedchannels[37];
    uint8_t numUsedchannel;
    uint8_t chM[5];
    uint8_t hopIncrement;
    uint16_t CI;                 //Connection Interval
    
    uint32_t syncAddress;
    uint32_t crcSeed;
    uint32_t connStatus;
}link_monitor_para_t;

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
extern link_monitor_para_t gLMPara;
extern link_monitor_para_t gLMParaArry[gLinkMonitorNumMax];
/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

extern void GfskApp_InitCAN_LIN(void);
extern void GfskApp_StartLM(void);


#ifdef __cplusplus
}
#endif


#endif /* CAN_LIN_COMMON_H */

/*! *********************************************************************************
 * @}
 ********************************************************************************** */
