/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SOURCE_LIN_CFG_H_
#define SOURCE_LIN_CFG_H_
   
#include "fsl_lin.h"   

#define LIN_NUM_OF_SLAVE_IFCS 1U
#define LIN_NUM_OF_MASTER_IFCS 0U

/* Size of configuration in ROM and RAM used for interface: LI0 */
#define LI0_LIN_SIZE_OF_CFG      4U

/* Number of frames */
#define LIN_NUM_OF_FRMS          3U

/* Number of interfaces */
#define LIN_NUM_OF_IFCS          1U

/* Maximal timeout to settle in idle state */
#define MAX_IDLE_TIMEOUT_CNT     10000

/* frame buffer size */
#define LIN_FRAME_BUF_SIZE       11U
#define LIN_FLAG_BUF_SIZE        4U

typedef enum 
{
    gID_Cmd_c = 0x31,
    gID_GetStatus_c,
    gID_Data_c
} lin_id_t;







/*! @brief  Table to save node atrribute structure pointers */
extern const lin_node_attribute      g_lin_node_attribute_array[LIN_NUM_OF_SLAVE_IFCS];

/*! @brief Table to save LIN protocol state structure pointers */
extern const lin_protocol_user_config_t g_lin_protocol_user_cfg_array[LIN_NUM_OF_IFCS];

/*! @brief Table to save LIN protocol state structure pointers */
extern lin_protocol_state_t g_lin_protocol_state_array[LIN_NUM_OF_IFCS];

/*! @brief Frame signal array */
extern uint8_t g_lin_frame_data_buffer[LIN_FRAME_BUF_SIZE];

/*! @brief Table of interface flag handles */
extern uint8_t g_lin_flag_handle_tbl[LIN_FLAG_BUF_SIZE];

#if LIN_NUM_OF_MASTER_IFCS
#define LinOtaStartCallback  lin_ota_start
#else
#define LinOtaStartCallback  NULL
#endif

#endif /* SOURCE_LIN_CFG_H_ */
