/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * 
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "app_preinclude.h"


#ifndef SOURCE_FLEXCAN_CFG_H_
#define SOURCE_FLEXCAN_CFG_H_

#define gCanOtaMaster_c          1
#define gCanOtaSlave_c           2
#define gCanOtaRole_d            gCanOtaMaster_c

/* Size of each ota block */
#define CAN_OTA_BLOCK_SIZE       (1024U)

/* lin frames of each ota block */
#define CAN_OTA_FRAMES_OF_BLOCK  (CAN_OTA_BLOCK_SIZE / 8)

#define CAN_TX_IDENTIFIER        (0x123)
#define CAN_RX_IDENTIFIER        (0x321)


typedef enum
{
    CAN_GEN_CMD_NONE = 0x00,
    CAN_GEN_CMD_OTA_CMD,
    CAN_GEN_CMD_OTA_DATA,
    CAN_GEN_CMD_OTA_STATUS,
    CAN_GEN_CMD_GET_DEV_ID,
    CAN_GEN_CMD_TX_LM_PARA,
} can_general_cmd_t;

typedef enum
{
    CAN_OTA_CMD_NONE = 0x00,
    CAN_OTA_CMD_START,
    CAN_OTA_CMD_END,
    CAN_OTA_CMD_CONTINUE
} can_ota_cmd_c;

typedef enum 
{
    CAN_OTA_STATUS_IDLE = 0x00,
    CAN_OTA_STATUS_READY,
    CAN_OTA_STATUS_RUNNING,
    CAN_OTA_STATUS_FINISH,
    CAN_OTA_STATUS_ABORT
} can_ota_status_t;

typedef enum
{
    CAN_OTA_STAGE_IDLE = 0x00,
    CAN_OTA_STAGE_TX_DATA,
    CAN_OTA_STAGE_END        
} can_ota_stage_t;

typedef enum 
{
    CAN_OTA_RX_ACK_SUCCESS = 0x00,
    CAN_OTA_RX_ACK_ERROR,
} can_ota_rx_ack_t;


extern uint32_t g_can_ota_image_length;
extern uint32_t g_can_read_flash_offset;

void can_set_to_rx_mode();
void can_tx_data(uint8_t data[], uint8_t length);
void can_rx_process(void);
void can_tx_process(void);
extern void can_ota_start(void);


#if (gOtaUseBusSelection_d == gOtaUseBus_CAN_c) && (gCanOtaRole_d == gCanOtaMaster_c)
#define CanOtaStartCallback  can_ota_start
#else
#define CanOtaStartCallback  NULL
#endif

#endif /* SOURCE_FLEXCAN_CFG_H_ */
