/*! *********************************************************************************
 * \addtogroup can and lin common api
 * @{
 ********************************************************************************** */
/*! *********************************************************************************
* Copyright (c) 2015, Freescale Semiconductor, Inc.
* Copyright 2016-2018 NXP
* All rights reserved.
*
* \file
*
* This file is the source file for the CAN and LIN
*
* SPDX-License-Identifier: BSD-3-Clause
********************************************************************************** */

#ifndef CAN_LIN_COMMON_H
#define CAN_LIN_COMMON_H

#include "EmbeddedTypes.h"
#include "ble_general.h"
/*************************************************************************************
**************************************************************************************
* Public macros
**************************************************************************************
*************************************************************************************/
#define BTLE_NONE        0
#define BTLE_CONNECT     1
#define BTLE_DISCONN     2

/************************************************************************************
*************************************************************************************
* Public type definitions
*************************************************************************************
************************************************************************************/
typedef struct link_monitor_para_tag
{
    uint8_t channelLastUnmaped;
    uint8_t tableUsedchannels[37];
    uint8_t numUsedchannel;
    uint8_t chM[5];
    
    uint8_t hopIncrement;
    uint16_t CI;                 //Connection Interval     
    uint32_t syncAddress;
    uint32_t crcSeed; 
    uint8_t peerDeviceId;
    uint8_t connOrDisconn;
}link_monitor_para_t;

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
********************************************************************************** */
extern bool_t gLMConnectionReady;
extern link_monitor_para_t gLMPara;
/************************************************************************************
*************************************************************************************
* Public prototypes
*************************************************************************************
************************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

extern void LM_GetConnInfo(deviceId_t peerDeviceId, uint8_t connOrDisconn);


#ifdef __cplusplus
}
#endif


#endif /* CAN_LIN_COMMON_H */

/*! *********************************************************************************
 * @}
 ********************************************************************************** */
