/*
 * FreeRTOS Kernel V10.2.0
 * Copyright (C) 2019 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * http://www.FreeRTOS.org
 * http://aws.amazon.com/freertos
 *
 * 1 tab == 4 spaces!
 */

#ifndef BLE_FSCI_H
#define BLE_FSCI_H

#include "gap_types.h"
#include "gatt_server.h"
#include "gattdb_interface.h"

/* Max request size set to 128,
 * if user have FSCI request command size more than it
 * then increase it accordingly */
#define MAX_REQUEST_SIZE 128

typedef enum
{
	bleGATT = 0x45,
	bleGATTDB = 0x46,
	bleGAP = 0x48,
}bleOpGroupType_t;

typedef enum
{
	/* GATT DB opcode */
	gattDBWriteAttribute = 0x02,
	gattDBReadAttribute = 0x03,
	gattDBFindServiceHandle = 0x04,
	gattDBFindCharValueHandleInService = 0x05,
	gattDBFindCccdHandleForCharValHandle = 0x06,
	gattDBFindDescHandleForCharvalHandle = 0x07,
	gattDBInit	= 0x08,
	gattDBReleaseDB	= 0x09,
	gattDBAddPrimaryService = 0x0A,
	gattDBAddSecondaryService = 0x0B,
	gattDBAddCharDescAndValue = 0x0D,
	gattDBAddCharDescriptor = 0x0E,
	gattDBAddCccd = 0x0F,

}bleGATTDBOpCodeType_t;

typedef enum
{
	/* Client opcode */
	gattDiscAllCharDesc	= 0x0E,

	/* Server opcode */
	gattServerCallbackRegister = 0x16,
	gattSendNotification = 0x19,
}bleGATTOpCodeType_t;

typedef enum
{
	/* GAP Event opcode */
	gapSetAdvParameter	= 0x03,
	gapSetAdvData = 0x04,
	gapStartAdvertisement = 0x05,
	gapStopAdvertisement = 0x06,
	gapCheckNotificationStatus = 0x09,
	gapDisconnect = 0x1D,
}bleGAPOpCodeType_t;

typedef enum
{
	gapConfirm = 0x80,
	gapCheckNotfStatusResp = 0x81,
	gapAdvDataSetupComp = 0x8D,
	gapAdvParamSetupComp = 0x8C,
	gapAdvSetupFailed = 0x8B,
	gapAdvEventStateChanged = 0x98,
	gapAdvEventFailed = 0x99,
	gapConnectionEventConnected = 0x9D,
	gapConnectionEventDisConnected = 0xAA,
	gapConnEventLEDataLenChanged = 0xB0,
}bleGapRespOpCodeType_t;

typedef enum
{
	gattConfirm = 0x80,
	gattMTUChanged = 0x91,
	gattCharCccdWritten = 0x94,
}bleGATTRespOpCodeType_t;

typedef enum
{
	gattDBConfirm = 0x80,
	gattDBAddPrimServResp = 0x86,
	gattDBAddSecServResp = 0x87,
	gattDBAddCharDeclandValResp = 0x89,
	gattDBAddCharDescResp = 0x8A,
	gattDBAddCccdResp = 0x8B,
	gattDBReadAttrResp = 0x81,
	gattDBFindSerHandleResp = 0x82,
	gattDBFindCharValHandleResp = 0x83,
	gattDBFindCccdHandleResp = 0x84,
	gattDBFindDescHandleResp = 0x85,
}bleGATTDBRespOpCodeType_t;

typedef struct msgBLEabsToFSCI_tag{
	uint8_t opGroup;
	uint8_t opCode;
	uint8_t length;
	union{
		gattServerSendNotificationReq_t sendNotification;
		gapAdvertisingParameters_t advParameter;
		gapSetAdvertisingData_t setadvData;
		gapScanResponseData_t scanRespData;
		gapCheckNotificationStatus_t checkNotificationStatus;
		gapDisconnect_t disConnect;
		gattDBAddPrimaryServiceReq_t addPrimaryService;
		gattDBAddSecondaryServiceReq_t addSecondaryService;
		gattDBAddCharDecandValueReq_t addCharDecandValue;
		gattDBAddCharacDescriptorReq_t addCharDescriptor;
		gattDBWriteAttributeReq_t writeAttribute;
		gattDBReadAttributeReq_t readAttribute;
		gattDBFindSeriveHandleReq_t findServiceHandle;
		gattDBFindCharValueHandleInServiceReq_t findCharValueHandleInService;
		gattDBFindCccdHandleForCharValueHandleReq_t findCccdHandleForCharValueHandle;
		gattDBFindDescHandleForCharValueHandleReq_t findDescHandleForCharValueHandle;
	} bleRequestType;
}msgBLEabsToFSCI_t;

typedef PACKED_STRUCT FSCIResponseMsg_tag
{
	uint8_t sync;
	uint8_t opGroup;
	uint8_t opCode;
	uint16_t length;
	union{
		gapCheckNotfStatusResp_t checkNotfStatResp;
		gapAdvEventFailed_t advEventFail;
		GapConfirm_t confirmResp;
		GattConfirm_t gattConfResp;
		gattDBConfirm_t gattDBConfirm;
		gattDBAddPrimServResp_t gattDBAddPrimServResp;
		gattDBAddSecServResp_t gattDBAddSecServResp;
		gattDBAddCharDeclandValResp_t gattDBAddCharDeclandValResp;
		gattDBAddCharDescResp_t gattDBAddCharDescResp;
		gattDBAddCccdResp_t gattDBAddCccdResp;
		gattDBReadAttrResp_t gattDBReadAttrResp;
		gattDBFindServHandleResp_t gattDBFindServHandleResp;
		gattDBFindCharValHandleResp_t gattDBFindCharValHandleResp;
		gattDBFindCccdHandleResp_t  gattDBFindCccdHandleResp;
		gattDBFindDescHandleResp_t gattDBFindDescHandleResp;
	}ResponseType;
	uint8_t crc;
}FSCIResponseMsg_t;

#endif /* BLE_FSCI_H */
