/*
 * Copyright (c) 2015, Freescale Semiconductor, Inc.
 * Copyright 2016-2017 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*System includes.*/
#include "BLE_Abstraction_main.h"
#include "ApplMain.h"
#include "ble_FSCI.h"
#include "gap_interface.h"
#include "fsl_debug_console.h"
/************************************************************************************
*************************************************************************************
* Private memory declarations
*************************************************************************************
************************************************************************************/
gapAdvertisingCallback_t pAdvCallback = NULL;
gapConnectionCallback_t pConnCallback = NULL;

/************************************************************************************
*************************************************************************************
* Public memory declarations
*************************************************************************************
************************************************************************************/
bool_t *isNotfActive = NULL;

bleResult_t Gap_SetAdvertisingParameters
(
    gapAdvertisingParameters_t*   pAdvertisingParameters
)
{
	uint32_t ulNotifiedValue;
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	BaseType_t result;

	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));

	msgToFSCI->opCode = gapSetAdvParameter;
	msgToFSCI->opGroup = bleGAP;
	msgToFSCI->length = sizeof(gapAdvertisingParameters_t);
	msgToFSCI->bleRequestType.advParameter = *pAdvertisingParameters;

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(200));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}

bleResult_t Gap_SetAdvertisingData
(
    gapAdvertisingData_t*         pAdvertisingData,
    gapScanResponseData_t*        pScanResponseData
)
{
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	uint32_t ulNotifiedValue;
	uint8_t data_size = 0;
	osa_status_t result;

	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));

	memset(msgToFSCI, '\0', 52);
	msgToFSCI->opCode = gapSetAdvData;
	msgToFSCI->opGroup = bleGAP;

	if((pAdvertisingData != NULL) && (pScanResponseData == NULL))
	{
		msgToFSCI->bleRequestType.setadvData.cAdvDataInc = 1;
		msgToFSCI->bleRequestType.setadvData.cScanDataInc = 0;
		for(int i = 0; i < pAdvertisingData->cNumAdStructures; i++)
		{
			data_size += pAdvertisingData->aAdStructures[i].length + sizeof(pAdvertisingData->aAdStructures[i].length) +  sizeof(pAdvertisingData->aAdStructures[i].adType);
		}

		msgToFSCI->bleRequestType.setadvData.aAdvData.aAdStructures = malloc(data_size);
		msgToFSCI->bleRequestType.setadvData.aAdvData.cNumAdStructures = pAdvertisingData->cNumAdStructures;

		for(int i = 0; i < pAdvertisingData->cNumAdStructures; i++)
		{
			msgToFSCI->bleRequestType.setadvData.aAdvData.aAdStructures[i].length = pAdvertisingData->aAdStructures[i].length;
			msgToFSCI->bleRequestType.setadvData.aAdvData.aAdStructures[i].adType = pAdvertisingData->aAdStructures[i].adType;

			msgToFSCI->bleRequestType.setadvData.aAdvData.aAdStructures[i].aData = malloc(20);
			memset(msgToFSCI->bleRequestType.setadvData.aAdvData.aAdStructures[i].aData, '\0', sizeof(20));

			for (int j =0; j < pAdvertisingData->aAdStructures[i].length; j++)
			{
				msgToFSCI->bleRequestType.setadvData.aAdvData.aAdStructures[i].aData[j] = pAdvertisingData->aAdStructures[i].aData[j];
			}
		}

		data_size += sizeof(pAdvertisingData->cNumAdStructures);
		data_size += sizeof(msgToFSCI->bleRequestType.setadvData.cAdvDataInc) + sizeof(msgToFSCI->bleRequestType.setadvData.cScanDataInc);
		msgToFSCI->length = data_size;
	}
	else if (pScanResponseData == NULL && pAdvertisingData == NULL)
	{
		msgToFSCI->length = 2;
		msgToFSCI->bleRequestType.setadvData.cAdvDataInc = 0;
		msgToFSCI->bleRequestType.setadvData.cScanDataInc = 0;
	}

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(200));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}

bleResult_t Gap_StartAdvertising
(
    gapAdvertisingCallback_t    advertisingCallback,
    gapConnectionCallback_t     connectionCallback
)
{
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	uint32_t ulNotifiedValue;

	pAdvCallback = advertisingCallback;
	pConnCallback = connectionCallback;

	osa_status_t result;
	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));

	msgToFSCI->opCode = gapStartAdvertisement;
	msgToFSCI->opGroup = bleGAP;
	msgToFSCI->length = 0;

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(200));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}

bleResult_t Gap_StopAdvertising(void)
{
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	uint32_t ulNotifiedValue;

	osa_status_t result;
	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));

	msgToFSCI->opCode = gapStopAdvertisement;
	msgToFSCI->opGroup = bleGAP;
	msgToFSCI->length = 0;

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(200));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}

bleResult_t Gap_CheckNotificationStatus
(
    deviceId_t  deviceId,
    uint16_t    handle,
	bool_t*     pOutIsActive
)
{
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	uint32_t ulNotifiedValue;

	osa_status_t result;
	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));

	msgToFSCI->opCode = gapCheckNotificationStatus;
	msgToFSCI->opGroup = bleGAP;
	msgToFSCI->length = sizeof(gapCheckNotificationStatus_t);
	msgToFSCI->bleRequestType.checkNotificationStatus.deviceId = deviceId;
	msgToFSCI->bleRequestType.checkNotificationStatus.handle = handle;

	isNotfActive = pOutIsActive;

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(500));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}

bleResult_t Gap_Disconnect
(
    deviceId_t  deviceId
)
{
	msgBLEabsToFSCI_t *msgToFSCI = NULL;
	uint32_t ulNotifiedValue;

	osa_status_t result;
	msgToFSCI = malloc(MAX_REQUEST_SIZE * sizeof(uint8_t));

	msgToFSCI->opCode = gapDisconnect;
	msgToFSCI->opGroup = bleGAP;
	msgToFSCI->length = sizeof(gapDisconnect_t);
	msgToFSCI->bleRequestType.disConnect.deviceId = deviceId;

	OSA_MsgQPut(&tx_msg_queue, msgToFSCI);

	/* Signal FSCI thread for message into message queue */
	OSA_EventSet(&eventHandle, gFSCIEvtMsgFromAbs_c);

	result = xTaskNotifyWait(0x00, 0, &ulNotifiedValue, pdMS_TO_TICKS(500));

	free(msgToFSCI);
	msgToFSCI = NULL;

	if(result == pdTRUE)
	{
		return ulNotifiedValue;
	}
	else
	{
		return RESP_TIMEOUT_ERROR;
	}
}
