/* touch.c */

#include "led.h"

#include "fsl_clock.h"
#include "fsl_port.h"
#include "fsl_gpio.h"

void led_init(void)
{
    /* clocks. */
    CLOCK_EnableClock(kCLOCK_PortB);
    CLOCK_EnableClock(kCLOCK_PortD);

    /* pins. */
    PORT_SetPinMux(PORTB, 5u , kPORT_MuxAsGpio); /* R. */
    PORT_SetPinMux(PORTB, 4u , kPORT_MuxAsGpio); /* G. */
    PORT_SetPinMux(PORTD, 1u , kPORT_MuxAsGpio); /* B. */

    /* controller. */
    gpio_pin_config_t gpio_pin_config;
    gpio_pin_config.outputLogic = 1u;
    gpio_pin_config.pinDirection =kGPIO_DigitalOutput;
    GPIO_PinInit(GPIOB, 5u, &gpio_pin_config);
    GPIO_PinInit(GPIOB, 4u, &gpio_pin_config);
    GPIO_PinInit(GPIOD, 1u, &gpio_pin_config);
}

void led_on(uint32_t mask)
{
    if (LED_RED_MASK & mask)
    {
        GPIO_PinWrite(GPIOB, 5u, 0u);
    }
    if (LED_GREEN_MASK & mask)
    {
        GPIO_PinWrite(GPIOB, 4u, 0u);
    }
    if (LED_BLUE_MASK & mask)
    {
        GPIO_PinWrite(GPIOD, 1u, 0u);
    }
}

void led_off(uint32_t mask)
{
    if (LED_RED_MASK & mask)
    {
        GPIO_PinWrite(GPIOB, 5u, 1u);
    }
    if (LED_GREEN_MASK & mask)
    {
        GPIO_PinWrite(GPIOB, 4u, 1u);
    }
    if (LED_BLUE_MASK & mask)
    {
        GPIO_PinWrite(GPIOD, 1u, 1u);
    }
}

/* EOF. */

