/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
******************************************************************************* 
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
********************************************************************************
*
* $File Name: S08math.h$
*
* $Date:      Oct-30-2009$
*
* $Version:   0.0.1.0$
*
* Description:File contains basic mathematical functions
*
*****************************************************************************/
#ifndef _S08MATH_H_
#define _S08MATH_H_

typedef unsigned long UINT64[2];

/* Overtyping due to unified order of input variables */
#define sub8(x,y)				 sub8yx(y,x)
//#define sub16(x,y)			 sub16yx(y,x)
#define usub8(x,y)			 usub8yx(y,x)
//#define usub16(x,y)			 usub16yx(y,x)
#define udiv16_8_16(x,y) udiv16_8_16yx(y,x)

/*****************************************************************************
    Intrinsic functions definition
*****************************************************************************/

signed char add8(signed char x, signed char y);
signed int add16(signed int x, signed int y);
signed long add32_16_32(signed long x, signed int y);
 
unsigned char uadd8(unsigned char x, unsigned char y);
unsigned int uadd16(unsigned int x, unsigned int y);
unsigned long uadd32(unsigned long x, unsigned long y);
void uadd32_64(unsigned long x, UINT64 y);

signed char sub8(signed char x, signed char y);
//signed int sub16(signed int x, signed int y);

unsigned char usub8(unsigned char x, unsigned char y);
//unsigned int usub16(unsigned int x, unsigned int y);

signed int mul8_8_16(signed char x, signed char y);
unsigned int umul16_8_16(unsigned int x, unsigned char y);
void umul32_32_64(unsigned long x, unsigned long y, UINT64 z);

unsigned int udiv16_8_16(unsigned int x, unsigned char y);

signed int shl16_u8_16(signed int x, unsigned char shift);
signed int shr16_u8_16(signed int x, unsigned char shift);

unsigned int ushl16_8_16(unsigned int x, unsigned char shift);
unsigned int ushr16_8_16(unsigned int x, unsigned char shift);

signed char neg8(signed char x);
signed int neg16(signed int x);

unsigned char abs16_8(signed int x);

signed int fshl8_16(unsigned char x);

signed int lim32_16(signed long x);

#endif
