/******************************************************************************
* 
* Copyright (c) 2009 Freescale Semiconductor;
* All Rights Reserved                       
*
*******************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
* THE POSSIBILITY OF SUCH DAMAGE.
*
***************************************************************************/
/*
* @file     control.h
*
* @author   nxa13309
* 
* @version  1.0.0.0
* 
* @date     Oct-14-2016
* 
* @brief    PI controller function
*/
#ifndef _CONTROL_H
#define _CONTROL_H

typedef union
{
    struct
    {
        signed short H;                      /* SHLWord16 High Byte */
        unsigned short L;                      /* SHLWord16 Low Byte*/
    } HL_W16;
    signed long S32;                        /* SWord32 */
}SWord32HL16;

typedef struct
{
  unsigned char propGain;
  signed char propGainShift;
  unsigned char intGain;
  signed char intGainShift;
  signed int lowerLimit;
  signed int upperLimit;
  SWord32HL16 integralPortionK_1_32;
  signed int propk_1;
} CTR_sPIparams;

typedef struct
{
  unsigned char propGain;
  signed char propGainShift;
  unsigned char intGain;
  signed char intGainShift;
  signed int lowerLimit;
  signed int upperLimit;
  signed int integralPortionK_1;
}CTR_sPIparams8;



signed int CTR_ControllerPI16 (signed int error, CTR_sPIparams * pHandle);
signed int CTR_ControllerPI8 (signed char error, CTR_sPIparams8 * pHandle);



#endif  /* _CONTROL_H */
