/*
 * app_config.h
 *
 *  Created on: Nov 19, 2019
 *      Author: nxa13309
 */

#ifndef APP_CONFIG_H_
#define APP_CONFIG_H_

#include "app_init.h"

/* Speed constant  */
#define PP						    2.0	/* pole pairs */
#define N_MAX						100000.0/* RPM */
#define NUMERATOR_FOR_SPEED			(unsigned int)(((PWM_FREQUENCY_KHZ*1000.0*60.0/6.0/PP)/N_MAX)*32768.0)
/*velocity parameters settings*/
#define VELOCITY_MIN_RPM            300.0 /* Minimal velocity [rpm] */
#define VELOCITY_RANGE_MAX_RPM      10000.0/* Scaler velocity [rpm] */                             
#define VELOCITY_MIN (32768*VELOCITY_MIN_RPM/N_MAX)

/* Speed ramp value settings for close loop */
#define SLOW_PERIOD_US    1000.0//us
#define RAMP_SPEED_S    10000.0//(rpm/s)
#define RAMP_SPEED      (RAMP_SPEED_S*SLOW_PERIOD_US*32768.0/1000000.0/N_MAX)

/* Speed loop PI controller parameters */

/* Hardware board constant and protection value */
#define I_MAX				8.25   /* A */
#define U_MAX				22.83  /* V */
#define Over_Voltage		16.0   /* V */
#define Under_Voltage		8.0    /* V */
#define Soft_Over_Current	4.0   /* A */

#define Voltage_MAX (32768*Over_Voltage/U_MAX)
#define Voltage_MIN (32768*Under_Voltage/U_MAX)
#define IDC_MAX (32768*Soft_Over_Current/I_MAX)


/*Hall Sensor inputs */
#define HALL_1       PORT_PTAD & (1<<PORT_PTAD_PTAD0_BITNUM)  //PTA0   /* Hall Sensor 1 */      
#define HALL_2       PORT_PTAD & (1<<PORT_PTAD_PTAD1_BITNUM)  //PTA1   /* Hall Sensor 2 */      
#define HALL_3       PORT_PTAD & (1<<PORT_PTAD_PTAD2_BITNUM)  //PTA2   /* Hall Sensor 3 */      

#endif /* APP_CONFIG_H_ */
