/*
 * app_init.c
 *
 *  Created on: Nov 8, 2019
 *      Author: nxa13309
 */

#include "app_init.h"
#include "common.h"
#include "app_config.h"

/******************************************************************************
* Variable
******************************************************************************/

/******************************************************************************
* Macro
******************************************************************************/


/******************************************************************************
* Functions
******************************************************************************/

/*****************************************************************************//*!
   * @function name: Init_ADC
   *
   * @brief initialize ADC as 12 bit mode, software trigger,enable ADC0
   *        
   * @param  none 
   *
   * @return none
   *
   * @Pass/ Fail criteria: none
   *****************************************************************************/
void Init_ADC(void)
{
	uint8_t temp;

	if (ADC_VDC_CHANNEL < 8)
	{
		temp = ADC_APCTL1;
		temp |= (1<<(ADC_VDC_CHANNEL % 8));
		ADC_APCTL1 = temp;
	}
   else
   	{
		temp = ADC_APCTL2;
		temp |= (1<<(ADC_VDC_CHANNEL - 8));
		ADC_APCTL2 = temp;
   	} //disable IO on ADC
	
	if (ADC_IDC_CHANNEL < 8)
	{
		temp = ADC_APCTL1;
		temp |= (1<<(ADC_IDC_CHANNEL % 8));
		ADC_APCTL1 = temp;
	}
   else
   	{
		temp = ADC_APCTL2;
		temp |= (1<<(ADC_IDC_CHANNEL - 8));
		ADC_APCTL2 = temp;
   	} //disable IO on ADC

	/*select the BUS clock to generate the internal clock ADCK*/
	ADC_SC3_ADICLK = 0x00;
	/*selects the divide ratio to 1 used by the ADC to generate the internal clock ADCK*/
	ADC_SC3_ADIV   = 0x00;
	/* select 12-bit conversion */
	ADC_SC3_MODE   = 0x02;
	/* Long sample time enable*/
	ADC_SC3_ADLSMP = 1;	
	
}

/*****************************************************************************//*!
   * @function name: Init_FTM2
   *
   * @brief initialize FTM For Three Phase BLDC control
   *        
   * @param  none 
   *
   * @return none
   *
   * @Pass/ Fail criteria: none
   *****************************************************************************/
void Init_FTM2( void )
{
	/* Bus clock to the FTM2 module is enabled */
	SYS_SCGC1 |= SYS_SCGC1_FTM2_MASK;

	/*PWM MOD value load*/
	FTM2_MOD = PWM_MODULO;
	
	FTM2_CNT = 0;	     
	/*edge aligned FTM, High-true pulses (clear Output on match) */
    FTM2_C0SC = FTM2_C0SC_MSB_MASK|FTM2_C0SC_ELSB_MASK ;
    FTM2_C1SC = FTM2_C1SC_MSB_MASK|FTM2_C1SC_ELSB_MASK ;
    FTM2_C2SC = FTM2_C2SC_MSB_MASK|FTM2_C2SC_ELSB_MASK ;
    FTM2_C3SC = FTM2_C3SC_MSB_MASK|FTM2_C3SC_ELSB_MASK ;
    FTM2_C4SC = FTM2_C4SC_MSB_MASK|FTM2_C4SC_ELSB_MASK ;
    FTM2_C5SC = FTM2_C5SC_MSB_MASK|FTM2_C5SC_ELSB_MASK ;

    
    FTM2_C0V = 0;                   // duty 0
    FTM2_C1V = 0;                   // duty	0
    FTM2_C2V = 0;                   // duty	0
    FTM2_C3V = 0;                   // duty	0
    FTM2_C4V = 0;                   // duty	0
    FTM2_C5V = 0;                   // duty	0
	/* enable FTM over flow ISR */
	FTM2_SC |= FTM2_SC_TOIE_MASK;
	/* Bus clock to the FTM2 module is selected,CLKS: 01 */
    /* PWM counter start*/
	FTM2_SC |= FTM2_SC_CLKS0_MASK;
	FTM2_SC &= ~FTM2_SC_CLKS1_MASK;
}


/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: HALL_Init
*
* @brief initialize hall signal input.
*        
* @param  none
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void Init_HALL(void)  
{ 
    /* 3 phase HALL input are connected to PTA0/PTA1/PTA2*/
	PORT_PTAIE |= PORT_PTAIE_PTAIE0_MASK | PORT_PTAIE_PTAIE1_MASK | PORT_PTAIE_PTAIE2_MASK;
}

/*****************************************************************************
*
* Function: void IPCInit(void)
*
* Description: Interrupt Priority Controller initialization function
*     
* Returns: None
*
* Global Data:None
*
* Arguments: None
*
* Range Issues: None
*
* Special Issues: None
*
*****************************************************************************/
void IPCInit(void)
{   
	/* IPCE = 1 interrupt generated from the interrupt source is processed by IPC before passing to CPU */
	IPC_SC |= IPC_SC_IPCE_MASK;
	/*MITM1 overflow interrupt priority:0*/
	IPC_ILRS5_ILRn0 = 0;
	/*FTM2 overflow interrupt priority:3*/
	IPC_ILRS3_ILRn0 = 3;
}

/* Initialize ACMP1, ACMP1 interrupt must be enabled when select ACMP1 interrupt as FDS fault input */
void Init_ACMP1(void)
{
    //ACMP_C1_DACVAL = 33;            // when 3.3V powered: 6bit DAC: (34/64)*3.3 = 1.75V
   
    /* OPAMP in FRDM-MC-LVBLDC board, reference voltage: 1.65V, gain: 0.2V/A
     * (DACVAL+1)/64 * Vin = 1.65V + 0.2V/A * Current
     */
    ACMP1_C1_DACVAL = 30;             /* when 5V powered:  6bit DAC: (31/64)*5 = 2.42V,
                                       * limit current set to about 4A as default 
                                       */
                                  
    ACMP1_C1 |= ACMP1_C1_DACEN_MASK | ACMP1_C1_DACREF_MASK;    // enable DAC, select VDDA as the reference

    ACMP1_C0_ACPSEL = 0;              // ACMP positive input: External reference 0(PTA3)
    ACMP1_C0_ACNSEL = 3;              // ACMP negative input: DAC output
//    ACMP1_C2_ACIPE = 0;             // enable ACMP1 input on 

    /* for test purpose, output the ACO to check the ACMP result on falling/rising ACMP interrupt */
    ACMP1_CS_ACOPE = 1;                // ACMP output enable, reading ACO can get ACMP result
    ACMP1_CS_ACMOD = 1;                // ACMP interrupt on output rising edge
    ACMP1_CS_ACIE = 1;                 // enable ACMP interrupt to detect the start bit of SCI0 Rx  
    ACMP1_CS_ACE = 1;                  // enable ACMP
}

/*****************************************************************************//*!
   +FUNCTION----------------------------------------------------------------
   * @function name: MTIM1_Init
   *
   * @brief initialize MTIM1
   *        
   * @param  none 
   *
   * @return none
   *
   * @ Pass/ Fail criteria: none
   *****************************************************************************/
void MTIM1_Init(void)
{
    //MTIM overflow interval: CLKS/PS/MOD = 31.25K/2/16=1.042KHz=~1ms
    MTIM1_CLK_CLKS = 0x01;             // clock source: ICSFFCLK 31.25KHz/2
    MTIM1_CLK_PS   = 0x0;              // prescale: no prescale
    MTIM1_MOD	   = 15;               // modulo value: 16
    MTIM1_SC_TRST  = 1;		           // RST count
    MTIM1_SC_TOIE  = 1;                // enable TOF interrupt
    MTIM1_SC_TSTP  = 1;                // stop count
}


void MTIM1_Start(void)
{
    MTIM1_SC_TSTP   = 0;      // start count
}

void MTIM1_Stop(void)
{
    MTIM1_SC_TSTP   = 1;      // stop count
}


void Init_FDS(void)
{
	FDS_INE_FINE2 = 1;           // enable fault input 2, ACMP1 interrupt input
	
	FDS_PCE_FPCE0 = 1;           // 
	FDS_PCE_FPCE1 = 1;           // 
	FDS_PCE_FPCE2 = 1;           // 
	FDS_PCE_FPCE3 = 1;           // 
	FDS_PCE_FPCE4 = 1;           // 
	FDS_PCE_FPCE5 = 1;           // 
	
	FDS_PCD_FPCD0 = 1;           // output pin FDSOUT7 as output
	FDS_PCD_FPCD1 = 1;           // output pin FDSOUT7 as output
	FDS_PCD_FPCD2 = 1;           // output pin FDSOUT7 as output
	FDS_PCD_FPCD3 = 1;           // output pin FDSOUT7 as output
	FDS_PCD_FPCD4 = 1;           // output pin FDSOUT7 as output
	FDS_PCD_FPCD5 = 1;           // output pin FDSOUT7 as output

	
	FDS_PCV_FPCV0 = 0;           // output 0
	FDS_PCV_FPCV1 = 0;           // output 0
	FDS_PCV_FPCV2 = 0;           // output 0
	FDS_PCV_FPCV3 = 0;           // output 0
	FDS_PCV_FPCV4 = 0;           // output 0
	FDS_PCV_FPCV5 = 0;           // output 0

	FDS_CS_FDF = 0;              // clear FDS interrupt flag
	FDS_CS_FDIE = 0;             // disable FDS interrupt	
	FDS_CS_FDEN = 1;             // FDS enable
}

void Init_OPAMP(void)
{
	/* Configure OPAMP reference to 1/8VDDA, 625mV. */
	SYS_SOPT6_VREFSEL = 0; 
	/* Enable OPAMP */
	SYS_SOPT6_AMPEN =1;
}


void Init_Buttons(void)  
{ 
    /* Configure one mechanical button, connected to PTB2 */
    KBI0_SC_KBIE = 0;                                              // disable the KBI interrupt
    KBI0_SC_KBMOD = 0;                                             // KBI detects edges only
    KBI0_ES &= (~KBI0_ES_KBEDG6_MASK);                             // select the KBI polarity: falling edge
    KBI0_PE = KBI0_PE_KBIPE6_MASK;                                 // enable KBI pin
    KBI0_SC_KBACK = 1;                                             // clear any false interrupt
    KBI0_SC_KBIE  = 0;                                             // disable the KBI interrupt
}
