/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef COMMON_H_
#define COMMON_H_

/*
 * Debug prints ON (#define) or OFF (#undef)
 */
#define DEBUG
#define DEBUG_PRINT

/* 
 * Include the generic CPU header file 
 */
#include "derivative.h" /* include peripheral declarations */
#include <hidef.h> /* for EnableInterrupts macro */

/*
 * Include common type definitions
 */
#include "commonTypes.h"
#define S08PB16_EVK
/* 
 * Include the cpu specific header file 
 */
#if (defined(S08PB16_EVK))
  #include  "board.h"
#endif


// define which SCI port to use
//#define USE_SCI		1

#define NULL                   ((void *) 0)
  /*!< definition of a NULL pointer. */

#define TRUE  1
#define FALSE 0

#if 0
typedef signed char             int8_t;
typedef unsigned char           uint8_t;
typedef signed short            int16_t;
typedef unsigned short          uint16_t;
typedef signed long             int32_t;
typedef unsigned long           uint32_t;
typedef signed long long        int64_t;
typedef unsigned long long      uint64_t;
#endif

// prototypes
void print_sys_log(void) ;

void _IDIVU_STAR08(int i, ...);

void _IMODU_STAR08(int i, ...);

void _IDIVU_8(void);

void _IMODU_8(void);

void _IMUL_STAR08(int i, ...);

void _CALL_STAR08(void);

void _ICMP(int j, ...);

extern void SysPeripheral_Init();

#endif /* #ifndef COMMON_H_ */
