/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/******************************************************************************
*
* @file wcop.c
*
* @author nxf47721
*
* @version 0.0.1
*
* @date Oct 20, 2019
*
* @brief providing APIs for configuring Watchdog (WCOP). 
*   
******************************************************************************/
#include "common.h"
#include "wcop.h"

/*****************************************************************************//*!
+FUNCTION----------------------------------------------------------------
* @function name: wdog_disable
*
* @brief Watchdog timer disable routine
*        
* @param  send	a char to print 
*
* @return none
*
* @ Pass/ Fail criteria: none
*****************************************************************************/

void wdog_disable(void)
{
	/* Disable watch dog */
	SYS_SOPT5 &=~0xC0;
}

#if 0
void wdog_enable(void )
{
	  wdog_unlock();	

		
		/* NOTE: the following write sequence must be completed within 128 bus clocks
		 * 
		 */
		 /* enable watchdog */

		WDOG_CS1 = 0x20 | WDOG_CS1_UPDATE_MASK; 
		         //  | WDOG_CS1_WDOGSE_MASK 
		         //  | WDOG_CS1_WDOGWE_MASK ;		// debug enable
		WDOG_CS2 = 1;	/* use internal 1K clock as clock source */	
		
		WDOG_TOVAL = 0x80FF;
}

#endif
/********************************************************************/


